/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cookie;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.ServerCookieEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;

@Internal
public final class DefaultServerCookieEncoder
implements ServerCookieEncoder {
    private static final String SPACE = " ";
    private static final String EQUAL = "=";
    private static final String SEMICOLON = ";";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'");

    @Override
    @NonNull
    public List<String> encode(Cookie ... cookies) {
        return Arrays.stream(cookies).map(this::encodeCookie).toList();
    }

    @NonNull
    private String encodeCookie(@NonNull Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        sb.append(cookie.getName()).append(EQUAL).append(cookie.getValue());
        if (this.isMaxAgeSet(cookie)) {
            sb.append(SEMICOLON).append(SPACE).append("Max-Age").append(EQUAL).append(cookie.getMaxAge());
            sb.append(SEMICOLON).append(SPACE).append("Expires").append(EQUAL).append(DefaultServerCookieEncoder.expires(cookie.getMaxAge()));
        }
        if (StringUtils.isNotEmpty(cookie.getPath())) {
            sb.append(SEMICOLON).append(SPACE).append("Path").append(EQUAL).append(cookie.getPath());
        }
        if (StringUtils.isNotEmpty(cookie.getDomain())) {
            sb.append(SEMICOLON).append(SPACE).append("Domain").append(EQUAL).append(cookie.getDomain());
        }
        if (cookie.isSecure()) {
            sb.append(SEMICOLON).append(SPACE).append("Secure");
        }
        if (cookie.isHttpOnly()) {
            sb.append(SEMICOLON).append(SPACE).append("HttpOnly");
        }
        cookie.getSameSite().ifPresent(sameSite -> sb.append(SEMICOLON).append(SPACE).append("SameSite").append(EQUAL).append(sameSite));
        return sb.toString();
    }

    private boolean isMaxAgeSet(Cookie cookie) {
        return cookie.getMaxAge() != -1L && cookie.getMaxAge() != Long.MIN_VALUE;
    }

    private static String expires(Long maxAgeSeconds) {
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC).plusSeconds(maxAgeSeconds);
        ZonedDateTime gmtDateTime = ZonedDateTime.of(localDateTime, ZoneOffset.UTC);
        return gmtDateTime.format(FORMATTER);
    }
}

