/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.netty.body.BodySizeLimits;
import io.micronaut.http.netty.body.BufferConsumer;
import io.micronaut.http.netty.body.NettyByteBody;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public final class NettyBodyAdapter
implements BufferConsumer.Upstream,
Subscriber<ByteBuf> {
    private final EventLoopFlow eventLoopFlow;
    private final Publisher<ByteBuf> source;
    @Nullable
    private final Runnable onDiscard;
    private volatile boolean cancelled;
    private volatile Subscription subscription;
    private StreamingNettyByteBody.SharedBuffer sharedBuffer;
    private final AtomicLong demand = new AtomicLong(1L);

    private NettyBodyAdapter(EventLoop eventLoop, Publisher<ByteBuf> source, @Nullable Runnable onDiscard) {
        this.eventLoopFlow = new EventLoopFlow(eventLoop);
        this.source = source;
        this.onDiscard = onDiscard;
    }

    @NonNull
    public static NettyByteBody adapt(@NonNull ByteBody body, @NonNull EventLoop eventLoop) {
        if (body instanceof NettyByteBody) {
            NettyByteBody nbb = (NettyByteBody)body;
            return nbb;
        }
        if (body instanceof AvailableByteBody) {
            AvailableByteBody available = (AvailableByteBody)body;
            return new AvailableNettyByteBody(Unpooled.wrappedBuffer(available.toByteArray()));
        }
        NettyBodyAdapter adapter = new NettyBodyAdapter(eventLoop, NettyByteBody.toByteBufs(body), null);
        adapter.sharedBuffer = new StreamingNettyByteBody.SharedBuffer(eventLoop, BodySizeLimits.UNLIMITED, adapter);
        body.expectedLength().ifPresent(adapter.sharedBuffer::setExpectedLength);
        return new StreamingNettyByteBody(adapter.sharedBuffer);
    }

    public static StreamingNettyByteBody adapt(Publisher<ByteBuf> publisher, EventLoop eventLoop) {
        return NettyBodyAdapter.adapt(publisher, eventLoop, null, null);
    }

    public static StreamingNettyByteBody adapt(Publisher<ByteBuf> publisher, EventLoop eventLoop, @Nullable HttpHeaders headersForLength, @Nullable Runnable onDiscard) {
        NettyBodyAdapter adapter = new NettyBodyAdapter(eventLoop, publisher, onDiscard);
        adapter.sharedBuffer = new StreamingNettyByteBody.SharedBuffer(eventLoop, BodySizeLimits.UNLIMITED, adapter);
        if (headersForLength != null) {
            adapter.sharedBuffer.setExpectedLengthFrom(headersForLength);
        }
        return new StreamingNettyByteBody(adapter.sharedBuffer);
    }

    @Override
    public void start() {
        this.source.subscribe(this);
    }

    @Override
    public void onBytesConsumed(long bytesConsumed) {
        if (bytesConsumed < 0L) {
            throw new IllegalArgumentException("Negative bytes consumed");
        }
        LongUnaryOperator add = l -> l + bytesConsumed < l ? Long.MAX_VALUE : l + bytesConsumed;
        long oldDemand = this.demand.getAndUpdate(add);
        long newDemand = add.applyAsLong(oldDemand);
        if (oldDemand <= 0L && newDemand > 0L) {
            this.subscription.request(1L);
        }
    }

    @Override
    public void allowDiscard() {
        this.cancelled = true;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        if (this.onDiscard != null) {
            this.onDiscard.run();
        }
    }

    @Override
    public void disregardBackpressure() {
        this.demand.set(Long.MAX_VALUE);
        if (this.subscription != null) {
            this.subscription.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onSubscribe(Subscription s2) {
        this.subscription = s2;
        if (this.cancelled) {
            s2.cancel();
        } else {
            s2.request(1L);
        }
    }

    @Override
    public void onNext(ByteBuf bytes) {
        if (this.eventLoopFlow.executeNow(() -> this.onNext0(bytes))) {
            this.onNext0(bytes);
        }
    }

    private void onNext0(ByteBuf bytes) {
        long newDemand = this.demand.addAndGet(-bytes.readableBytes());
        this.sharedBuffer.add(bytes);
        if (newDemand > 0L) {
            this.subscription.request(1L);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.eventLoopFlow.executeNow(() -> this.sharedBuffer.error(t2))) {
            this.sharedBuffer.error(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.eventLoopFlow.executeNow(() -> this.sharedBuffer.complete())) {
            this.sharedBuffer.complete();
        }
    }
}

