/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.binding;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.propagation.MutablePropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.filter.FilterArgumentBinderPredicate;
import io.micronaut.web.router.RouteMatch;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public final class RouteMatchArgumentBinder
implements TypedRequestArgumentBinder<RouteMatch<?>>,
FilterArgumentBinderPredicate {
    RouteMatchArgumentBinder() {
    }

    @Override
    public Argument<RouteMatch<?>> argumentType() {
        return Argument.of(RouteMatch.class);
    }

    @Override
    public ArgumentBinder.BindingResult<RouteMatch<?>> bind(ArgumentConversionContext<RouteMatch<?>> context, HttpRequest<?> source) {
        Optional<RouteMatch> match = source.getAttribute(HttpAttributes.ROUTE_MATCH).map(r -> (RouteMatch)r);
        return () -> match;
    }

    @Override
    public boolean test(Argument<?> argument, MutablePropagatedContext mutablePropagatedContext, HttpRequest<?> request, @Nullable HttpResponse<?> response, @Nullable Throwable failure) {
        return argument.isNullable() || request.getAttribute(HttpAttributes.ROUTE_MATCH).isPresent();
    }
}

