/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions.response;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.server.exceptions.response.HtmlErrorResponseBodyProvider;
import io.micronaut.http.server.exceptions.response.JsonErrorResponseBodyProvider;
import jakarta.inject.Singleton;

@Internal
@Singleton
@Requires(missingBeans={ErrorResponseProcessor.class})
final class DefaultErrorResponseProcessor
implements ErrorResponseProcessor {
    private final JsonErrorResponseBodyProvider<?> jsonBodyErrorResponseProvider;
    private final HtmlErrorResponseBodyProvider htmlBodyErrorResponseProvider;

    DefaultErrorResponseProcessor(JsonErrorResponseBodyProvider<?> jsonBodyErrorResponseProvider, HtmlErrorResponseBodyProvider htmlBodyErrorResponseProvider) {
        this.jsonBodyErrorResponseProvider = jsonBodyErrorResponseProvider;
        this.htmlBodyErrorResponseProvider = htmlBodyErrorResponseProvider;
    }

    public MutableHttpResponse processResponse(ErrorContext errorContext, MutableHttpResponse response) {
        boolean isError;
        HttpRequest<?> request = errorContext.getRequest();
        if (request.getMethod() == HttpMethod.HEAD) {
            return response;
        }
        boolean bl = isError = response.status().getCode() >= 400;
        if (isError && request.accept().stream().anyMatch(mediaType -> mediaType.equals(MediaType.TEXT_HTML_TYPE)) && request.accept().stream().noneMatch(m4 -> m4.matchesExtension("json"))) {
            return response.body(this.htmlBodyErrorResponseProvider.body(errorContext, response)).contentType(this.htmlBodyErrorResponseProvider.contentType());
        }
        return response.body(this.jsonBodyErrorResponseProvider.body(errorContext, response)).contentType(this.jsonBodyErrorResponseProvider.contentType());
    }
}

