/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import java.util.ArrayList;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
public final class HttpContentProcessorAsReactiveProcessor {
    private HttpContentProcessorAsReactiveProcessor() {
    }

    @NonNull
    public static <T> Flux<T> asPublisher(FormDataHttpContentProcessor processor, Publisher<HttpContent> streamed) {
        return Flux.concat(Flux.from(streamed).doOnError(e -> {
            try {
                processor.cancel();
            }
            catch (Throwable ex) {
                e.addSuppressed(ex);
            }
        }).concatMap(c -> {
            try {
                ArrayList out = new ArrayList(1);
                processor.add((ByteBufHolder)c, out);
                return Flux.fromIterable(out);
            }
            catch (Throwable e) {
                c.touch();
                return Flux.error(e);
            }
        }), Flux.defer(() -> {
            try {
                ArrayList out = new ArrayList(1);
                processor.complete(out);
                return Flux.fromIterable(out);
            }
            catch (Throwable ex) {
                return Flux.error(ex);
            }
        }));
    }
}

