/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
abstract class AbstractFileBodyWriter {
    private static final String[] ENTITY_HEADERS = new String[]{"Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Expires", "Last-Modified"};
    protected final NettyHttpServerConfiguration.FileTypeHandlerConfiguration configuration;

    AbstractFileBodyWriter(NettyHttpServerConfiguration.FileTypeHandlerConfiguration configuration) {
        this.configuration = configuration;
    }

    private static void copyNonEntityHeaders(MutableHttpResponse<?> from, MutableHttpResponse to) {
        from.getHeaders().forEachValue((header, value) -> {
            if (Arrays.binarySearch(ENTITY_HEADERS, header) < 0) {
                to.getHeaders().add((CharSequence)header, (CharSequence)value);
            }
        });
    }

    protected boolean handleIfModifiedAndHeaders(HttpRequest<?> request, MutableHttpResponse<?> response, FileCustomizableResponseType systemFile, MutableHttpResponse<?> nettyResponse) {
        long fileLastModifiedSeconds;
        long ifModifiedSinceDateSeconds;
        long lastModified = systemFile.getLastModified();
        ZonedDateTime ifModifiedSince = request.getHeaders().getDate("If-Modified-Since");
        if (ifModifiedSince != null && (ifModifiedSinceDateSeconds = ifModifiedSince.toEpochSecond()) == (fileLastModifiedSeconds = lastModified / 1000L)) {
            return true;
        }
        if (!response.getHeaders().contains("Content-Type")) {
            response.header("Content-Type", systemFile.getMediaType().toString());
        }
        this.setDateAndCacheHeaders(response, lastModified);
        systemFile.process(nettyResponse);
        return false;
    }

    protected void setDateAndCacheHeaders(MutableHttpResponse response, long lastModified) {
        HttpHeaders headers = response.getHeaders();
        LocalDateTime now = LocalDateTime.now();
        if (!headers.contains("Date")) {
            headers.date(now);
        }
        LocalDateTime cacheSeconds = now.plus(this.configuration.getCacheSeconds(), ChronoUnit.SECONDS);
        if (response.header("Expires") == null) {
            headers.expires(cacheSeconds);
        }
        if (response.header("Cache-Control") == null) {
            NettyHttpServerConfiguration.FileTypeHandlerConfiguration.CacheControlConfiguration cacheConfig = this.configuration.getCacheControl();
            StringBuilder header = new StringBuilder(cacheConfig.getPublic() ? "public" : "private").append(", max-age=").append(this.configuration.getCacheSeconds());
            response.header("Cache-Control", header.toString());
        }
        if (response.header("Last-Modified") == null) {
            headers.lastModified(lastModified);
        }
    }

    protected void setDateHeader(MutableHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        LocalDateTime now = LocalDateTime.now();
        headers.date(now);
    }

    protected ByteBodyHttpResponse<?> notModified(MutableHttpResponse<?> originalResponse) {
        MutableHttpResponse response = HttpResponse.notModified();
        AbstractFileBodyWriter.copyNonEntityHeaders(originalResponse, response);
        this.setDateHeader(response);
        return ByteBodyHttpResponseWrapper.wrap(response, AvailableNettyByteBody.empty());
    }
}

