/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.handler.accesslog.Http2AccessLogManager;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLog;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;

@Internal
public final class Http2AccessLogConnectionEncoder
extends DecoratingHttp2ConnectionEncoder {
    private final Http2AccessLogManager manager;

    public Http2AccessLogConnectionEncoder(Http2ConnectionEncoder delegate, Http2AccessLogManager manager) {
        super(delegate);
        this.manager = manager;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        promise = this.writeHeaders0(ctx, streamId, headers, endStream, promise);
        return super.writeHeaders(ctx, streamId, headers, padding, endStream, promise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise) {
        promise = this.writeHeaders0(ctx, streamId, headers, endStream, promise);
        return super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream, promise);
    }

    private ChannelPromise writeHeaders0(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endStream, ChannelPromise promise) {
        HttpResponse response;
        if (AsciiString.contentEquals(headers.status(), HttpResponseStatus.CONTINUE.codeAsText())) {
            return promise;
        }
        AccessLog accessLog = (AccessLog)this.manager.connection.stream(streamId).getProperty(this.manager.accessLogKey);
        if (accessLog == null) {
            return promise;
        }
        try {
            response = HttpConversionUtil.toHttpResponse(streamId, headers, false);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
        accessLog.onResponseHeaders(ctx, response.headers(), response.status().codeAsText().toString());
        if (endStream) {
            accessLog.onLastResponseWrite(0);
            promise = promise.unvoid();
            this.finish(accessLog, promise);
        }
        return promise;
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream, ChannelPromise promise) {
        AccessLog accessLog = (AccessLog)this.manager.connection.stream(streamId).getProperty(this.manager.accessLogKey);
        if (accessLog != null) {
            if (endStream) {
                accessLog.onLastResponseWrite(data.readableBytes());
                promise = promise.unvoid();
                this.finish(accessLog, promise);
            } else {
                accessLog.onResponseWrite(data.readableBytes());
            }
        }
        return super.writeData(ctx, streamId, data, padding, endStream, promise);
    }

    private void finish(AccessLog accessLog, ChannelPromise promise) {
        promise.addListener(future -> {
            if (future.isSuccess()) {
                accessLog.log(this.manager.logger);
                this.manager.logForReuse = accessLog;
            }
        });
    }
}

