/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.simple;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.cookie.ServerCookieEncoder;
import io.micronaut.http.simple.SimpleHttpHeaders;
import io.micronaut.http.simple.cookies.SimpleCookies;
import java.util.Optional;
import java.util.Set;

@TypeHint(value={SimpleHttpResponse.class})
class SimpleHttpResponse<B>
implements MutableHttpResponse<B> {
    private final MutableHttpHeaders headers = new SimpleHttpHeaders(ConversionService.SHARED);
    private final SimpleCookies cookies = new SimpleCookies(ConversionService.SHARED);
    private final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap<Object>();
    private int status = HttpStatus.OK.getCode();
    private String reason = HttpStatus.OK.getReason();
    private Object body;

    SimpleHttpResponse() {
    }

    @Override
    public MutableHttpResponse<B> cookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
        this.updateCookies();
        return this;
    }

    private void updateCookies() {
        this.headers.remove("Set-Cookie");
        for (Cookie cookie : this.cookies.getAll()) {
            ServerCookieEncoder.INSTANCE.encode(cookie).forEach(c -> this.headers.add((CharSequence)"Set-Cookie", (CharSequence)c));
        }
    }

    @Override
    public MutableHttpResponse<B> cookies(Set<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.cookies.put(cookie.getName(), cookie);
        }
        this.updateCookies();
        return this;
    }

    @Override
    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    @Override
    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        this.body = body;
        return this;
    }

    @Override
    public int code() {
        return this.status;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public MutableHttpResponse<B> status(int status, CharSequence message) {
        this.status = status;
        this.reason = message == null ? HttpStatus.getDefaultReason(status) : message.toString();
        return this;
    }

    @Override
    public Cookies getCookies() {
        return this.cookies;
    }
}

