/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.uri.UriTemplateParser;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
final class UriTemplateExpander
implements UriTemplateParser.PartVisitor {
    private final Map<String, Object> parameters;
    private final StringBuilder builder = new StringBuilder();
    private boolean queryStarted;
    private boolean hashStarted;
    private boolean needsSeparator;

    UriTemplateExpander(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void visitLiteral(String literal) {
        this.builder.append(literal);
    }

    @Override
    public void visitExpression(UriTemplateParser.ExpressionType type, List<UriTemplateParser.Variable> variables) {
        for (UriTemplateParser.Variable variable : variables) {
            this.appendValue(type, variable);
        }
        this.needsSeparator = false;
    }

    public String toString() {
        return this.builder.toString();
    }

    private void appendValue(UriTemplateParser.ExpressionType type, UriTemplateParser.Variable variable) {
        List<Object> value = this.parameters.get(variable.name());
        if (value instanceof Optional) {
            Optional optional = (Optional)((Object)value);
            v0 = optional.orElse(null);
        } else {
            v0 = value = value;
        }
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        if (variable.explode()) {
            value = this.expandPOJO(value);
        }
        if (value instanceof Iterable) {
            Iterable iterable = value;
            List<String> values = this.asListOfString(iterable);
            if (!values.isEmpty()) {
                this.appendListValues(type, variable, values);
            }
        } else if (value instanceof Map) {
            Map map = (Map)((Object)value);
            if (map.isEmpty()) {
                return;
            }
            List<Map.Entry<String, List<String>>> mapOfStrings = map.entrySet().stream().filter(e -> e.getValue() != null).map(e -> Map.entry(e.getKey().toString(), this.asListOfString(e.getValue()))).filter(e -> !((List)e.getValue()).isEmpty()).toList();
            this.appendMapValues(type, variable, mapOfStrings);
        } else {
            this.appendValue(type, variable, value.toString());
        }
    }

    private List<String> asListOfString(Object some) {
        List<String> list;
        if (some instanceof Iterable) {
            Iterable i = (Iterable)some;
            list = CollectionUtils.iterableToList(i).stream().filter(Objects::nonNull).map(String::valueOf).toList();
        } else {
            list = List.of(some.toString());
        }
        return list;
    }

    private void appendMapValues(UriTemplateParser.ExpressionType type, UriTemplateParser.Variable variable, List<Map.Entry<String, List<String>>> entries) {
        if (variable.explode()) {
            for (Map.Entry<String, List<String>> entry : entries) {
                this.appendKeyValues(type, variable, entry.getKey(), entry.getValue());
            }
            return;
        }
        if (type.isQueryPart()) {
            this.appendKeyValues(type, variable, variable.name(), this.aggregate(entries));
        } else {
            this.appendOperator(type);
            this.appendValues(type, variable, this.aggregate(entries));
        }
    }

    private List<String> aggregate(List<Map.Entry<String, List<String>>> entries) {
        return entries.stream().flatMap(e -> Stream.concat(Stream.of((String)e.getKey()), ((List)e.getValue()).stream())).toList();
    }

    private void appendListValues(UriTemplateParser.ExpressionType type, UriTemplateParser.Variable variable, List<String> values) {
        if (variable.explode()) {
            for (String value : values) {
                this.appendValue(type, variable, value);
            }
            return;
        }
        if (type.isQueryPart()) {
            this.appendKeyValues(type, variable, variable.name(), values);
        } else {
            this.appendOperator(type);
            this.appendValues(type, variable, values);
        }
    }

    private void appendKeyValues(UriTemplateParser.ExpressionType type, UriTemplateParser.Variable variable, String key, List<String> values) {
        this.appendOperator(type);
        this.builder.append(key).append('=');
        this.appendValues(type, variable, values);
    }

    private void appendValues(UriTemplateParser.ExpressionType type, UriTemplateParser.Variable variable, List<String> values) {
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            value = this.applyModifier(value, variable.modifier());
            this.builder.append(type.isEncode() ? this.encode(value, type.isQueryPart()) : this.escape(value));
            if (!iterator.hasNext()) continue;
            this.builder.append(',');
        }
    }

    private void appendValue(UriTemplateParser.ExpressionType type, UriTemplateParser.Variable variable, String value) {
        value = this.applyModifier(value, variable.modifier());
        this.appendOperator(type);
        if (type.isQueryPart()) {
            this.builder.append(variable.name());
            if (StringUtils.isNotEmpty(value) || type != UriTemplateParser.ExpressionType.PATH_STYLE_PARAMETER_EXPANSION) {
                this.builder.append('=').append(this.encode(value, true));
            }
        } else {
            this.builder.append(type.isEncode() ? this.encode(value, false) : this.escape(value));
        }
    }

    private void appendOperator(UriTemplateParser.ExpressionType type) {
        char separator = type.getSeparator();
        if (type == UriTemplateParser.ExpressionType.NONE) {
            this.appendSeparator(type, separator);
        } else if (type == UriTemplateParser.ExpressionType.FORM_STYLE_PARAMETER_EXPANSION) {
            this.builder.append(this.queryParamSeparator());
        } else {
            this.appendSeparator(type, separator);
            if (type == UriTemplateParser.ExpressionType.FRAGMENT_EXPANSION) {
                if (!this.hashStarted) {
                    this.hashStarted = true;
                    this.builder.append(type.getOperator());
                }
            } else if (type != UriTemplateParser.ExpressionType.RESERVED_EXPANSION) {
                this.builder.append(type.getOperator());
            }
        }
    }

    private void appendSeparator(UriTemplateParser.ExpressionType type, char separator) {
        if (!this.needsSeparator) {
            this.needsSeparator = true;
        } else if (separator != type.getOperator()) {
            this.builder.append(separator);
        }
    }

    private char queryParamSeparator() {
        if (this.queryStarted) {
            return '&';
        }
        this.queryStarted = true;
        return '?';
    }

    private String applyModifier(String value, String modifier) {
        if (modifier == null) {
            return value;
        }
        try {
            int limit = Integer.parseInt(modifier.trim(), 10);
            if (limit < value.length()) {
                return value.substring(0, limit);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    private String encode(String str, boolean query) {
        String encoded = URLEncoder.encode(str, StandardCharsets.UTF_8);
        return query ? encoded : encoded.replace("+", "%20");
    }

    private String escape(String v) {
        return v.replace("%", "%25").replaceAll("\\s", "%20");
    }

    private Object expandPOJO(Object found) {
        if (found instanceof Iterable || found instanceof Map) {
            return found;
        }
        if (found == null || ClassUtils.isJavaLangType(found.getClass())) {
            return found;
        }
        return BeanMap.of(found);
    }
}

