/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;

@Internal
final class NoneQualifier<T>
extends FilteringQualifier<T> {
    public static final NoneQualifier INSTANCE = new NoneQualifier();

    private NoneQualifier() {
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        if (candidate instanceof BeanDefinition) {
            BeanDefinition beanDefinition = (BeanDefinition)candidate;
            return beanDefinition.getDeclaredQualifier() == null;
        }
        return !AnnotationUtil.hasDeclaredQualifierAnnotation(candidate.getAnnotationMetadata());
    }

    public String toString() {
        return "None";
    }
}

