/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.BigDecimalSerde;
import io.micronaut.serde.support.serdes.BigIntegerSerde;
import io.micronaut.serde.support.serdes.BooleanArraySerde;
import io.micronaut.serde.support.serdes.BooleanSerde;
import io.micronaut.serde.support.serdes.ByteArraySerde;
import io.micronaut.serde.support.serdes.ByteBufferSerde;
import io.micronaut.serde.support.serdes.ByteSerde;
import io.micronaut.serde.support.serdes.CharArraySerde;
import io.micronaut.serde.support.serdes.CharSerde;
import io.micronaut.serde.support.serdes.CharsetSerde;
import io.micronaut.serde.support.serdes.DateSerde;
import io.micronaut.serde.support.serdes.DoubleArraySerde;
import io.micronaut.serde.support.serdes.DoubleSerde;
import io.micronaut.serde.support.serdes.DurationSerde;
import io.micronaut.serde.support.serdes.EnumSerde;
import io.micronaut.serde.support.serdes.FloatArraySerde;
import io.micronaut.serde.support.serdes.FloatSerde;
import io.micronaut.serde.support.serdes.InetAddressSerde;
import io.micronaut.serde.support.serdes.InstantSerde;
import io.micronaut.serde.support.serdes.IntArraySerde;
import io.micronaut.serde.support.serdes.IntegerSerde;
import io.micronaut.serde.support.serdes.JsonNodeSerde;
import io.micronaut.serde.support.serdes.LocalDateSerde;
import io.micronaut.serde.support.serdes.LocalDateTimeSerde;
import io.micronaut.serde.support.serdes.LocalTimeSerde;
import io.micronaut.serde.support.serdes.LocaleSerde;
import io.micronaut.serde.support.serdes.LongArraySerde;
import io.micronaut.serde.support.serdes.LongSerde;
import io.micronaut.serde.support.serdes.NumberTypeSerde;
import io.micronaut.serde.support.serdes.OffsetDateTimeSerde;
import io.micronaut.serde.support.serdes.OptionalDoubleSerde;
import io.micronaut.serde.support.serdes.OptionalIntSerde;
import io.micronaut.serde.support.serdes.OptionalLongSerde;
import io.micronaut.serde.support.serdes.OptionalSerde;
import io.micronaut.serde.support.serdes.PeriodSerde;
import io.micronaut.serde.support.serdes.ShortArraySerde;
import io.micronaut.serde.support.serdes.ShortSerde;
import io.micronaut.serde.support.serdes.SqlDateSerde;
import io.micronaut.serde.support.serdes.SqlTimestampSerde;
import io.micronaut.serde.support.serdes.StringArraySerde;
import io.micronaut.serde.support.serdes.StringSerde;
import io.micronaut.serde.support.serdes.TimeZoneSerde;
import io.micronaut.serde.support.serdes.URISerde;
import io.micronaut.serde.support.serdes.URLSerde;
import io.micronaut.serde.support.serdes.UUIDSerde;
import io.micronaut.serde.support.serdes.YearSerde;
import io.micronaut.serde.support.serdes.ZonedDateTimeSerde;
import java.util.List;
import java.util.function.Consumer;

@Internal
public final class Serdes {
    public static final IntegerSerde INTEGER_SERDE = new IntegerSerde();
    public static final LongSerde LONG_SERDE = new LongSerde();
    public static final ShortSerde SHORT_SERDE = new ShortSerde();
    public static final FloatSerde FLOAT_SERDE = new FloatSerde();
    public static final ByteSerde BYTE_SERDE = new ByteSerde();
    public static final DoubleSerde DOUBLE_SERDE = new DoubleSerde();
    public static final OptionalIntSerde OPTIONAL_INT_SERDE = new OptionalIntSerde();
    public static final OptionalDoubleSerde OPTIONAL_DOUBLE_SERDE = new OptionalDoubleSerde();
    public static final OptionalLongSerde OPTIONAL_LONG_SERDE = new OptionalLongSerde();
    public static final BigDecimalSerde BIG_DECIMAL_SERDE = new BigDecimalSerde();
    public static final BigIntegerSerde BIG_INTEGER_SERDE = new BigIntegerSerde();
    public static final UUIDSerde UUID_SERDE = new UUIDSerde();
    public static final URLSerde URL_SERDE = new URLSerde();
    public static final URISerde URI_SERDE = new URISerde();
    public static final CharsetSerde CHARSET_SERDE = new CharsetSerde();
    public static final TimeZoneSerde TIME_ZONE_SERDE = new TimeZoneSerde();
    public static final LocaleSerde LOCALE_SERDE = new LocaleSerde();
    public static final IntArraySerde INT_ARRAY_SERDE = new IntArraySerde();
    public static final LongArraySerde LONG_ARRAY_SERDE = new LongArraySerde();
    public static final FloatArraySerde FLOAT_ARRAY_SERDE = new FloatArraySerde();
    public static final ShortArraySerde SHORT_ARRAY_SERDE = new ShortArraySerde();
    public static final DoubleArraySerde DOUBLE_ARRAY_SERDE = new DoubleArraySerde();
    public static final BooleanArraySerde BOOLEAN_ARRAY_SERDE = new BooleanArraySerde();
    public static final ByteArraySerde BYTE_ARRAY_SERDE = new ByteArraySerde(true);
    public static final CharArraySerde CHAR_ARRAY_SERDE = new CharArraySerde();
    public static final StringSerde STRING_SERDE = new StringSerde();
    public static final BooleanSerde BOOLEAN_SERDE = new BooleanSerde();
    public static final CharSerde CHAR_SERDE = new CharSerde();
    public static final List<SerdeRegistrar<?>> LEGACY_DEFAULT_SERDES = List.of(BOOLEAN_SERDE, BYTE_SERDE, CHAR_SERDE, DOUBLE_SERDE, FLOAT_SERDE, INTEGER_SERDE, LONG_SERDE, SHORT_SERDE, STRING_SERDE, OPTIONAL_INT_SERDE, OPTIONAL_DOUBLE_SERDE, OPTIONAL_LONG_SERDE, BIG_DECIMAL_SERDE, BIG_INTEGER_SERDE, UUID_SERDE, URL_SERDE, URI_SERDE, CHARSET_SERDE, TIME_ZONE_SERDE, LOCALE_SERDE, INT_ARRAY_SERDE, LONG_ARRAY_SERDE, FLOAT_ARRAY_SERDE, SHORT_ARRAY_SERDE, DOUBLE_ARRAY_SERDE, BOOLEAN_ARRAY_SERDE, CHAR_ARRAY_SERDE);
    private static final List<SerdeRegistrar<?>> SERDES = List.of(new DurationSerde(), new JsonNodeSerde(), new PeriodSerde(), new ByteBufferSerde(), new StringArraySerde(), new OptionalSerde(), new NumberTypeSerde());

    public static void register(SerdeConfiguration serdeConfiguration, SerdeIntrospections introspections, Consumer<SerdeRegistrar<?>> consumer) {
        LEGACY_DEFAULT_SERDES.forEach(consumer);
        consumer.accept(new ByteArraySerde(serdeConfiguration));
        SERDES.forEach(consumer);
        InstantSerde instantSerde = new InstantSerde(serdeConfiguration);
        consumer.accept(instantSerde);
        consumer.accept(new DateSerde(instantSerde));
        LocalDateSerde localDateSerde = new LocalDateSerde(serdeConfiguration);
        consumer.accept(localDateSerde);
        consumer.accept(new LocalTimeSerde(serdeConfiguration));
        consumer.accept(new LocalDateTimeSerde(serdeConfiguration));
        consumer.accept(new OffsetDateTimeSerde(serdeConfiguration));
        consumer.accept(new SqlDateSerde(localDateSerde));
        consumer.accept(new SqlTimestampSerde(instantSerde));
        consumer.accept(new YearSerde());
        consumer.accept(new ZonedDateTimeSerde(serdeConfiguration));
        consumer.accept(new EnumSerde(introspections));
        consumer.accept(new InetAddressSerde(serdeConfiguration));
    }
}

