/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;
import org.testcontainers.shaded.org.apache.commons.lang3.exception.ExceptionUtils;
import org.testcontainers.utility.ClasspathScanner;
import org.testcontainers.utility.DockerImageName;

public class TestcontainersConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TestcontainersConfiguration.class);
    private final Object $lock = new Object[0];
    private static String PROPERTIES_FILE_NAME = "testcontainers.properties";
    private static File USER_CONFIG_FILE = new File(System.getProperty("user.home"), "." + PROPERTIES_FILE_NAME);
    private static final String AMBASSADOR_IMAGE = "richnorth/ambassador";
    private static final String SOCAT_IMAGE = "alpine/socat";
    private static final String VNC_RECORDER_IMAGE = "testcontainers/vnc-recorder";
    private static final String COMPOSE_IMAGE = "docker/compose";
    private static final String ALPINE_IMAGE = "alpine";
    private static final String RYUK_IMAGE = "testcontainers/ryuk";
    private static final String KAFKA_IMAGE = "confluentinc/cp-kafka";
    private static final String PULSAR_IMAGE = "apachepulsar/pulsar";
    private static final String LOCALSTACK_IMAGE = "localstack/localstack";
    private static final String SSHD_IMAGE = "testcontainers/sshd";
    private static final String ORACLE_IMAGE = "gvenzl/oracle-xe";
    private static final ImmutableMap<DockerImageName, String> CONTAINER_MAPPING = ImmutableMap.builder().put(DockerImageName.parse("richnorth/ambassador"), "ambassador.container.image").put(DockerImageName.parse("alpine/socat"), "socat.container.image").put(DockerImageName.parse("testcontainers/vnc-recorder"), "vncrecorder.container.image").put(DockerImageName.parse("docker/compose"), "compose.container.image").put(DockerImageName.parse("alpine"), "tinyimage.container.image").put(DockerImageName.parse("testcontainers/ryuk"), "ryuk.container.image").put(DockerImageName.parse("confluentinc/cp-kafka"), "kafka.container.image").put(DockerImageName.parse("apachepulsar/pulsar"), "pulsar.container.image").put(DockerImageName.parse("localstack/localstack"), "localstack.container.image").put(DockerImageName.parse("testcontainers/sshd"), "sshd.container.image").put(DockerImageName.parse("gvenzl/oracle-xe"), "oracle.container.image").build();
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Properties userProperties;
    private final Properties classpathProperties;
    private final Map<String, String> environment;

    @VisibleForTesting
    static AtomicReference<TestcontainersConfiguration> getInstanceField() {
        return instance;
    }

    TestcontainersConfiguration(Properties userProperties, Properties classpathProperties, Map<String, String> environment) {
        this.userProperties = userProperties;
        this.classpathProperties = classpathProperties;
        this.environment = environment;
    }

    @Deprecated
    public String getAmbassadorContainerImage() {
        return this.getImage(AMBASSADOR_IMAGE).asCanonicalNameString();
    }

    @Deprecated
    public String getSocatContainerImage() {
        return this.getImage(SOCAT_IMAGE).asCanonicalNameString();
    }

    @Deprecated
    public String getVncRecordedContainerImage() {
        return this.getImage(VNC_RECORDER_IMAGE).asCanonicalNameString();
    }

    @Deprecated
    public String getDockerComposeContainerImage() {
        return this.getImage(COMPOSE_IMAGE).asCanonicalNameString();
    }

    @Deprecated
    public String getTinyImage() {
        return this.getImage(ALPINE_IMAGE).asCanonicalNameString();
    }

    public boolean isRyukPrivileged() {
        return Boolean.parseBoolean(this.getEnvVarOrProperty("ryuk.container.privileged", "true"));
    }

    @Deprecated
    public String getRyukImage() {
        return this.getImage(RYUK_IMAGE).asCanonicalNameString();
    }

    @Deprecated
    public String getSSHdImage() {
        return this.getImage(SSHD_IMAGE).asCanonicalNameString();
    }

    public Integer getRyukTimeout() {
        return Integer.parseInt(this.getEnvVarOrProperty("ryuk.container.timeout", "30"));
    }

    @Deprecated
    public String getKafkaImage() {
        return this.getImage(KAFKA_IMAGE).asCanonicalNameString();
    }

    @Deprecated
    public String getOracleImage() {
        return this.getImage(ORACLE_IMAGE).asCanonicalNameString();
    }

    @Deprecated
    public String getPulsarImage() {
        return this.getImage(PULSAR_IMAGE).asCanonicalNameString();
    }

    @Deprecated
    public String getLocalStackImage() {
        return this.getImage(LOCALSTACK_IMAGE).asCanonicalNameString();
    }

    public boolean isDisableChecks() {
        return Boolean.parseBoolean(this.getEnvVarOrUserProperty("checks.disable", "false"));
    }

    public boolean environmentSupportsReuse() {
        return Boolean.parseBoolean(this.getEnvVarOrUserProperty("testcontainers.reuse.enable", "false"));
    }

    public String getDockerClientStrategyClassName() {
        String prefixedEnvVarStrategy = this.environment.get("TESTCONTAINERS_DOCKER_CLIENT_STRATEGY");
        if (prefixedEnvVarStrategy != null) {
            return prefixedEnvVarStrategy;
        }
        return this.getEnvVarOrUserProperty("docker.client.strategy", null);
    }

    public String getTransportType() {
        return this.getEnvVarOrProperty("transport.type", "httpclient5");
    }

    public Integer getImagePullPauseTimeout() {
        return Integer.parseInt(this.getEnvVarOrProperty("pull.pause.timeout", "30"));
    }

    public Integer getImagePullTimeout() {
        return Integer.parseInt(this.getEnvVarOrProperty("pull.timeout", "120"));
    }

    public String getImageSubstitutorClassName() {
        return this.getEnvVarOrProperty("image.substitutor", null);
    }

    public String getImagePullPolicy() {
        return this.getEnvVarOrProperty("pull.policy", null);
    }

    public Integer getClientPingTimeout() {
        return Integer.parseInt(this.getEnvVarOrProperty("client.ping.timeout", "10"));
    }

    @Nullable
    @Contract(value="_, !null, _ -> !null")
    private String getConfigurable(@NotNull String propertyName, @Nullable String defaultValue, Properties ... propertiesSources) {
        String value;
        String envVarName = propertyName.replaceAll("\\.", "_").toUpperCase();
        if (!envVarName.startsWith("TESTCONTAINERS_") && !envVarName.startsWith("DOCKER_")) {
            envVarName = "TESTCONTAINERS_" + envVarName;
        }
        if (this.environment.containsKey(envVarName) && !(value = this.environment.get(envVarName)).isEmpty()) {
            return value;
        }
        for (Properties properties : propertiesSources) {
            if (properties.get(propertyName) == null) continue;
            return (String)properties.get(propertyName);
        }
        return defaultValue;
    }

    @Contract(value="_, !null -> !null")
    public String getEnvVarOrProperty(@NotNull String propertyName, @Nullable String defaultValue) {
        return this.getConfigurable(propertyName, defaultValue, this.userProperties, this.classpathProperties);
    }

    @Contract(value="_, !null -> !null")
    public String getEnvVarOrUserProperty(@NotNull String propertyName, @Nullable String defaultValue) {
        return this.getConfigurable(propertyName, defaultValue, this.userProperties);
    }

    @Contract(value="_, !null -> !null")
    public String getUserProperty(@NotNull String propertyName, @Nullable String defaultValue) {
        return this.userProperties.get(propertyName) != null ? (String)this.userProperties.get(propertyName) : defaultValue;
    }

    @Deprecated
    public Properties getProperties() {
        return Stream.of(this.userProperties, this.classpathProperties).reduce(new Properties(), (a, b) -> {
            a.putAll((Map<?, ?>)b);
            return a;
        });
    }

    @Deprecated
    public boolean updateGlobalConfig(@NonNull String prop, @NonNull String value) {
        if (prop == null) {
            throw new NullPointerException("prop is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.updateUserConfig(prop, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUserConfig(@NonNull String prop, @NonNull String value) {
        Object object = this.$lock;
        synchronized (object) {
            if (prop == null) {
                throw new NullPointerException("prop is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            try {
                if (value.equals(this.userProperties.get(prop))) {
                    return false;
                }
                this.userProperties.setProperty(prop, value);
                USER_CONFIG_FILE.createNewFile();
                try (FileOutputStream outputStream = new FileOutputStream(USER_CONFIG_FILE);){
                    this.userProperties.store(outputStream, "Modified by Testcontainers");
                }
                this.userProperties.setProperty(prop, value);
                return true;
            }
            catch (Exception e) {
                log.debug("Can't store environment property {} in {}", (Object)prop, (Object)USER_CONFIG_FILE);
                return false;
            }
        }
    }

    private static TestcontainersConfiguration loadConfiguration() {
        return new TestcontainersConfiguration(TestcontainersConfiguration.readProperties(USER_CONFIG_FILE.toURI().toURL()), ClasspathScanner.scanFor(PROPERTIES_FILE_NAME).map(TestcontainersConfiguration::readProperties).reduce(new Properties(), (a, b) -> {
            b.putAll((Map<?, ?>)a);
            return b;
        }), System.getenv());
    }

    private static Properties readProperties(URL url) {
        log.debug("Testcontainers configuration overrides will be loaded from {}", (Object)url);
        Properties properties = new Properties();
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            log.debug("Attempted to read Testcontainers configuration file at {} but the file was not found. Exception message: {}", (Object)url, (Object)ExceptionUtils.getRootCauseMessage(e));
        }
        catch (IOException e) {
            log.debug("Attempted to read Testcontainers configuration file at {} but could it not be loaded. Exception message: {}", (Object)url, (Object)ExceptionUtils.getRootCauseMessage(e));
        }
        return properties;
    }

    private DockerImageName getImage(String defaultValue) {
        return this.getConfiguredSubstituteImage(DockerImageName.parse(defaultValue));
    }

    DockerImageName getConfiguredSubstituteImage(DockerImageName original) {
        for (Map.Entry entry : CONTAINER_MAPPING.entrySet()) {
            if (!original.isCompatibleWith((DockerImageName)entry.getKey())) continue;
            return Optional.ofNullable(entry.getValue()).map(propertyName -> this.getEnvVarOrProperty((String)propertyName, null)).map(String::valueOf).map(String::trim).map(DockerImageName::parse).orElse(original).asCompatibleSubstituteFor(original);
        }
        return original;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public Properties getClasspathProperties() {
        return this.classpathProperties;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestcontainersConfiguration)) {
            return false;
        }
        TestcontainersConfiguration other = (TestcontainersConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Properties this$userProperties = this.getUserProperties();
        Properties other$userProperties = other.getUserProperties();
        if (this$userProperties == null ? other$userProperties != null : !((Object)this$userProperties).equals(other$userProperties)) {
            return false;
        }
        Properties this$classpathProperties = this.getClasspathProperties();
        Properties other$classpathProperties = other.getClasspathProperties();
        if (this$classpathProperties == null ? other$classpathProperties != null : !((Object)this$classpathProperties).equals(other$classpathProperties)) {
            return false;
        }
        Map<String, String> this$environment = this.getEnvironment();
        Map<String, String> other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestcontainersConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $userProperties = this.getUserProperties();
        result = result * 59 + ($userProperties == null ? 43 : ((Object)$userProperties).hashCode());
        Properties $classpathProperties = this.getClasspathProperties();
        result = result * 59 + ($classpathProperties == null ? 43 : ((Object)$classpathProperties).hashCode());
        Map<String, String> $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        return result;
    }

    public String toString() {
        return "TestcontainersConfiguration(userProperties=" + this.getUserProperties() + ", classpathProperties=" + this.getClasspathProperties() + ", environment=" + this.getEnvironment() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestcontainersConfiguration getInstance() {
        Object value = instance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                value = instance.get();
                if (value == null) {
                    TestcontainersConfiguration actualValue = TestcontainersConfiguration.loadConfiguration();
                    value = actualValue == null ? instance : actualValue;
                    instance.set(value);
                }
            }
        }
        return (TestcontainersConfiguration)(value == instance ? null : value);
    }
}

