/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.env.ConfigurationPath;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.DelegatingBeanDefinition;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.InjectableBeanDefinition;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.InstantiatableBeanDefinition;
import io.micronaut.inject.ParametrizedInstantiatableBeanDefinition;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.qualifiers.PrimaryQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
class BeanDefinitionDelegate<T>
extends AbstractBeanContextConditional
implements DelegatingBeanDefinition<T>,
InstantiatableBeanDefinition<T>,
InjectableBeanDefinition<T>,
NameResolver {
    protected final BeanDefinition<T> definition;
    @Nullable
    protected final Qualifier<T> qualifier;
    @Nullable
    private final ConfigurationPath configurationPath;
    private final Map<String, List<Argument<?>>> typeArgumentsMap;

    private BeanDefinitionDelegate(BeanDefinition<T> definition, @Nullable Qualifier<T> qualifier, @Nullable ConfigurationPath configurationPath, @NonNull Map<String, List<Argument<?>>> typeArgumentsMap) {
        this.definition = definition;
        this.qualifier = qualifier;
        this.configurationPath = configurationPath;
        this.typeArgumentsMap = typeArgumentsMap;
    }

    public Optional<ConfigurationPath> getConfigurationPath() {
        return Optional.ofNullable(this.configurationPath);
    }

    @Override
    public List<Argument<?>> getTypeArguments(String type) {
        List<Argument<?>> arguments = this.typeArgumentsMap.get(type);
        return arguments == null ? this.getTarget().getTypeArguments(type) : arguments;
    }

    @Override
    public Qualifier<T> getDeclaredQualifier() {
        return this.qualifier;
    }

    @Nullable
    public Qualifier<T> getQualifier() {
        return this.qualifier;
    }

    @Override
    @Nullable
    public Qualifier<T> resolveDynamicQualifier() {
        return this.qualifier;
    }

    BeanDefinition<T> getDelegate() {
        return this.definition;
    }

    @Override
    public boolean isProxy() {
        return this.definition.isProxy();
    }

    @Override
    public boolean isIterable() {
        return this.definition.isIterable();
    }

    @Override
    public boolean isPrimary() {
        return this.isQualifiedAsPrimary(this.qualifier) || this.definition.isPrimary() || this.isPrimaryThroughAttribute();
    }

    private boolean isQualifiedAsPrimary(Qualifier<?> q) {
        return q != null && (q == PrimaryQualifier.INSTANCE || q.contains(PrimaryQualifier.INSTANCE));
    }

    private boolean isPrimaryThroughAttribute() {
        if (this.configurationPath != null) {
            return this.configurationPath.isPrimary();
        }
        return false;
    }

    @Override
    public T inject(BeanContext context, T bean) {
        BeanDefinition<T> beanDefinition = this.definition;
        if (beanDefinition instanceof InjectableBeanDefinition) {
            InjectableBeanDefinition injectableBeanDefinition = (InjectableBeanDefinition)beanDefinition;
            return injectableBeanDefinition.inject(context, bean);
        }
        return bean;
    }

    @Override
    public T inject(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
        BeanDefinition<T> beanDefinition = this.definition;
        if (beanDefinition instanceof InjectableBeanDefinition) {
            InjectableBeanDefinition injectableBeanDefinition = (InjectableBeanDefinition)beanDefinition;
            return injectableBeanDefinition.inject(resolutionContext, context, bean);
        }
        return bean;
    }

    @Override
    public T instantiate(BeanResolutionContext resolutionContext, BeanContext context) throws BeanInstantiationException {
        ConfigurationPath oldPath = null;
        if (this.configurationPath != null) {
            oldPath = resolutionContext.getConfigurationPath();
            resolutionContext.setConfigurationPath(this.configurationPath);
        }
        try {
            BeanDefinition<T> beanDefinition = this.definition;
            if (beanDefinition instanceof ParametrizedInstantiatableBeanDefinition) {
                ParametrizedInstantiatableBeanDefinition parametrizedInstantiatableBeanDefinition = (ParametrizedInstantiatableBeanDefinition)beanDefinition;
                Argument<Object>[] requiredArguments = parametrizedInstantiatableBeanDefinition.getRequiredArguments();
                Map<String, Object> fulfilled = this.getParametersValues(resolutionContext, (DefaultBeanContext)context, this.definition, requiredArguments);
                Object t2 = parametrizedInstantiatableBeanDefinition.instantiate(resolutionContext, context, fulfilled);
                return t2;
            }
            beanDefinition = this.definition;
            if (beanDefinition instanceof InstantiatableBeanDefinition) {
                InstantiatableBeanDefinition instantiatableBeanDefinition = (InstantiatableBeanDefinition)beanDefinition;
                beanDefinition = instantiatableBeanDefinition.instantiate(resolutionContext, context);
                return (T)beanDefinition;
            }
            throw new IllegalStateException("Cannot construct a dynamically registered singleton");
        }
        finally {
            resolutionContext.setConfigurationPath(oldPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<String, Object> getParametersValues(BeanResolutionContext resolutionContext, DefaultBeanContext context, BeanDefinition<T> definition, Argument<Object>[] requiredArguments) {
        if (requiredArguments.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> fulfilled = new LinkedHashMap<String, Object>(requiredArguments.length, 1.0f);
        ConfigurationPath configurationPath = resolutionContext.getConfigurationPath();
        for (Argument<Object> argument : requiredArguments) {
            Argument pt;
            String argumentName = argument.getName();
            if (!argument.isAnnotationPresent(Parameter.class)) continue;
            Class<Object> type = argument.getWrapperType();
            boolean isEnum = Enum.class.isAssignableFrom(type);
            if (CharSequence.class.isAssignableFrom(type) || isEnum) {
                String simpleName = configurationPath.simpleName();
                if (simpleName != null) {
                    String value = isEnum ? context.getConversionService().convertRequired((Object)simpleName, type) : simpleName;
                    fulfilled.put(argumentName, value);
                    continue;
                }
                String name = this.findName(resolutionContext.getCurrentQualifier());
                if (name == null) continue;
                String value = isEnum ? context.getConversionService().convertRequired((Object)name, type) : name;
                fulfilled.put(argumentName, value);
                continue;
            }
            if (Number.class.isAssignableFrom(type)) {
                fulfilled.put(argumentName, context.getConversionService().convertRequired((Object)configurationPath.index(), argument));
                continue;
            }
            if (this.qualifier != null && this.hasDeclaredAnnotation(EachBean.class) && String.class.equals(type) && "name".equals(argumentName)) {
                String name = this.findName(this.qualifier);
                if (name == null) continue;
                fulfilled.put(argumentName, name);
                continue;
            }
            if (argument.isProvider() && (pt = (Argument)argument.getFirstTypeVariable().orElse(null)) != null) {
                type = pt.getType();
            }
            try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(definition, argument);){
                if (type.equals(configurationPath.configurationType())) {
                    Object bean = context.findBean(resolutionContext, argument, configurationPath.beanQualifier()).orElse(null);
                    fulfilled.put(argumentName, bean);
                    continue;
                }
                ConfigurationPath old = resolutionContext.setConfigurationPath(null);
                try {
                    Qualifier<T> q = this.qualifier != null ? this.qualifier : configurationPath.beanQualifier();
                    Object bean = context.findBean(resolutionContext, argument, q).orElse(null);
                    fulfilled.put(argumentName, bean);
                }
                finally {
                    resolutionContext.setConfigurationPath(old);
                }
            }
        }
        return fulfilled;
    }

    @Nullable
    private String findName(@Nullable Qualifier<?> q) {
        if (q == null) {
            return null;
        }
        String name = Qualifiers.findName(q);
        if (name != null) {
            return name;
        }
        if (this.isQualifiedAsPrimary(q)) {
            return Primary.SIMPLE_NAME;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanDefinitionDelegate that = (BeanDefinitionDelegate)o;
        return Objects.equals(this.definition, that.definition) && Objects.equals(this.qualifier, that.qualifier);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.definition, this.qualifier);
    }

    @Override
    public BeanDefinition<T> getTarget() {
        return this.definition;
    }

    @Override
    public Optional<String> resolveName() {
        return Optional.ofNullable(this.findName(this.qualifier));
    }

    public String toString() {
        return this.definition.toString();
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition) {
        return BeanDefinitionDelegate.create(definition, null);
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition, Qualifier<T> qualifier) {
        return BeanDefinitionDelegate.create(definition, qualifier, null, Map.of());
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition, Qualifier<T> qualifier, @NonNull Map<String, List<Argument<?>>> typeArgumentsMap) {
        return BeanDefinitionDelegate.create(definition, qualifier, null, typeArgumentsMap);
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition, Qualifier<T> qualifier, ConfigurationPath path, @NonNull Map<String, List<Argument<?>>> typeArgumentsMap) {
        if (definition instanceof InitializingBeanDefinition || definition instanceof DisposableBeanDefinition) {
            if (definition instanceof ValidatedBeanDefinition) {
                return new LifeCycleValidatingDelegate<T>(definition, (Qualifier)qualifier, path, typeArgumentsMap);
            }
            return new LifeCycleDelegate<T>(definition, (Qualifier)qualifier, path, typeArgumentsMap);
        }
        if (definition instanceof ValidatedBeanDefinition) {
            return new ValidatingDelegate<T>(definition, (Qualifier)qualifier, path, typeArgumentsMap);
        }
        return new BeanDefinitionDelegate<T>(definition, qualifier, path, typeArgumentsMap);
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition, Qualifier<T> qualifier, ConfigurationPath path) {
        return BeanDefinitionDelegate.create(definition, qualifier, path, Map.of());
    }

    @Override
    @NonNull
    public String getName() {
        return this.definition.getName();
    }

    private static final class LifeCycleValidatingDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyValidatingBeanDefinition<T>,
    ProxyInitializingBeanDefinition<T>,
    ProxyDisposableBeanDefinition<T> {
        private LifeCycleValidatingDelegate(BeanDefinition<T> definition, Qualifier qualifier, ConfigurationPath path, @NonNull Map<String, List<Argument<?>>> typeArgumentsMap) {
            super(definition, qualifier, path, typeArgumentsMap);
        }
    }

    private static final class LifeCycleDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyInitializingBeanDefinition<T>,
    ProxyDisposableBeanDefinition<T> {
        private LifeCycleDelegate(BeanDefinition<T> definition, Qualifier qualifier, ConfigurationPath path, @NonNull Map<String, List<Argument<?>>> typeArgumentsMap) {
            super(definition, qualifier, path, typeArgumentsMap);
        }
    }

    private static final class ValidatingDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyValidatingBeanDefinition<T> {
        private ValidatingDelegate(BeanDefinition<T> definition, Qualifier qualifier, ConfigurationPath path, @NonNull Map<String, List<Argument<?>>> typeArgumentsMap) {
            super(definition, qualifier, path, typeArgumentsMap);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface ProxyValidatingBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    ValidatedBeanDefinition<T> {
        @Override
        default public T validate(BeanResolutionContext resolutionContext, T instance) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof ValidatedBeanDefinition) {
                return ((ValidatedBeanDefinition)definition).validate(resolutionContext, instance);
            }
            return instance;
        }

        @Override
        default public <V> void validateBeanArgument(@NonNull BeanResolutionContext resolutionContext, @NonNull InjectionPoint injectionPoint, @NonNull Argument<V> argument, int index, @Nullable V value) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof ValidatedBeanDefinition) {
                ((ValidatedBeanDefinition)definition).validateBeanArgument(resolutionContext, injectionPoint, argument, index, value);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface ProxyDisposableBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    DisposableBeanDefinition<T> {
        @Override
        default public T dispose(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof DisposableBeanDefinition) {
                return ((DisposableBeanDefinition)definition).dispose(resolutionContext, context, bean);
            }
            return bean;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface ProxyInitializingBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    InitializingBeanDefinition<T> {
        @Override
        default public T initialize(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof InitializingBeanDefinition) {
                return ((InitializingBeanDefinition)definition).initialize(resolutionContext, context, bean);
            }
            return bean;
        }
    }
}

