/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.TypedMessageBodyHandler;
import io.micronaut.http.codec.CodecException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.reactivestreams.Publisher;

@Requires(bean=ByteBufferFactory.class)
@Singleton
@BootstrapContextCompatible
@Internal
final class ByteBufferBodyHandler
implements TypedMessageBodyHandler<ByteBuffer<?>>,
ChunkedMessageBodyReader<ByteBuffer<?>> {
    private final ByteBufferFactory<?, ?> byteBufferFactory;

    ByteBufferBodyHandler(ByteBufferFactory<?, ?> byteBufferFactory) {
        this.byteBufferFactory = byteBufferFactory;
    }

    @Override
    public Argument<ByteBuffer<?>> getType() {
        return Argument.of(ByteBuffer.class);
    }

    @Override
    public ByteBuffer<?> read(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return byteBuffer;
    }

    @Override
    public ByteBuffer<?> read(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        try {
            return this.byteBufferFactory.wrap(inputStream.readAllBytes());
        }
        catch (IOException e) {
            throw new CodecException("Failed to read InputStream", e);
        }
    }

    @Override
    public void writeTo(Argument<ByteBuffer<?>> type, MediaType mediaType, ByteBuffer<?> object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        ByteBufferBodyHandler.addContentType(outgoingHeaders, mediaType);
        try {
            object.toInputStream().transferTo(outputStream);
            if (object instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)((Object)object);
                rc.release();
            }
        }
        catch (IOException e) {
            throw new CodecException("Failed to write OutputStream", e);
        }
    }

    @Override
    public ByteBuffer<?> writeTo(Argument<ByteBuffer<?>> type, MediaType mediaType, ByteBuffer<?> object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        ByteBufferBodyHandler.addContentType(outgoingHeaders, mediaType);
        return object;
    }

    private static void addContentType(MutableHeaders outgoingHeaders, @Nullable MediaType mediaType) {
        if (mediaType != null) {
            outgoingHeaders.setIfMissing("Content-Type", mediaType);
        }
    }

    @Override
    public Publisher<ByteBuffer<?>> readChunked(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        return input;
    }
}

