/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.TypedMessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;

@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Singleton
@Internal
final class TextPlainObjectBodyWriter
implements TypedMessageBodyWriter<Object> {
    TextPlainObjectBodyWriter() {
    }

    @Override
    public Argument<Object> getType() {
        return Argument.OBJECT_ARGUMENT;
    }

    @Override
    public boolean isWriteable(Argument<Object> type, MediaType mediaType) {
        return ClassUtils.isJavaBasicType(type.getType());
    }

    @Override
    public void writeTo(Argument<Object> type, MediaType mediaType, Object object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        outgoingHeaders.setIfMissing("Content-Type", "text/plain");
        try {
            outputStream.write(object.toString().getBytes(MessageBodyWriter.getCharset(mediaType, outgoingHeaders)));
        }
        catch (IOException e) {
            throw new CodecException("Error writing body text: " + e.getMessage(), e);
        }
    }
}

