/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.form.FormUrlEncodedDecoder;
import io.micronaut.http.server.filter.FilterBodyParser;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={JsonMapper.class, FormUrlEncodedDecoder.class})
@Singleton
final class DefaultFilterBodyParser
implements FilterBodyParser {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFilterBodyParser.class);
    @NonNull
    private static final Argument<Map<String, Object>> MAP_STRING_OBJECT_ARGUMENT = Argument.mapOf(String.class, Object.class);
    private final JsonMapper jsonMapper;
    private final FormUrlEncodedDecoder formUrlEncodedDecoder;

    DefaultFilterBodyParser(FormUrlEncodedDecoder formUrlEncodedDecoder, JsonMapper jsonMapper) {
        this.formUrlEncodedDecoder = formUrlEncodedDecoder;
        this.jsonMapper = jsonMapper;
    }

    @Override
    @NonNull
    @SingleResult
    public CompletableFuture<Map<String, Object>> parseBody(@NonNull HttpRequest<?> request) {
        Optional<MediaType> mediaTypeOptional = request.getContentType();
        if (mediaTypeOptional.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not parse body into a Map because the request does not have a Content-Type");
            }
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        if (!(request instanceof ServerHttpRequest)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not parse body into a Map because the request is not an instance of ServerHttpRequest");
            }
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        MediaType contentType = mediaTypeOptional.get();
        if (contentType.equals(MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            return this.parseFormUrlEncoded((ServerHttpRequest)request);
        }
        if (contentType.equals(MediaType.APPLICATION_JSON_TYPE)) {
            return this.parseJson((ServerHttpRequest)request);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not parse body into a Map because the request's content type is not either application/x-www-form-urlencoded or application/json");
        }
        return CompletableFuture.completedFuture(Collections.emptyMap());
    }

    private CompletableFuture<Map<String, Object>> parseJson(@NonNull ServerHttpRequest<?> request) {
        try (CloseableByteBody closeableByteBody = request.byteBody().split(ByteBody.SplitBackpressureMode.FASTEST);){
            CompletionStage completionStage = closeableByteBody.buffer().thenApply(bb -> {
                try {
                    return this.jsonMapper.readValue(bb.toByteArray(), MAP_STRING_OBJECT_ARGUMENT);
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            });
            return completionStage;
        }
    }

    private CompletableFuture<Map<String, Object>> parseFormUrlEncoded(@NonNull ServerHttpRequest<?> request) {
        try (CloseableByteBody closeableByteBody = request.byteBody().split(ByteBody.SplitBackpressureMode.FASTEST);){
            CompletionStage completionStage = ((CompletableFuture)closeableByteBody.buffer().thenApply(bb -> bb.toString(request.getCharacterEncoding()))).thenApply(str -> this.formUrlEncodedDecoder.decode((String)str, request.getCharacterEncoding()));
            return completionStage;
        }
    }
}

