/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.uri.UriBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;

@Internal
record HttpToHttpsRedirectHandler(ConversionService conversionService, NettyHttpServerConfiguration serverConfiguration, ServerSslConfiguration sslConfiguration, HttpHostResolver hostResolver) implements RequestHandler
{
    @Override
    public void accept(ChannelHandlerContext ctx, HttpRequest request, CloseableByteBody body, OutboundAccess outboundAccess) {
        NettyHttpRequest strippedRequest = new NettyHttpRequest(request, body, ctx, this.conversionService, this.serverConfiguration);
        UriBuilder uriBuilder = UriBuilder.of(this.hostResolver.resolve(strippedRequest));
        strippedRequest.release();
        uriBuilder.scheme("https");
        int port = this.sslConfiguration.getPort();
        if (port == 443) {
            uriBuilder.port(-1);
        } else {
            uriBuilder.port(port);
        }
        uriBuilder.path(strippedRequest.getPath());
        outboundAccess.closeAfterWrite();
        outboundAccess.write(NettyHttpResponseBuilder.toHttpResponse(HttpResponse.permanentRedirect(uriBuilder.build())), AvailableNettyByteBody.empty());
    }

    @Override
    public void handleUnboundError(Throwable cause) {
    }
}

