/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Internal
final class UriTemplateParser {
    private UriTemplateParser() {
    }

    public static List<Part> parse(String template) {
        ArrayList<Part> parts = new ArrayList<Part>(10);
        int expressionStartIndex = -1;
        char[] input = template.toCharArray();
        StringBuilder literal = new StringBuilder();
        boolean isText = true;
        for (int i = 0; i < input.length; ++i) {
            char c = input[i];
            if (c == '{') {
                isText = false;
                if (!literal.isEmpty()) {
                    parts.add(new Literal(literal.toString()));
                    literal.setLength(0);
                }
                expressionStartIndex = i;
                continue;
            }
            if (c == '}' && expressionStartIndex != -1) {
                Expression expression = UriTemplateParser.parseExpression(input, expressionStartIndex + 1, i);
                parts.add(expression);
                isText = true;
                continue;
            }
            if (!isText) continue;
            if (Character.isISOControl(c) || Character.isWhitespace(c) || UriTemplateParser.isAllowedCharacter(c) || c == '%') {
                literal.append(c);
                continue;
            }
            throw new IllegalStateException("Unexpected character '" + c + "' at position " + i + " in " + template);
        }
        if (!literal.isEmpty()) {
            parts.add(new Literal(literal.toString()));
            literal.setLength(0);
        }
        return parts;
    }

    public static List<Part> concat(List<Part> parts1, List<Part> parts2) {
        Expression expression;
        parts1 = new ArrayList<Part>(parts1);
        parts2 = new ArrayList<Part>(parts2);
        ArrayList<Part> queryParams = new ArrayList<Part>();
        ArrayList<Part> fragmentParams = new ArrayList<Part>();
        UriTemplateParser.removeQueryParams(parts1, queryParams);
        UriTemplateParser.removeQueryParams(parts2, queryParams);
        UriTemplateParser.removeFragmentParams(parts1, fragmentParams);
        UriTemplateParser.removeFragmentParams(parts2, fragmentParams);
        if (parts1.isEmpty()) {
            return CollectionUtils.concat(parts2, CollectionUtils.concat(fragmentParams, queryParams));
        }
        if (parts2.isEmpty()) {
            return CollectionUtils.concat(parts1, CollectionUtils.concat(fragmentParams, queryParams));
        }
        Part part = parts2.get(0);
        if (part instanceof Expression && (expression = (Expression)part).type() == ExpressionType.NONE) {
            parts2.add(0, new Literal("/"));
        }
        ArrayList<Part> concat = new ArrayList<Part>(parts1.size() + parts2.size());
        Part parts1Last = parts1.get(parts1.size() - 1);
        Part parts2First = parts2.get(0);
        concat.addAll(parts1.subList(0, parts1.size() - 1));
        if (parts1Last instanceof Literal) {
            Expression expression2;
            Literal literalPart1 = (Literal)parts1Last;
            Object literal1 = literalPart1.text();
            boolean literal1EndsWithSlash = ((String)literal1).endsWith("/");
            if (literal1EndsWithSlash && parts2First instanceof Expression && (expression2 = (Expression)parts2First).type() == ExpressionType.PATH_SEGMENT_EXPANSION) {
                parts1Last = new Literal(((String)literal1).substring(0, ((String)literal1).length() - 1));
            }
            if (parts2First instanceof Literal) {
                Literal literalPart2 = (Literal)parts2First;
                String literal2 = literalPart2.text();
                boolean literal2StartsWithSlash = literal2.startsWith("/");
                if (literal1EndsWithSlash && literal2StartsWithSlash) {
                    literal1 = ((String)literal1).substring(0, ((String)literal1).length() - 1);
                } else if (!literal1EndsWithSlash && !literal2StartsWithSlash) {
                    literal1 = (String)literal1 + "/";
                } else if (literal2.equals("/") && parts2.size() == 1 && queryParams.isEmpty() && fragmentParams.isEmpty()) {
                    literal2 = "";
                }
                parts1Last = new Literal(((String)literal1).concat(literal2));
                parts2First = null;
            }
        }
        concat.add(parts1Last);
        if (parts2First != null) {
            concat.add(parts2First);
        }
        concat.addAll(parts2.subList(1, parts2.size()));
        concat.addAll(fragmentParams);
        concat.addAll(queryParams);
        return concat;
    }

    private static void removeQueryParams(List<Part> parts1, List<Part> params) {
        Iterator<Part> iterator = parts1.iterator();
        while (iterator.hasNext()) {
            Expression expression;
            Part part = iterator.next();
            if (!(part instanceof Expression) || !(expression = (Expression)part).type().isQueryPart()) continue;
            params.add(expression);
            iterator.remove();
        }
    }

    private static void removeFragmentParams(List<Part> parts1, List<Part> params) {
        Iterator<Part> iterator = parts1.iterator();
        while (iterator.hasNext()) {
            Expression expression;
            Part part = iterator.next();
            if (!(part instanceof Expression) || (expression = (Expression)part).type() != ExpressionType.FRAGMENT_EXPANSION) continue;
            params.add(expression);
            iterator.remove();
        }
    }

    private static boolean isAllowedCharacter(char c) {
        return switch (c) {
            case '<', '>', '\\', '^', '`', '{', '|', '}' -> false;
            default -> true;
        };
    }

    private static Expression parseExpression(char[] input, int fromIndex, int toIndex) {
        ArrayList<Variable> variables = new ArrayList<Variable>(2);
        ExpressionType expressionType = UriTemplateParser.parseOperator(input[fromIndex]);
        int variableNameStartIndex = expressionType == ExpressionType.NONE ? fromIndex : fromIndex + 1;
        int variableNameEndIndex = -1;
        int variableModifierStartIndex = -1;
        int variableModifierEndIndex = -1;
        for (int i = variableNameStartIndex; i < toIndex; ++i) {
            char c = input[i];
            if (c == ',') {
                if (variableModifierStartIndex != -1) {
                    variableModifierEndIndex = i;
                } else {
                    variableNameEndIndex = i;
                }
                variables.add(UriTemplateParser.createVariable(input, variableNameStartIndex, variableNameEndIndex, variableModifierStartIndex, variableModifierEndIndex));
                variableNameStartIndex = i + 1;
                variableNameEndIndex = -1;
                variableModifierStartIndex = -1;
                variableModifierEndIndex = -1;
                continue;
            }
            if (c == ':') {
                variableNameEndIndex = i;
                variableModifierStartIndex = i + 1;
                continue;
            }
            if (variableModifierStartIndex != -1) {
                variableModifierEndIndex = i;
                continue;
            }
            variableNameEndIndex = i;
        }
        if (variableModifierStartIndex != -1) {
            variableModifierEndIndex = toIndex;
        } else {
            variableNameEndIndex = toIndex;
        }
        variables.add(UriTemplateParser.createVariable(input, variableNameStartIndex, variableNameEndIndex, variableModifierStartIndex, variableModifierEndIndex));
        return new Expression(expressionType, variables);
    }

    private static Variable createVariable(char[] input, int variableNameStartIndex, int variableNameEndIndex, int variableModifierStartIndex, int variableModifierEndIndex) {
        boolean explore = false;
        if (input[variableNameEndIndex - 1] == '*') {
            explore = true;
            --variableNameEndIndex;
        }
        String modifier = null;
        if (variableModifierStartIndex != -1) {
            modifier = new String(input, variableModifierStartIndex, variableModifierEndIndex - variableModifierStartIndex);
        }
        return new Variable(new String(input, variableNameStartIndex, variableNameEndIndex - variableNameStartIndex), modifier, explore);
    }

    private static ExpressionType parseOperator(char c) {
        return switch (c) {
            case '+' -> ExpressionType.RESERVED_EXPANSION;
            case '#' -> ExpressionType.FRAGMENT_EXPANSION;
            case '.' -> ExpressionType.LABEL_EXPANSION;
            case '/' -> ExpressionType.PATH_SEGMENT_EXPANSION;
            case ';' -> ExpressionType.PATH_STYLE_PARAMETER_EXPANSION;
            case '?' -> ExpressionType.FORM_STYLE_PARAMETER_EXPANSION;
            case '&' -> ExpressionType.FORM_STYLE_QUERY_CONTINUATION;
            default -> ExpressionType.NONE;
        };
    }

    public record Literal(String text) implements Part
    {
        @Override
        public void visit(PartVisitor visitor) {
            visitor.visitLiteral(this.text);
        }
    }

    public record Expression(ExpressionType type, List<Variable> variables) implements Part
    {
        @Override
        public void visit(PartVisitor visitor) {
            visitor.visitExpression(this.type, this.variables);
        }
    }

    public static enum ExpressionType {
        NONE('0', ',', false, true),
        RESERVED_EXPANSION('+', ',', false, false),
        FRAGMENT_EXPANSION('#', ',', false, false),
        LABEL_EXPANSION('.', '.', false, true),
        PATH_SEGMENT_EXPANSION('/', '/', false, true),
        PATH_STYLE_PARAMETER_EXPANSION(';', ';', true, true),
        FORM_STYLE_PARAMETER_EXPANSION('?', '&', true, true),
        FORM_STYLE_QUERY_CONTINUATION('&', '&', true, true);

        private final char separator;
        private final char operator;
        private final boolean isQueryPart;
        private final boolean encode;

        private ExpressionType(char operator, char separator, boolean isQueryPart, boolean encode) {
            this.separator = separator;
            this.operator = operator;
            this.isQueryPart = isQueryPart;
            this.encode = encode;
        }

        public boolean isQueryPart() {
            return this.isQueryPart;
        }

        public char getOperator() {
            return this.operator;
        }

        public char getSeparator() {
            return this.separator;
        }

        public boolean isEncode() {
            return this.encode;
        }
    }

    public static interface Part {
        public void visit(PartVisitor var1);
    }

    public record Variable(String name, String modifier, boolean explode) {
    }

    public static interface PartVisitor {
        public void visitLiteral(String var1);

        public void visitExpression(ExpressionType var1, List<Variable> var2);
    }
}

