/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.management.endpoint.EndpointSensitivityHandler;
import io.micronaut.management.endpoint.EndpointSensitivityProcessor;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.RouteMatchUtils;
import java.util.Map;
import java.util.Optional;

@Requires(missingBeans={EndpointSensitivityHandler.class})
@ServerFilter(value={"/**"}, appendContextPath=false)
@Internal
public class EndpointsFilter
implements Ordered {
    private final Map<ExecutableMethod, Boolean> endpointMethods;

    public EndpointsFilter(EndpointSensitivityProcessor endpointSensitivityProcessor) {
        this.endpointMethods = endpointSensitivityProcessor.getEndpointMethods();
    }

    @RequestFilter
    @Nullable
    public HttpResponse<?> doFilter(HttpRequest<?> request) {
        MethodBasedRouteMatch methodBasedRouteMatch;
        ExecutableMethod method;
        RouteMatch routeMatch;
        Optional<RouteMatch> routeMatch2 = RouteMatchUtils.findRouteMatch(request);
        if (routeMatch2.isPresent() && (routeMatch = routeMatch2.get()) instanceof MethodBasedRouteMatch && this.endpointMethods.getOrDefault(method = (methodBasedRouteMatch = (MethodBasedRouteMatch)routeMatch).getExecutableMethod(), false).booleanValue()) {
            return HttpResponse.status(HttpStatus.UNAUTHORIZED);
        }
        return null;
    }

    @Override
    public int getOrder() {
        return ServerFilterPhase.SECURITY.order();
    }
}

