/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWriteProperty;
import io.micronaut.core.beans.UnsafeBeanWriteProperty;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericPlaceholder;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.InvalidPropertyFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.deserializers.DeserializeSubtypeInfo;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.util.SerdeAnnotationUtil;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import io.micronaut.serde.support.util.SubtypeInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

@Internal
final class DeserBean<T> {
    private static final String JK_PROP = "com.fasterxml.jackson.annotation.JsonProperty";
    @NonNull
    public final BeanIntrospection<T> introspection;
    @Nullable
    public final PropertiesBag<T> creatorParams;
    @Nullable
    public final DerProperty<T, Object>[] creatorUnwrapped;
    @Nullable
    public final PropertiesBag<T> injectProperties;
    @Nullable
    public final DerProperty<T, Object>[] unwrappedProperties;
    @Nullable
    public final AnySetter anySetter;
    @Nullable
    public final String wrapperProperty;
    @Nullable
    public final DeserializeSubtypeInfo<T> subtypeInfo;
    @Nullable
    public final Set<String> ignoredProperties;
    @Nullable
    public final Set<String> externalProperties;
    @Nullable
    public final boolean isJsonValueProperty;
    public final int creatorSize;
    public final int injectPropertiesSize;
    public final boolean ignoreUnknown;
    public final boolean failOnNullForPrimitives;
    public final boolean delegating;
    public final boolean simpleBean;
    public final boolean recordLikeBean;
    public final boolean hasBuilder;
    public final ConversionService conversionService;
    private final Map<String, Argument<?>> bounds;
    private volatile boolean initialized;
    private volatile boolean initializing;

    public DeserBean(DeserializationConfiguration defaultDeserializationConfiguration, Argument<T> type, BeanIntrospection<T> introspection, Deserializer.DecoderContext decoderContext, DeserBeanRegistry deserBeanRegistry, @Nullable SerdeArgumentConf serdeArgumentConf) throws SerdeException {
        boolean allowIgnoredProperties;
        this.bounds = type.hasTypeVariables() ? type.getTypeVariables() : Collections.emptyMap();
        PropertyNamingStrategy defaultPropertyNamingStrategy = decoderContext.getSerdeConfiguration().map(SerdeConfiguration::getPropertyNamingStrategy).orElse(null);
        this.conversionService = decoderContext.getConversionService();
        this.introspection = introspection;
        SerdeConfig.SerCreatorMode creatorMode = introspection.getConstructor().getAnnotationMetadata().enumValue(Creator.class, "mode", SerdeConfig.SerCreatorMode.class).orElse(null);
        this.delegating = creatorMode == SerdeConfig.SerCreatorMode.DELEGATING;
        this.hasBuilder = introspection.hasBuilder();
        Argument<?>[] constructorArguments = this.hasBuilder ? introspection.builder().getBuildMethodArguments() : introspection.getConstructorArguments();
        this.creatorSize = constructorArguments.length;
        PropertyNamingStrategy entityPropertyNamingStrategy = this.getPropertyNamingStrategy(introspection, decoderContext, defaultPropertyNamingStrategy);
        HashSet<String> ignoredProperties = new HashSet<String>();
        HashSet<String> externalProperties = new HashSet<String>();
        @Nullable Predicate<String> allowPropertyPredicate = serdeArgumentConf == null ? null : serdeArgumentConf.resolveAllowPropertyPredicate(false);
        boolean hasIncludedProperties = serdeArgumentConf != null && serdeArgumentConf.getIncluded() != null || introspection.isAnnotationPresent(SerdeConfig.SerIncluded.class);
        DeserializationConfiguration deserializationConfiguration = decoderContext.getDeserializationConfiguration().orElse(defaultDeserializationConfiguration);
        this.ignoreUnknown = hasIncludedProperties || introspection.booleanValue(SerdeConfig.SerIgnored.class, "ignoreUnknown").orElse(deserializationConfiguration.isIgnoreUnknown()) != false;
        this.failOnNullForPrimitives = deserializationConfiguration.isFailOnNullForPrimitives();
        PropertiesBag.Builder<T> creatorPropertiesBuilder = new PropertiesBag.Builder<T>(introspection, constructorArguments.length);
        BeanMethod<T, Object> jsonValueMethod = null;
        BeanProperty jsonValueProperty = introspection.getBeanProperties().stream().filter(m4 -> m4.isAnnotationPresent(SerdeConfig.SerValue.class)).findFirst().orElse(null);
        if (jsonValueProperty != null && constructorArguments.length != 1) {
            throw new SerdeException("Cannot have multiple parameters for a json value constructor!");
        }
        ArrayList<DerProperty<DerProperty, Object>> creatorUnwrapped = null;
        AnySetter anySetterValue = null;
        ArrayList<DerProperty<DerProperty, DerProperty>> unwrappedProperties = null;
        for (int i = 0; i < constructorArguments.length; ++i) {
            boolean isIgnored;
            Argument<Object> constructorArgument = this.resolveArgument(constructorArguments[i]);
            AnnotationMetadata annotationMetadata = DeserBean.resolveArgumentMetadata(introspection, constructorArgument, constructorArgument.getAnnotationMetadata());
            if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class)) {
                anySetterValue = new AnySetter(constructorArgument, i);
                continue;
            }
            SubtypeInfo propertySubtypeInfo = SubtypeInfo.createForProperty(annotationMetadata);
            if (propertySubtypeInfo != null && propertySubtypeInfo.discriminatorType() == SerdeConfig.SerSubtyped.DiscriminatorType.EXTERNAL_PROPERTY) {
                externalProperties.add(propertySubtypeInfo.discriminatorName());
            }
            PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(annotationMetadata, decoderContext, entityPropertyNamingStrategy);
            String propertyName = this.resolveName(serdeArgumentConf, constructorArgument, annotationMetadata, propertyNamingStrategy);
            boolean bl = isIgnored = this.isIgnored(annotationMetadata) || allowPropertyPredicate != null && !allowPropertyPredicate.test(propertyName);
            if (isIgnored) {
                ignoredProperties.add(propertyName);
            }
            Argument argument = Argument.of(constructorArgument.getType(), constructorArgument.getName(), annotationMetadata, constructorArgument.getTypeParameters());
            boolean isUnwrapped = annotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class);
            DeserBean<Object> unwrapped = null;
            if (isUnwrapped) {
                unwrapped = deserBeanRegistry.getDeserializableBean(serdeArgumentConf == null ? constructorArgument : serdeArgumentConf.extendArgumentWithPrefixSuffix(constructorArgument), decoderContext);
            }
            DerProperty<T, Object> derProperty = new DerProperty<T, Object>(this.conversionService, introspection, i, propertyName, argument, isIgnored ? null : (BeanWriteProperty)introspection.getProperty(propertyName).or(() -> introspection.getProperty(constructorArgument.getName())).orElse(null), null, unwrapped, null, isIgnored, this.failOnNullForPrimitives);
            if (isUnwrapped) {
                if (creatorUnwrapped == null) {
                    creatorUnwrapped = new ArrayList<DerProperty<DerProperty, Object>>();
                }
                creatorUnwrapped.add(derProperty);
            }
            creatorPropertiesBuilder.register(propertyName, derProperty, true);
        }
        this.creatorParams = creatorPropertiesBuilder.build();
        if (this.hasBuilder) {
            PropertiesBag.Builder<T> readPropertiesBuilder = new PropertiesBag.Builder<T>(introspection);
            BeanIntrospection.Builder<T> builder = introspection.builder();
            @NonNull Argument<?>[] builderArguments = builder.getBuilderArguments();
            for (int i = 0; i < builderArguments.length; ++i) {
                Argument<?> builderArgument = builderArguments[i];
                AnnotationMetadata annotationMetadata = builderArgument.getAnnotationMetadata();
                Optional<BeanProperty<BeanProperty, Object>> matchingOuterProperty = introspection.getProperty(builderArgument.getName());
                PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(annotationMetadata, decoderContext, entityPropertyNamingStrategy);
                String jsonProperty = this.resolveName(builderArgument, matchingOuterProperty.map(outer -> List.of(annotationMetadata, outer.getAnnotationMetadata())).orElse(List.of(annotationMetadata)), propertyNamingStrategy);
                DerProperty derProperty = new DerProperty(this.conversionService, introspection, i, jsonProperty, builderArgument, null, null, null, null, false, this.failOnNullForPrimitives);
                readPropertiesBuilder.register(jsonProperty, derProperty, true);
            }
            this.injectProperties = readPropertiesBuilder.build();
        } else {
            List<BeanWriteProperty<T, Object>> beanProperties;
            Collection<BeanMethod<T, Object>> beanMethods = introspection.getBeanMethods();
            ArrayList<BeanMethod<T, Object>> jsonSetters = new ArrayList<BeanMethod<T, Object>>(beanMethods.size());
            BeanMethod<T, Object> anySetter = null;
            for (BeanMethod<T, Object> method : beanMethods) {
                if (method.isAnnotationPresent(SerdeConfig.SerSetter.class)) {
                    jsonSetters.add(method);
                    continue;
                }
                if (method.isAnnotationPresent(SerdeConfig.SerAnySetter.class) && ArrayUtils.isNotEmpty(method.getArguments())) {
                    anySetter = method;
                    continue;
                }
                if (!method.isAnnotationPresent(SerdeConfig.SerValue.class) || !ArrayUtils.isEmpty(method.getArguments())) continue;
                jsonValueMethod = method;
            }
            if (anySetterValue == null) {
                AnySetter anySetter2 = anySetterValue = anySetter != null ? new AnySetter(anySetter) : null;
            }
            if (!(beanProperties = introspection.getBeanWriteProperties()).isEmpty() || !jsonSetters.isEmpty()) {
                PropertiesBag.Builder<T> readPropertiesBuilder = new PropertiesBag.Builder<T>(introspection);
                int i = -1;
                for (BeanWriteProperty beanWriteProperty : beanProperties) {
                    AnnotationMetadata annotationMetadata = beanWriteProperty.getAnnotationMetadata();
                    String propertyName = this.resolveName(serdeArgumentConf, beanWriteProperty, annotationMetadata, this.getPropertyNamingStrategy(annotationMetadata, decoderContext, entityPropertyNamingStrategy));
                    SubtypeInfo propertySubtypeInfo = SubtypeInfo.createForProperty(annotationMetadata);
                    if (propertySubtypeInfo != null && propertySubtypeInfo.discriminatorType() == SerdeConfig.SerSubtyped.DiscriminatorType.EXTERNAL_PROPERTY) {
                        externalProperties.add(propertySubtypeInfo.discriminatorName());
                    }
                    if (this.creatorParams != null && this.creatorParams.propertyIndexOf(propertyName) != -1) continue;
                    if (this.isIgnored(beanWriteProperty) || allowPropertyPredicate != null && !allowPropertyPredicate.test(propertyName)) {
                        ignoredProperties.add(propertyName);
                        continue;
                    }
                    ++i;
                    ignoredProperties.remove(propertyName);
                    if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class)) {
                        anySetterValue = new AnySetter(beanWriteProperty);
                        continue;
                    }
                    boolean isUnwrapped = annotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class);
                    Argument propertyArgument = this.resolveArgument(beanWriteProperty.asArgument());
                    DeserBean unwrapped = null;
                    if (isUnwrapped) {
                        unwrapped = deserBeanRegistry.getDeserializableBean(serdeArgumentConf == null ? propertyArgument : serdeArgumentConf.extendArgumentWithPrefixSuffix(propertyArgument), decoderContext);
                    }
                    DerProperty derProperty = new DerProperty(this.conversionService, introspection, i, propertyName, propertyArgument, beanWriteProperty, null, unwrapped, null, false, this.failOnNullForPrimitives);
                    if (isUnwrapped) {
                        if (unwrappedProperties == null) {
                            unwrappedProperties = new ArrayList<DerProperty<DerProperty, DerProperty>>();
                        }
                        unwrappedProperties.add(derProperty);
                    }
                    readPropertiesBuilder.register(propertyName, derProperty, true);
                }
                for (final BeanMethod beanMethod : jsonSetters) {
                    PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(beanMethod.getAnnotationMetadata(), decoderContext, entityPropertyNamingStrategy);
                    String property = this.resolveName(serdeArgumentConf, new AnnotatedElement(){

                        @Override
                        public String getName() {
                            return NameUtils.getPropertyNameForSetter(beanMethod.getName());
                        }

                        @Override
                        public AnnotationMetadata getAnnotationMetadata() {
                            return beanMethod.getAnnotationMetadata();
                        }
                    }, beanMethod.getAnnotationMetadata(), propertyNamingStrategy);
                    Argument<?> argument = this.resolveArgument(beanMethod.getArguments()[0]);
                    DerProperty derProperty = new DerProperty(this.conversionService, introspection, ++i, property, argument, null, beanMethod, null, null, false, this.failOnNullForPrimitives);
                    readPropertiesBuilder.register(property, derProperty, true);
                }
                this.injectProperties = readPropertiesBuilder.build();
            } else {
                this.injectProperties = null;
            }
        }
        this.injectPropertiesSize = this.injectProperties == null ? 0 : this.injectProperties.getDerProperties().size();
        this.wrapperProperty = introspection.stringValue(SerdeConfig.class, "wrapperProperty").orElse(null);
        this.anySetter = anySetterValue;
        this.creatorUnwrapped = creatorUnwrapped != null ? creatorUnwrapped.toArray(new DerProperty[0]) : null;
        this.unwrappedProperties = unwrappedProperties != null ? unwrappedProperties.toArray(new DerProperty[0]) : null;
        SubtypeInfo subtypeInfoBase = serdeArgumentConf == null ? SubtypeInfo.createForType(introspection) : serdeArgumentConf.getSubtypeInfo();
        this.subtypeInfo = subtypeInfoBase == null ? DeserializeSubtypeInfo.create(SubtypeInfo.createForType(introspection), introspection, decoderContext, deserBeanRegistry) : DeserializeSubtypeInfo.create(subtypeInfoBase, introspection, decoderContext, deserBeanRegistry);
        String discriminatorProperty = introspection.stringValue(SerdeConfig.class, "typeProperty").orElse(null);
        if (discriminatorProperty != null && !introspection.booleanValue(SerdeConfig.class, "typePropertyVisible").orElse(false).booleanValue()) {
            ignoredProperties.add(discriminatorProperty);
        }
        if (!(allowIgnoredProperties = introspection.booleanValue(SerdeConfig.SerIgnored.class, "allowDeserialize").orElse(false).booleanValue()) && serdeArgumentConf != null && serdeArgumentConf.getIgnored() != null) {
            ignoredProperties.addAll(Arrays.asList(serdeArgumentConf.getIgnored()));
        }
        this.ignoredProperties = ignoredProperties.isEmpty() ? null : ignoredProperties;
        this.externalProperties = externalProperties.isEmpty() ? null : externalProperties;
        this.isJsonValueProperty = jsonValueMethod != null || jsonValueProperty != null;
        this.simpleBean = this.isSimpleBean();
        this.recordLikeBean = this.isRecordLikeBean();
    }

    void initialize(ReentrantLock lock, Deserializer.DecoderContext decoderContext) throws SerdeException {
        if (!this.initialized) {
            lock.lock();
            try {
                if (!this.initialized && !this.initializing) {
                    this.initializing = true;
                    this.initializeInternal(decoderContext);
                    this.initialized = true;
                    this.initializing = false;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void initializeInternal(Deserializer.DecoderContext decoderContext) throws SerdeException {
        if (this.injectProperties != null) {
            for (DerProperty<T, Object> derProperty : this.injectProperties.getProperties()) {
                this.initProperty(derProperty, decoderContext);
            }
        }
        if (this.creatorParams != null) {
            for (DerProperty derProperty : this.creatorParams.getProperties()) {
                this.initProperty(derProperty, decoderContext);
            }
        }
        if (this.anySetter != null) {
            Deserializer<Object> deserializer = this.anySetter.deserializer = this.anySetter.valueType.equalsType(Argument.OBJECT_ARGUMENT) ? null : DeserBean.findDeserializer(decoderContext, this.anySetter.valueType);
        }
        if (this.unwrappedProperties != null) {
            for (DerProperty<T, Object> unwrappedProperty : this.unwrappedProperties) {
                this.initProperty(unwrappedProperty, decoderContext);
            }
        }
    }

    private boolean isSimpleBean() {
        if (this.isJsonValueProperty || this.ignoredProperties != null || this.externalProperties != null || this.delegating || this.subtypeInfo != null || this.creatorParams != null || this.creatorUnwrapped != null || this.unwrappedProperties != null || this.anySetter != null) {
            return false;
        }
        if (this.injectProperties != null) {
            for (DerProperty<T, Object> property : this.injectProperties.getProperties()) {
                if (!property.isAnySetter && property.views == null && property.managedRef == null && this.introspection == property.introspection && property.backRef == null && property.beanProperty != null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isRecordLikeBean() {
        if (this.isJsonValueProperty || this.ignoredProperties != null || this.externalProperties != null || this.delegating || this.subtypeInfo != null || this.injectProperties != null || this.creatorUnwrapped != null || this.unwrappedProperties != null || this.anySetter != null) {
            return false;
        }
        if (this.creatorParams != null) {
            for (DerProperty<T, Object> property : this.creatorParams.getProperties()) {
                if (property.beanProperty == null && !property.isAnySetter && property.views == null && property.managedRef == null && this.introspection == property.introspection && property.backRef == null) continue;
                return false;
            }
        }
        return true;
    }

    private void initProperty(DerProperty<T, Object> property, Deserializer.DecoderContext decoderContext) throws SerdeException {
        if (!property.ignored) {
            property.deserializer = DeserBean.findDeserializer(decoderContext, property.argument);
        }
    }

    private PropertyNamingStrategy getPropertyNamingStrategy(AnnotationMetadata annotationMetadata, Deserializer.DecoderContext decoderContext, PropertyNamingStrategy defaultNamingStrategy) throws SerdeException {
        Class namingStrategyClass = annotationMetadata.classValue(SerdeConfig.class, "runtimeNaming").orElse(null);
        return namingStrategyClass == null ? defaultNamingStrategy : decoderContext.findNamingStrategy(namingStrategyClass);
    }

    private <A> Argument<A> resolveArgument(Argument<A> argument) {
        Map<String, Argument<?>> bounds;
        if ((argument instanceof GenericPlaceholder || argument.hasTypeVariables()) && !(bounds = this.bounds).isEmpty()) {
            return this.resolveArgument(argument, bounds);
        }
        return argument;
    }

    private <A> Argument<A> resolveArgument(Argument<A> argument, Map<String, Argument<?>> bounds) {
        Argument[] declaredParameters = argument.getTypeParameters();
        if (argument instanceof GenericPlaceholder) {
            GenericPlaceholder gp = (GenericPlaceholder)argument;
            Argument<?> resolved = bounds.get(gp.getVariableName());
            if (resolved != null) {
                return Argument.of(resolved.getType(), argument.getName(), argument.getAnnotationMetadata(), this.resolveParameters(bounds, resolved.getTypeParameters()));
            }
            Argument<?>[] typeParameters = this.resolveParameters(bounds, declaredParameters);
            if (typeParameters != declaredParameters) {
                return Argument.ofTypeVariable(argument.getType(), argument.getName(), gp.getVariableName(), gp.getAnnotationMetadata(), typeParameters);
            }
        } else {
            Argument<?>[] typeParameters = this.resolveParameters(bounds, declaredParameters);
            if (typeParameters != declaredParameters) {
                return Argument.of(argument.getType(), argument.getName(), argument.getAnnotationMetadata(), typeParameters);
            }
        }
        return argument;
    }

    private Argument<?>[] resolveParameters(Map<String, Argument<?>> bounds, Argument<?>[] typeParameters) {
        if (ArrayUtils.isEmpty(typeParameters)) {
            return typeParameters;
        }
        Argument[] resolvedParameters = new Argument[typeParameters.length];
        boolean differ = false;
        for (int i = 0; i < typeParameters.length; ++i) {
            Argument<?> typeParameter = typeParameters[i];
            Argument<?> resolved = this.resolveArgument(typeParameter, bounds);
            if (resolved != typeParameter) {
                resolvedParameters[i] = resolved;
                differ = true;
                continue;
            }
            resolvedParameters[i] = typeParameter;
        }
        return differ ? resolvedParameters : typeParameters;
    }

    private String resolveName(@Nullable SerdeArgumentConf serdeArgumentConf, AnnotatedElement annotatedElement, AnnotationMetadata annotationMetadata, PropertyNamingStrategy namingStrategy) {
        String name = this.resolveName(annotatedElement, List.of(annotationMetadata), namingStrategy);
        if (serdeArgumentConf != null) {
            return serdeArgumentConf.applyPrefixSuffix(name);
        }
        return name;
    }

    private String resolveName(AnnotatedElement annotatedElement, List<AnnotationMetadata> annotationMetadata, PropertyNamingStrategy namingStrategy) {
        for (AnnotationMetadata metadataElement : annotationMetadata) {
            Optional<String> serde = metadataElement.stringValue(SerdeConfig.class, "property");
            if (serde.isPresent()) {
                return serde.get();
            }
            Optional<String> jackson = metadataElement.stringValue(JK_PROP);
            if (!jackson.isPresent()) continue;
            return jackson.get();
        }
        if (namingStrategy != null) {
            return namingStrategy.translate(annotatedElement);
        }
        return annotatedElement.getName();
    }

    private static <T> Deserializer<T> findDeserializer(Deserializer.DecoderContext decoderContext, Argument<T> argument) throws SerdeException {
        Class customDeser = argument.getAnnotationMetadata().classValue(SerdeConfig.class, "deserializerClass").orElse(null);
        if (customDeser != null) {
            return decoderContext.findCustomDeserializer(customDeser).createSpecific(decoderContext, argument);
        }
        Class deserializeAs = argument.getAnnotationMetadata().classValue(SerdeConfig.class, "deserAs").orElse(null);
        if (deserializeAs != null) {
            argument = Argument.of(deserializeAs, argument.getName(), argument.getAnnotationMetadata(), argument.getTypeParameters());
        }
        return decoderContext.findDeserializer(argument).createSpecific(decoderContext, argument);
    }

    private boolean isIgnored(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.booleanValue(SerdeConfig.class, "readOnly").orElse(false) != false || annotationMetadata.booleanValue(SerdeConfig.class, "ignored").orElse(false) != false || annotationMetadata.booleanValue(SerdeConfig.class, "ignoredDeserialization").orElse(false) != false;
    }

    private static <B, P> AnnotationMetadata resolveArgumentMetadata(BeanIntrospection<B> introspection, Argument<P> argument, AnnotationMetadata annotationMetadata) {
        AnnotationMetadata propertyMetadata = introspection.getProperty(argument.getName(), argument.getType()).map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
        return new AnnotationMetadataHierarchy(propertyMetadata, annotationMetadata);
    }

    static final class AnySetter {
        final Argument<Object> valueType;
        private final BiConsumer<Object, Map<String, ?>> mapSetter;
        private final TriConsumer<Object, Object> valueSetter;
        public Deserializer<?> deserializer;
        public final boolean constructorArgument;

        private AnySetter(BeanMethod<Object, ?> anySetter) {
            Argument<?>[] arguments = anySetter.getArguments();
            boolean singleArg = arguments.length == 1;
            Argument<Object> argument = this.valueType = singleArg ? arguments[0].getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT) : arguments[1];
            if (singleArg) {
                this.valueSetter = null;
                this.mapSetter = (x$0, xva$1) -> anySetter.invoke(x$0, xva$1);
            } else {
                this.valueSetter = (x$0, xva$1, xva$2) -> anySetter.invoke(x$0, xva$1, xva$2);
                this.mapSetter = null;
            }
            this.constructorArgument = false;
        }

        private AnySetter(BeanWriteProperty<Object, Object> anySetter) {
            this.valueType = anySetter.asArgument().getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
            this.mapSetter = anySetter::set;
            this.valueSetter = null;
            this.constructorArgument = false;
        }

        private AnySetter(Argument<Object> anySetter, int index) {
            this.valueType = anySetter.getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
            this.mapSetter = (o, map) -> {
                ((Object[])o)[index] = map;
            };
            this.valueSetter = null;
            this.constructorArgument = true;
        }

        void bind(Map<String, Object> values, Object object) {
            if (values != null) {
                if (this.mapSetter != null) {
                    this.mapSetter.accept(object, values);
                } else if (this.valueSetter != null) {
                    for (String s2 : values.keySet()) {
                        this.valueSetter.accept(object, s2, values.get(s2));
                    }
                }
            }
        }
    }

    @Internal
    public static final class DerProperty<B, P> {
        public final BeanIntrospection<B> introspection;
        public final int index;
        public final Argument<P> argument;
        @Nullable
        public final P defaultValue;
        public final boolean mustSetField;
        public final boolean mustSetFieldForConstructor;
        public final boolean explicitlyRequired;
        public final boolean explicitlyRequiredForConstructor;
        public final boolean nonNull;
        public final boolean nullable;
        public final boolean isAnySetter;
        @Nullable
        public final Class<?>[] views;
        @Nullable
        public final String[] aliases;
        @Nullable
        public final UnsafeBeanWriteProperty<B, P> beanProperty;
        public final DeserBean<P> unwrapped;
        public final DerProperty<?, ?> unwrappedProperty;
        public final String managedRef;
        public final String backRef;
        public final boolean ignored;
        public Deserializer<P> deserializer;

        DerProperty(ConversionService conversionService, BeanIntrospection<B> introspection, int index, String property, Argument<P> argument, @Nullable BeanWriteProperty<B, P> beanProperty, @Nullable BeanMethod<B, P> beanMethod, @Nullable DeserBean<P> unwrapped, @Nullable DerProperty<?, ?> unwrappedProperty, boolean ignored, boolean failOnNullForPrimitives) throws SerdeException {
            this(conversionService, introspection, index, property, argument, argument.getAnnotationMetadata(), beanProperty, beanMethod, unwrapped, unwrappedProperty, ignored, failOnNullForPrimitives);
        }

        DerProperty(ConversionService conversionService, BeanIntrospection<B> introspection, int index, String property, Argument<P> argument, AnnotationMetadata argumentMetadata, @Nullable BeanWriteProperty<B, P> beanProperty, @Nullable BeanMethod<B, P> beanMethod, @Nullable DeserBean<P> unwrapped, @Nullable DerProperty<?, ?> unwrappedProperty, boolean ignored, boolean failOnNullForPrimitives) throws SerdeException {
            this.introspection = introspection;
            this.index = index;
            this.argument = argument;
            this.ignored = ignored;
            Class type = argument.getType();
            this.mustSetField = argument.isNonNull() || type.equals(Optional.class) || type.equals(OptionalLong.class) || type.equals(OptionalDouble.class) || type.equals(OptionalInt.class);
            this.mustSetFieldForConstructor = this.mustSetField || argument.isPrimitive();
            this.nonNull = argument.isNonNull();
            this.nullable = argument.isNullable();
            this.beanProperty = beanProperty != null ? (UnsafeBeanWriteProperty)beanProperty : (beanMethod != null ? new BeanMethodAsBeanProperty<B, P>(property, beanMethod) : null);
            AnnotationMetadata annotationMetadata = DeserBean.resolveArgumentMetadata(introspection, argument, argumentMetadata);
            this.views = SerdeAnnotationUtil.resolveViews(introspection, annotationMetadata);
            try {
                this.defaultValue = annotationMetadata.stringValue(Bindable.class, "defaultValue").map(s2 -> conversionService.convertRequired(s2, argument)).orElse(null);
            }
            catch (ConversionErrorException e) {
                throw new SerdeException((index > -1 ? "Constructor Argument" : "Property") + " [" + argument + "] of type [" + introspection.getBeanType().getName() + "] defines an invalid default value", e);
            }
            this.unwrapped = unwrapped;
            this.unwrappedProperty = unwrappedProperty;
            this.isAnySetter = annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class);
            Object[] aliases = annotationMetadata.stringValues(SerdeConfig.class, "aliases");
            this.aliases = ArrayUtils.isNotEmpty(aliases) ? ArrayUtils.concat(aliases, property) : null;
            this.managedRef = annotationMetadata.stringValue(SerdeConfig.SerManagedRef.class).orElse(null);
            this.backRef = annotationMetadata.stringValue(SerdeConfig.SerBackRef.class).orElse(null);
            this.explicitlyRequired = annotationMetadata.booleanValue(SerdeConfig.class, "required").orElse(false);
            this.explicitlyRequiredForConstructor = this.explicitlyRequired || argument.isPrimitive() && failOnNullForPrimitives;
        }

        public void setDefaultPropertyValue(Deserializer.DecoderContext decoderContext, @NonNull B bean) throws SerdeException {
            if (this.explicitlyRequired) {
                throw new SerdeException("Unable to deserialize type [" + this.introspection.getBeanType().getName() + "]. Required property [" + this.argument + "] is not present in supplied data");
            }
            P value = this.provideDefaultValue(decoderContext);
            if (value != null) {
                this.beanProperty.setUnsafe(bean, value);
            }
        }

        public void setDefaultConstructorValue(Deserializer.DecoderContext decoderContext, @NonNull Object[] params) throws SerdeException {
            if (this.explicitlyRequiredForConstructor) {
                throw new SerdeException("Unable to deserialize type [" + this.introspection.getBeanType().getName() + "]. Required constructor parameter [" + this.argument + "] at index [" + this.index + "] is not present or is null in the supplied data");
            }
            params[this.index] = this.provideDefaultValue(decoderContext, this.mustSetFieldForConstructor);
        }

        public void set(@NonNull Deserializer.DecoderContext decoderContext, @NonNull B obj, @Nullable P value) throws SerdeException {
            if (value == null) {
                this.setDefaultPropertyValue(decoderContext, obj);
            } else {
                this.beanProperty.setUnsafe(obj, value);
            }
        }

        public void deserializeAndSetConstructorValue(Decoder objectDecoder, Deserializer.DecoderContext decoderContext, Object[] values) throws IOException {
            try {
                values[this.index] = this.deserializeValue(objectDecoder, decoderContext);
            }
            catch (InvalidFormatException e) {
                throw new InvalidPropertyFormatException(e, this.argument);
            }
            catch (Exception e) {
                throw new SerdeException("Error decoding property [" + this.argument + "] of type [" + this.introspection.getBeanType() + "]: " + e.getMessage(), e);
            }
        }

        public void deserializeAndSetPropertyValue(Decoder objectDecoder, Deserializer.DecoderContext decoderContext, B beanInstance) throws IOException {
            try {
                P value = this.deserializeValue(objectDecoder, decoderContext);
                if (value != null || this.nullable) {
                    this.beanProperty.setUnsafe(beanInstance, value);
                }
            }
            catch (InvalidFormatException e) {
                throw new InvalidPropertyFormatException(e, this.argument);
            }
            catch (Exception e) {
                throw new SerdeException("Error decoding property [" + this.argument + "] of type [" + this.introspection.getBeanType() + "]: " + e.getMessage(), e);
            }
        }

        public void deserializeAndCallBuilder(Decoder objectDecoder, Deserializer.DecoderContext decoderContext, BeanIntrospection.Builder<B> builder) throws IOException {
            try {
                P value = this.deserializeValue(objectDecoder, decoderContext);
                if (value != null || this.nullable) {
                    builder.with(this.index, this.argument, value);
                }
            }
            catch (InvalidFormatException e) {
                throw new InvalidPropertyFormatException(e, this.argument);
            }
            catch (Exception e) {
                throw new SerdeException("Error decoding property [" + this.argument + "] of type [" + this.introspection.getBeanType() + "]: " + e.getMessage(), e);
            }
        }

        private P deserializeValue(Decoder objectDecoder, Deserializer.DecoderContext decoderContext) throws IOException {
            P value = this.deserializer.deserializeNullable(objectDecoder, decoderContext, this.argument);
            if (value != null || this.nullable) {
                return value;
            }
            if (this.explicitlyRequired) {
                throw new SerdeException("Unable to deserialize type [" + this.introspection.getBeanType().getName() + "]. Required property [" + this.argument + "] is not present in supplied data");
            }
            return this.provideDefaultValue(decoderContext);
        }

        private P provideDefaultValue(Deserializer.DecoderContext decoderContext) {
            return this.provideDefaultValue(decoderContext, this.mustSetField);
        }

        private P provideDefaultValue(Deserializer.DecoderContext decoderContext, boolean mustSetField) {
            P value = this.defaultValue;
            if (value == null && mustSetField) {
                value = this.deserializer.getDefaultValue(decoderContext, this.argument);
            }
            return value;
        }
    }

    private static final class BeanMethodAsBeanProperty<B, P>
    implements UnsafeBeanWriteProperty<B, P> {
        private final String name;
        private final BeanMethod<B, P> beanMethod;
        private final Argument<P> argument;
        private final Class<P> type;

        public BeanMethodAsBeanProperty(String name, BeanMethod<B, P> beanMethod) {
            this.name = name;
            this.beanMethod = beanMethod;
            this.argument = beanMethod.getArguments()[0];
            this.type = this.argument.getType();
        }

        @Override
        public B withValueUnsafe(B bean, P value) {
            throw new IllegalStateException("Not supported");
        }

        @Override
        public void setUnsafe(B bean, P value) {
            this.beanMethod.invoke(bean, value);
        }

        @Override
        public BeanIntrospection<B> getDeclaringBean() {
            return null;
        }

        @Override
        public B withValue(@NonNull B bean, @Nullable P value) {
            this.setUnsafe(bean, value);
            return bean;
        }

        @Override
        public void set(@NonNull B bean, @Nullable P value) {
            this.setUnsafe(bean, value);
        }

        @Override
        public Class<P> getType() {
            return this.type;
        }

        @Override
        public Argument<P> asArgument() {
            return this.argument;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public AnnotationMetadata getAnnotationMetadata() {
            return this.beanMethod.getAnnotationMetadata();
        }
    }

    private static interface TriConsumer<T, V> {
        public void accept(T var1, String var2, V var3);
    }
}

