/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;

@Internal
class ErrorCatchingDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> deserializer;

    ErrorCatchingDeserializer(Deserializer<T> deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public Deserializer<T> createSpecific(Deserializer.DecoderContext context, Argument<? super T> type) throws SerdeException {
        return this.deserializer.createSpecific(context, type);
    }

    @Override
    public T deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super T> type) throws IOException {
        try {
            return this.deserializer.deserialize(decoder, context, type);
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion deserializing type: " + type, e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error deserializing. No deserializing found for type: " + type, e);
        }
        catch (SerdeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerdeException("Error deserializing type: " + type, e);
        }
    }

    @Override
    public T deserializeNullable(Decoder decoder, Deserializer.DecoderContext context, Argument<? super T> type) throws IOException {
        try {
            return this.deserializer.deserializeNullable(decoder, context, type);
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion deserializing type: " + type.getType(), e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error deserializing. No deserializing found for type: " + type, e);
        }
        catch (SerdeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerdeException("Error deserializing type: " + type, e);
        }
    }

    @Override
    public boolean allowNull() {
        return this.deserializer.allowNull();
    }

    @Override
    public T getDefaultValue(Deserializer.DecoderContext context, Argument<? super T> type) {
        return this.deserializer.getDefaultValue(context, type);
    }
}

