/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.support.deserializers.DemuxingObjectDecoder;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserializeSubtypeInfo;
import java.io.IOException;
import java.util.Map;

@Internal
final class SubtypedPropertyObjectDeserializer
implements Deserializer<Object> {
    private final DeserBean<? super Object> deserBean;
    private final Map<String, Deserializer<Object>> deserializers;
    private final Deserializer<Object> supertypeDeserializer;
    private final boolean discriminatorVisible;

    public SubtypedPropertyObjectDeserializer(DeserBean<? super Object> deserBean, Map<String, Deserializer<Object>> deserializers, Deserializer<Object> supertypeDeserializer, boolean discriminatorVisible) {
        this.deserBean = deserBean;
        this.deserializers = deserializers;
        this.supertypeDeserializer = supertypeDeserializer;
        this.discriminatorVisible = discriminatorVisible;
        SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = deserBean.subtypeInfo.info().discriminatorType();
        if (discriminatorType != SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY && discriminatorType != SerdeConfig.SerSubtyped.DiscriminatorType.EXISTING_PROPERTY) {
            throw new IllegalStateException("Unsupported discriminator type: " + discriminatorType);
        }
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        try (DemuxingObjectDecoder.PrimedDecoder primed = DemuxingObjectDecoder.prime(decoder);){
            Decoder typeFinder = this.discriminatorVisible ? primed.decodeObjectNonConsuming(type) : primed.decodeObject((Argument)type);
            Deserializer<Object> deserializer = this.findDeserializer(typeFinder);
            typeFinder.finishStructure(true);
            Object object = deserializer.deserialize(primed, decoderContext, type);
            return object;
        }
    }

    @NonNull
    private Deserializer<Object> findDeserializer(Decoder objectDecoder) throws IOException {
        String key;
        DeserializeSubtypeInfo deserializeSubtypeInfo = this.deserBean.subtypeInfo;
        String discriminatorName = deserializeSubtypeInfo.info().discriminatorName();
        String defaultDiscriminator = deserializeSubtypeInfo.defaultDiscriminator();
        while ((key = objectDecoder.decodeKey()) != null) {
            if (key.equals(discriminatorName)) {
                String subtypeName;
                Deserializer<Object> deserializer;
                if (objectDecoder.decodeNull() || (deserializer = this.deserializers.get(subtypeName = objectDecoder.decodeString())) == null) break;
                return deserializer;
            }
            objectDecoder.skipValue();
        }
        if (defaultDiscriminator != null) {
            return this.deserializers.get(defaultDiscriminator);
        }
        return this.supertypeDeserializer;
    }
}

