/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.beans.KotlinExecutableMethodUtils;
import io.micronaut.web.router.DefaultRouteInfo;
import io.micronaut.web.router.MethodBasedRouteInfo;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
class DefaultMethodBasedRouteInfo<T, R>
extends DefaultRouteInfo<R>
implements MethodBasedRouteInfo<T, R> {
    private static final RequestArgumentBinder[] ZERO_BINDERS = new RequestArgumentBinder[0];
    private final MethodExecutionHandle<T, R> targetMethod;
    private final String[] argumentNames;
    private final boolean isVoid;
    private final Optional<Argument<?>> optionalBodyArgument;
    private final Optional<Argument<?>> optionalFullBodyArgument;
    private final MessageBodyReader<?> messageBodyReader;
    private RequestArgumentBinder<Object>[] argumentBinders;
    private final boolean needsBody;

    public DefaultMethodBasedRouteInfo(MethodExecutionHandle<T, R> targetMethod, @Nullable Argument<?> bodyArgument, @Nullable String bodyArgumentName, List<MediaType> consumesMediaTypes, List<MediaType> producesMediaTypes, boolean isPermitsBody, boolean isErrorRoute, MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        super(targetMethod, targetMethod.getReturnType(), consumesMediaTypes, producesMediaTypes, targetMethod.getDeclaringType(), isErrorRoute, isPermitsBody, messageBodyHandlerRegistry);
        Map requiredInputs;
        this.targetMethod = targetMethod;
        Argument[] arguments = targetMethod.getArguments();
        this.argumentNames = new String[arguments.length];
        if (arguments.length > 0) {
            LinkedHashMap<String, Argument> ri = CollectionUtils.newLinkedHashMap(arguments.length);
            for (int i = 0; i < arguments.length; ++i) {
                Argument requiredArgument = arguments[i];
                String inputName = DefaultMethodBasedRouteInfo.resolveInputName(requiredArgument);
                ri.put(inputName, requiredArgument);
                this.argumentNames[i] = inputName;
            }
            requiredInputs = ri;
        } else {
            requiredInputs = Collections.emptyMap();
        }
        this.isVoid = this.returnType.isVoid() ? true : (this.isSuspended() ? KotlinExecutableMethodUtils.isKotlinFunctionReturnTypeUnit(targetMethod.getExecutableMethod()) : false);
        this.optionalBodyArgument = bodyArgument != null ? Optional.of(bodyArgument) : (bodyArgumentName != null ? Optional.ofNullable((Argument)requiredInputs.get(bodyArgumentName)) : Optional.empty());
        this.optionalFullBodyArgument = super.getFullRequestBodyType();
        this.messageBodyReader = this.optionalBodyArgument.flatMap(b -> {
            if (b.getAnnotationMetadata().stringValue(Body.class).isPresent() || !b.getAnnotationMetadata().hasAnnotation(Body.class)) {
                b = Argument.of(ConvertibleValues.class);
            } else if (b.isAsyncOrReactive() || b.isOptional()) {
                b = b.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            }
            return messageBodyHandlerRegistry.findReader(b, consumesMediaTypes);
        }).orElse(null);
        this.needsBody = this.optionalBodyArgument.isPresent() || DefaultMethodBasedRouteInfo.hasArg(arguments, HttpRequest.class);
    }

    @Override
    public final MessageBodyReader<?> getMessageBodyReader() {
        return this.messageBodyReader;
    }

    private static boolean hasArg(Argument<?>[] arguments, Class<?> type) {
        for (Argument<?> argument : arguments) {
            if (argument.getType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public RequestArgumentBinder<Object>[] resolveArgumentBinders(RequestBinderRegistry requestBinderRegistry) {
        if (this.argumentBinders == null) {
            this.argumentBinders = this.resolveArgumentBindersInternal(requestBinderRegistry);
        }
        return this.argumentBinders;
    }

    private RequestArgumentBinder<Object>[] resolveArgumentBindersInternal(RequestBinderRegistry requestBinderRegistry) {
        Argument[] arguments = this.targetMethod.getArguments();
        if (arguments.length == 0) {
            return ZERO_BINDERS;
        }
        RequestArgumentBinder[] binders = new RequestArgumentBinder[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            Optional argumentBinder = requestBinderRegistry.findArgumentBinder(argument);
            binders[i] = argumentBinder.orElse(null);
        }
        return binders;
    }

    @Override
    public boolean isVoid() {
        return this.isVoid;
    }

    @NonNull
    private static String resolveInputName(@NonNull Argument<?> argument) {
        String inputName = argument.getAnnotationMetadata().stringValue(Bindable.NAME).orElse(null);
        if (StringUtils.isEmpty(inputName)) {
            inputName = argument.getName();
        }
        return inputName;
    }

    @Override
    public MethodExecutionHandle<T, R> getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public Optional<Argument<?>> getRequestBodyType() {
        return this.optionalBodyArgument;
    }

    @Override
    public Optional<Argument<?>> getFullRequestBodyType() {
        return this.optionalFullBodyArgument;
    }

    @Override
    public String[] getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public boolean needsRequestBody() {
        return this.needsBody || super.needsRequestBody();
    }
}

