/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractInitializableBeanDefinitionAndReference;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.conditions.MatchesConditionUtils;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.inject.BeanDefinitionReference;
import java.util.ArrayList;
import java.util.List;

public class RequiresCondition
implements Condition {
    public static final String MEMBER_PROPERTY = "property";
    public static final String MEMBER_NOT_EQUALS = "notEquals";
    public static final String MEMBER_DEFAULT_VALUE = "defaultValue";
    public static final String MEMBER_PATTERN = "pattern";
    public static final String MEMBER_MISSING_PROPERTY = "missingProperty";
    public static final String MEMBER_ENV = "env";
    public static final String MEMBER_NOT_ENV = "notEnv";
    public static final String MEMBER_CONDITION = "condition";
    public static final String MEMBER_SDK = "sdk";
    public static final String MEMBER_VERSION = "version";
    public static final String MEMBER_MISSING_CLASSES = "missing";
    public static final String MEMBER_RESOURCES = "resources";
    public static final String MEMBER_CONFIGURATION = "configuration";
    public static final String MEMBER_CLASSES = "classes";
    public static final String MEMBER_ENTITIES = "entities";
    public static final String MEMBER_BEANS = "beans";
    public static final String MEMBER_MISSING_BEANS = "missingBeans";
    public static final String MEMBER_OS = "os";
    public static final String MEMBER_NOT_OS = "notOs";
    public static final String MEMBER_BEAN = "bean";
    public static final String MEMBER_BEAN_PROPERTY = "beanProperty";
    private final AnnotationMetadata annotationMetadata;

    public RequiresCondition(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }

    @Override
    public boolean matches(ConditionContext context) {
        List<AnnotationValue<Requires>> requirements = this.annotationMetadata.getAnnotationValuesByType(Requires.class);
        if (requirements.isEmpty()) {
            return true;
        }
        Object component = context.getComponent();
        boolean isBeanReference = component instanceof BeanDefinitionReference;
        if (component instanceof AbstractInitializableBeanDefinitionAndReference) {
            for (AnnotationValue<Requires> requirement : requirements) {
                if (!this.processPreStartRequirements(context, requirement)) {
                    return false;
                }
                if (this.processPostStartRequirements(context, requirement)) continue;
                return false;
            }
            return true;
        }
        if (isBeanReference) {
            for (AnnotationValue<Requires> requirement : requirements) {
                if (requirement.hasEvaluatedExpressions() || this.processPreStartRequirements(context, requirement)) continue;
                return false;
            }
        } else {
            for (AnnotationValue<Requires> requires : requirements) {
                if (this.processPostStartRequirements(context, requires)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processPreStartRequirements(ConditionContext context, AnnotationValue<Requires> requirements) {
        ArrayList<Condition> preConditions = new ArrayList<Condition>(5);
        ArrayList<Condition> postConditions = new ArrayList<Condition>(5);
        MatchesConditionUtils.createConditions(requirements, preConditions, postConditions);
        for (Condition condition : preConditions) {
            if (condition.matches(context)) continue;
            return false;
        }
        return true;
    }

    private boolean processPostStartRequirements(ConditionContext context, AnnotationValue<Requires> requirements) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(10);
        MatchesConditionUtils.createConditions(requirements, conditions, conditions);
        for (Condition condition : conditions) {
            if (condition.matches(context)) continue;
            return false;
        }
        return true;
    }
}

