/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.env.DefaultConfigurationPath;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.value.PropertyCatalog;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConfigurationPath
extends Iterable<ConfigurationSegment> {
    @NonNull
    public static ConfigurationPath newPath() {
        return new DefaultConfigurationPath();
    }

    @NonNull
    public static ConfigurationPath of(BeanDefinition<?> ... definitions) {
        ConfigurationPath configurationPath = ConfigurationPath.newPath();
        for (BeanDefinition<?> definition : definitions) {
            if (definition.hasDeclaredAnnotation(EachProperty.class)) {
                configurationPath.pushEachPropertyRoot(definition);
                continue;
            }
            if (!definition.hasDeclaredStereotype((Class<Annotation>)ConfigurationReader.class)) continue;
            configurationPath.pushConfigurationReader(definition);
        }
        return configurationPath;
    }

    public boolean hasDynamicSegments();

    @NonNull
    public ConfigurationPath copy();

    @Nullable
    public ConfigurationPath parent();

    @NonNull
    public String prefix();

    @NonNull
    public String path();

    @Nullable
    public String primary();

    @NonNull
    public ConfigurationSegment.ConfigurationKind kind();

    @Nullable
    public String name();

    public int index();

    @NonNull
    default public PropertyCatalog propertyCatalog() {
        return PropertyCatalog.NORMALIZED;
    }

    @Nullable
    default public <T> Qualifier<T> beanQualifier() {
        String n = this.name();
        if (n != null) {
            return Qualifiers.byName(n);
        }
        return null;
    }

    default public boolean isList() {
        ConfigurationSegment segment = this.peekLast();
        return segment != null && segment.kind() == ConfigurationSegment.ConfigurationKind.LIST;
    }

    @Nullable
    public ConfigurationSegment peekLast();

    default public boolean isPrimary() {
        ConfigurationSegment segment = this.peekLast();
        if (segment != null) {
            String name = segment.name();
            return name != null && name.equals(this.primary());
        }
        return false;
    }

    public void pushEachPropertyRoot(@NonNull BeanDefinition<?> var1);

    public void pushConfigurationReader(@NonNull BeanDefinition<?> var1);

    public void pushConfigurationSegment(@NonNull String var1);

    public void pushConfigurationSegment(int var1);

    @NonNull
    public ConfigurationSegment removeLast();

    public boolean isNotEmpty();

    @NonNull
    public String resolveValue(String var1);

    @Nullable
    public Class<?> configurationType();

    @Nullable
    public String simpleName();

    public void traverseResolvableSegments(@NonNull PropertyResolver var1, @NonNull Consumer<ConfigurationPath> var2);

    public void pushConfigurationSegment(@NonNull ConfigurationSegment var1);

    public boolean isWithin(String var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ConfigurationSegment
    extends CharSequence {
        public String prefix();

        public String path();

        public ConfigurationKind kind();

        @Nullable
        public String name();

        @Nullable
        public String simpleName();

        @Nullable
        public String primary();

        @NonNull
        public Class<?> type();

        public int index();

        public static enum ConfigurationKind {
            ROOT,
            NAME,
            INDEX,
            LIST,
            MAP;

        }
    }
}

