/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.env.ConfigurationPath;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.value.PropertyCatalog;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.inject.BeanDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

final class DefaultConfigurationPath
implements ConfigurationPath {
    private final LinkedList<ConfigurationPath.ConfigurationSegment> list = new LinkedList();
    private String computedPrefix;
    private boolean hasDynamicSegments = false;
    private PropertyCatalog propertyCatalog = PropertyCatalog.NORMALIZED;

    DefaultConfigurationPath() {
        this.recomputeState();
    }

    @Override
    public boolean hasDynamicSegments() {
        return this.hasDynamicSegments || this.kind() == ConfigurationPath.ConfigurationSegment.ConfigurationKind.NAME || this.kind() == ConfigurationPath.ConfigurationSegment.ConfigurationKind.INDEX;
    }

    @Override
    public ConfigurationPath parent() {
        int i = this.list.size();
        if (i > 1) {
            DefaultConfigurationPath configurationPath = new DefaultConfigurationPath();
            configurationPath.list.addAll(this.list.subList(0, i - 1));
            configurationPath.hasDynamicSegments = this.hasDynamicSegments;
            configurationPath.recomputeState();
            return configurationPath;
        }
        return null;
    }

    @Override
    @NonNull
    public ConfigurationPath copy() {
        DefaultConfigurationPath newPath = new DefaultConfigurationPath();
        newPath.list.addAll(this.list);
        newPath.computedPrefix = this.computedPrefix;
        newPath.hasDynamicSegments = this.hasDynamicSegments;
        return newPath;
    }

    @Override
    @NonNull
    public String prefix() {
        return this.computedPrefix;
    }

    @Override
    @NonNull
    public String path() {
        ConfigurationPath.ConfigurationSegment segment = this.peekLast();
        if (segment != null) {
            return segment.path();
        }
        return "";
    }

    @Override
    public String primary() {
        ConfigurationPath.ConfigurationSegment segment = this.peekLast();
        if (segment != null) {
            return segment.primary();
        }
        return null;
    }

    @Override
    public boolean isNotEmpty() {
        return !this.list.isEmpty();
    }

    @Override
    @NonNull
    public String resolveValue(String value) {
        return value.replace(this.path(), this.prefix());
    }

    @Override
    public Class<?> configurationType() {
        ConfigurationPath.ConfigurationSegment segment = this.peekLast();
        if (segment != null) {
            return segment.type();
        }
        return null;
    }

    @Override
    public String name() {
        ConfigurationPath.ConfigurationSegment segment = this.peekLast();
        if (segment != null) {
            return segment.name();
        }
        return null;
    }

    @Override
    public int index() {
        Iterator<ConfigurationPath.ConfigurationSegment> i = this.list.descendingIterator();
        while (i.hasNext()) {
            ConfigurationPath.ConfigurationSegment s2 = i.next();
            if (s2.kind() != ConfigurationPath.ConfigurationSegment.ConfigurationKind.INDEX) continue;
            return s2.index();
        }
        return -1;
    }

    @Override
    @NonNull
    public PropertyCatalog propertyCatalog() {
        return this.propertyCatalog;
    }

    @Override
    public String simpleName() {
        ConfigurationPath.ConfigurationSegment segment = this.peekLast();
        if (segment != null) {
            return segment.simpleName();
        }
        return null;
    }

    @Override
    public void traverseResolvableSegments(@NonNull PropertyResolver propertyResolver, @NonNull Consumer<ConfigurationPath> callback) {
        if (this.hasDynamicSegments) {
            Collection<List<String>> variableValues = propertyResolver.getPropertyPathMatches(this.path());
            for (List<String> variables : variableValues) {
                ConfigurationPath newPath = this.replaceVariables(variables);
                DefaultConfigurationPath.traversePath(newPath, propertyResolver, callback);
            }
        } else {
            DefaultConfigurationPath.traversePath(this, propertyResolver, callback);
        }
    }

    private ConfigurationPath replaceVariables(List<String> variables) {
        int varIndex = 0;
        DefaultConfigurationPath newPath = new DefaultConfigurationPath();
        newPath.hasDynamicSegments = true;
        for (ConfigurationPath.ConfigurationSegment configurationSegment : this.list) {
            block0 : switch (configurationSegment.kind()) {
                case NAME: 
                case INDEX: {
                    if (varIndex < variables.size()) {
                        ConfigurationPath.ConfigurationSegment.ConfigurationKind kind = newPath.kind();
                        switch (kind) {
                            case LIST: {
                                newPath.pushConfigurationSegment(Integer.parseInt(variables.get(varIndex++)));
                                break block0;
                            }
                            case MAP: {
                                newPath.pushConfigurationSegment(variables.get(varIndex++));
                                break block0;
                            }
                        }
                        newPath.pushConfigurationSegment(configurationSegment);
                        break;
                    }
                    newPath.pushConfigurationSegment(configurationSegment);
                    break;
                }
                default: {
                    newPath.pushConfigurationSegment(configurationSegment);
                }
            }
        }
        return newPath;
    }

    private static void traversePath(ConfigurationPath thisPath, PropertyResolver propertyResolver, Consumer<ConfigurationPath> callback) {
        ConfigurationPath.ConfigurationSegment.ConfigurationKind kind = thisPath.kind();
        switch (kind) {
            case MAP: {
                Collection<String> entries = propertyResolver.getPropertyEntries(thisPath.prefix(), thisPath.propertyCatalog());
                for (String key : entries) {
                    ConfigurationPath newPath = thisPath.copy();
                    newPath.pushConfigurationSegment(key);
                    callback.accept(newPath);
                }
                break;
            }
            case LIST: {
                List entries = propertyResolver.getProperty(thisPath.prefix(), List.class, Collections.emptyList());
                for (int i = 0; i < entries.size(); ++i) {
                    Object o = entries.get(i);
                    if (o == null) continue;
                    ConfigurationPath newPath = thisPath.copy();
                    newPath.pushConfigurationSegment(i);
                    callback.accept(newPath);
                }
                break;
            }
            case NAME: 
            case INDEX: {
                ConfigurationPath parent = thisPath.parent();
                if (parent == null) break;
                DefaultConfigurationPath.traversePath(parent, propertyResolver, callback);
                break;
            }
            default: {
                if (!propertyResolver.containsProperties(thisPath.prefix())) break;
                callback.accept(thisPath);
            }
        }
    }

    @Override
    @NonNull
    public ConfigurationPath.ConfigurationSegment.ConfigurationKind kind() {
        ConfigurationPath.ConfigurationSegment segment = this.peekLast();
        if (segment != null) {
            return segment.kind();
        }
        return ConfigurationPath.ConfigurationSegment.ConfigurationKind.ROOT;
    }

    @Override
    public ConfigurationPath.ConfigurationSegment peekLast() {
        return this.list.peekLast();
    }

    @Override
    public boolean isWithin(String prefix) {
        return prefix != null && prefix.startsWith(this.path());
    }

    @Override
    public void pushEachPropertyRoot(@NonNull BeanDefinition<?> beanDefinition) {
        if (!beanDefinition.getBeanType().equals(this.configurationType())) {
            if (this.kind() != ConfigurationPath.ConfigurationSegment.ConfigurationKind.ROOT) {
                this.hasDynamicSegments = true;
            }
            this.propertyCatalog = beanDefinition.enumValue(EachProperty.class, "catalog", PropertyCatalog.class).orElse(PropertyCatalog.NORMALIZED);
            boolean isList = beanDefinition.booleanValue(EachProperty.class, "list").orElse(false);
            String prefix = beanDefinition.stringValue(ConfigurationReader.class, "prefix").orElse(null);
            if (prefix != null) {
                String currentPath = this.path();
                if (!prefix.startsWith(currentPath)) {
                    throw new IllegalStateException("Invalid configuration properties nesting for path [" + prefix + "]. Expected: " + currentPath);
                }
                String resolvedPrefix = prefix;
                if (!currentPath.equals("") && !prefix.equals(currentPath)) {
                    resolvedPrefix = prefix.substring(currentPath.length() + 1);
                }
                String property = resolvedPrefix.substring(0, resolvedPrefix.length() - (isList ? 3 : 2));
                String primaryName = beanDefinition.stringValue(EachProperty.class, "primary").orElse(null);
                this.list.add(new DefaultConfigurationSegment(beanDefinition.getBeanType(), property, prefix, isList ? ConfigurationPath.ConfigurationSegment.ConfigurationKind.LIST : ConfigurationPath.ConfigurationSegment.ConfigurationKind.MAP, null, null, primaryName, -1));
                this.recomputeState();
            }
        }
    }

    @Override
    public void pushConfigurationReader(@NonNull BeanDefinition<?> beanDefinition) {
        if (!beanDefinition.getBeanType().equals(this.configurationType())) {
            String prefix;
            if (this.kind() != ConfigurationPath.ConfigurationSegment.ConfigurationKind.ROOT) {
                this.hasDynamicSegments = true;
            }
            if ((prefix = (String)beanDefinition.stringValue(ConfigurationReader.class, "prefix").orElse(null)) != null) {
                String currentPath = this.path();
                if (!prefix.startsWith(currentPath)) {
                    throw new IllegalStateException("Invalid configuration properties nesting for path [" + prefix + "]. Expected: " + currentPath);
                }
                String p = prefix.substring(currentPath.length() + 1);
                this.list.add(new DefaultConfigurationSegment(beanDefinition.getBeanType(), p, prefix, ConfigurationPath.ConfigurationSegment.ConfigurationKind.ROOT, this.name(), this.simpleName(), this.primary(), -1));
                this.recomputeState();
            }
        }
    }

    @Override
    public void pushConfigurationSegment(@NonNull ConfigurationPath.ConfigurationSegment configurationSegment) {
        ConfigurationPath.ConfigurationSegment.ConfigurationKind kind = configurationSegment.kind();
        switch (kind) {
            case NAME: {
                this.pushConfigurationSegment(configurationSegment.name());
                break;
            }
            case INDEX: {
                this.pushConfigurationSegment(configurationSegment.index());
                break;
            }
            case ROOT: {
                this.list.add(new DefaultConfigurationSegment(configurationSegment.type(), configurationSegment.prefix(), configurationSegment.path(), ConfigurationPath.ConfigurationSegment.ConfigurationKind.ROOT, this.name(), this.simpleName(), this.primary(), this.index()));
                break;
            }
            default: {
                this.list.add(configurationSegment);
            }
        }
        this.recomputeState();
    }

    @Override
    public void pushConfigurationSegment(@NonNull String name) {
        String primary = this.primary();
        ConfigurationPath.ConfigurationSegment.ConfigurationKind kind = this.kind();
        switch (kind) {
            case MAP: {
                break;
            }
            case LIST: {
                throw new IllegalStateException("Illegal @EachProperty nesting encountered. Lists require numerical entries.");
            }
            default: {
                throw new IllegalStateException("Illegal @EachProperty nesting, expecting a nested named not another configuration reader or name.");
            }
        }
        String p = this.path();
        String qualifiedName = this.computeName(name);
        this.list.add(new DefaultConfigurationSegment(this.configurationType(), name, p, ConfigurationPath.ConfigurationSegment.ConfigurationKind.NAME, qualifiedName, name, primary, -1));
        this.recomputeState();
    }

    @Override
    public void pushConfigurationSegment(int index) {
        ConfigurationPath.ConfigurationSegment.ConfigurationKind kind = this.kind();
        switch (kind) {
            case MAP: {
                throw new IllegalStateException("Illegal @EachProperty nesting encountered. Maps require key entries.");
            }
            case LIST: {
                break;
            }
            default: {
                throw new IllegalStateException("Illegal @EachProperty nesting, expecting a nested named not another configuration reader or name.");
            }
        }
        String p = this.path();
        String primary = this.primary();
        String strIndex = String.valueOf(index);
        String qualifiedName = this.computeName(strIndex);
        this.list.add(new DefaultConfigurationSegment(this.configurationType(), "[" + strIndex + "]", p, ConfigurationPath.ConfigurationSegment.ConfigurationKind.INDEX, qualifiedName, strIndex, primary, index));
        this.recomputeState();
    }

    private String computeName(String simpleName) {
        Object qualifiedName = null;
        Iterator<ConfigurationPath.ConfigurationSegment> i = this.list.descendingIterator();
        while (i.hasNext() && (qualifiedName = i.next().name()) == null) {
        }
        qualifiedName = qualifiedName != null ? (String)qualifiedName + "-" + simpleName : simpleName;
        return qualifiedName;
    }

    private void recomputeState() {
        StringBuilder str = new StringBuilder();
        Iterator i = this.list.iterator();
        ConfigurationPath.ConfigurationSegment previous = null;
        while (i.hasNext()) {
            ConfigurationPath.ConfigurationSegment configurationSegment = (ConfigurationPath.ConfigurationSegment)i.next();
            if (configurationSegment.kind() == ConfigurationPath.ConfigurationSegment.ConfigurationKind.INDEX) {
                str.append('[').append(configurationSegment.index()).append(']');
            } else {
                if (previous != null) {
                    str.append('.');
                }
                str.append(configurationSegment);
            }
            previous = configurationSegment;
        }
        this.computedPrefix = str.toString();
    }

    @Override
    @NonNull
    public ConfigurationPath.ConfigurationSegment removeLast() {
        try {
            ConfigurationPath.ConfigurationSegment configurationSegment = this.list.removeLast();
            return configurationSegment;
        }
        finally {
            this.recomputeState();
        }
    }

    public String toString() {
        return this.computedPrefix;
    }

    @Override
    @NonNull
    public Iterator<ConfigurationPath.ConfigurationSegment> iterator() {
        return this.list.iterator();
    }

    record DefaultConfigurationSegment(Class<?> type, String prefix, String path, ConfigurationPath.ConfigurationSegment.ConfigurationKind kind, String name, String simpleName, String primary, int index) implements ConfigurationPath.ConfigurationSegment
    {
        @Override
        public int length() {
            return this.prefix.length();
        }

        @Override
        public char charAt(int index) {
            return this.prefix.charAt(index);
        }

        @Override
        @NonNull
        public CharSequence subSequence(int start, int end) {
            return this.prefix.subSequence(start, end);
        }

        @Override
        @NonNull
        public String toString() {
            return this.prefix;
        }
    }
}

