/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.filter.FilterContext;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.InternalHttpFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiFunction;

@Internal
public class FilterRunner {
    @Nullable
    private final List<InternalHttpFilter> preMatchingFilters;
    @Nullable
    private final List<InternalHttpFilter> filters;
    private final BiFunction<HttpRequest<?>, PropagatedContext, ExecutionFlow<HttpResponse<?>>> responseProvider;

    public FilterRunner(List<GenericHttpFilter> filters, BiFunction<HttpRequest<?>, PropagatedContext, ExecutionFlow<HttpResponse<?>>> responseProvider) {
        this(null, filters, responseProvider);
    }

    public FilterRunner(List<GenericHttpFilter> filters) {
        this(null, filters, null);
    }

    public FilterRunner(@Nullable List<GenericHttpFilter> preMatchingFilters, @Nullable List<GenericHttpFilter> filters, BiFunction<HttpRequest<?>, PropagatedContext, ExecutionFlow<HttpResponse<?>>> responseProvider) {
        this.preMatchingFilters = preMatchingFilters;
        this.filters = filters;
        this.responseProvider = responseProvider;
    }

    private static void checkOrdered(List<? extends GenericHttpFilter> filters) {
        if (!filters.stream().allMatch(f -> f instanceof Ordered)) {
            throw new IllegalStateException("Some filters cannot be ordered: " + String.valueOf(filters));
        }
    }

    public static void sort(@NonNull List<GenericHttpFilter> filters) {
        if (filters.isEmpty()) {
            return;
        }
        FilterRunner.checkOrdered(filters);
        OrderUtil.sortOrdered(filters);
    }

    public static void sortReverse(@NonNull List<GenericHttpFilter> filters) {
        if (filters.isEmpty()) {
            return;
        }
        FilterRunner.checkOrdered(filters);
        OrderUtil.reverseSortOrdered(filters);
    }

    protected void doRouteMatch(@NonNull HttpRequest<?> request) {
        throw new IllegalStateException("Route match not supported");
    }

    protected ExecutionFlow<HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response, PropagatedContext propagatedContext) {
        return ExecutionFlow.just(response);
    }

    @Nullable
    protected ExecutionFlow<HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure, PropagatedContext propagatedContext) {
        return null;
    }

    @NonNull
    protected ExecutionFlow<HttpResponse<?>> provideResponse(@NonNull HttpRequest<?> request, @NonNull PropagatedContext propagatedContext) {
        return this.responseProvider.apply(request, propagatedContext);
    }

    @NonNull
    protected List<GenericHttpFilter> findFiltersAfterRouteMatch(@NonNull HttpRequest<?> request) {
        throw new IllegalStateException("Find filters not supported");
    }

    @NonNull
    private List<InternalHttpFilter> findInternalFiltersAfterRouteMatch(@NonNull HttpRequest<?> request) {
        return this.filters == null ? this.findFiltersAfterRouteMatch(request) : this.filters;
    }

    @NonNull
    public final ExecutionFlow<HttpResponse<?>> run(@NonNull HttpRequest<?> request) {
        return this.run(request, PropagatedContext.getOrEmpty());
    }

    public final ExecutionFlow<HttpResponse<?>> run(HttpRequest<?> request, PropagatedContext propagatedContext) {
        ListIterator<InternalHttpFilter> iterator;
        if (this.preMatchingFilters != null) {
            List<InternalHttpFilter> filtersToRun = this.filterFilters(this.preMatchingFilters, request);
            if (filtersToRun.isEmpty()) {
                try {
                    this.doRouteMatch(request);
                }
                catch (Throwable t2) {
                    return this.processFailure(request, t2, propagatedContext);
                }
                filtersToRun = this.filterFilters(this.findInternalFiltersAfterRouteMatch(request), request);
                iterator = filtersToRun.listIterator();
            } else {
                RouteMatchResolverHttpFilter f = new RouteMatchResolverHttpFilter();
                filtersToRun.add(f);
                iterator = filtersToRun.listIterator();
                f.filterIterator = iterator;
            }
        } else {
            iterator = this.filterFilters(this.filters, request).listIterator();
        }
        if (!iterator.hasNext()) {
            return this.provideResponse(request, propagatedContext);
        }
        ExecutionFlow<FilterContext> flow = this.filterRequest(new FilterContext(request, propagatedContext), iterator);
        FilterContext flowContext = flow.tryCompleteValue();
        if (flowContext != null) {
            return this.filterResponse(flowContext, iterator, null);
        }
        return flow.flatMap(context -> this.filterResponse((FilterContext)context, iterator, null));
    }

    private List<InternalHttpFilter> filterFilters(List<InternalHttpFilter> filters, HttpRequest<?> request) {
        ArrayList<InternalHttpFilter> filtersToRun = new ArrayList<InternalHttpFilter>(filters.size() + 1);
        for (InternalHttpFilter filter : filters) {
            if (!filter.isEnabled(request)) continue;
            filtersToRun.add(filter);
        }
        return filtersToRun;
    }

    private ExecutionFlow<FilterContext> filterRequest(FilterContext context, ListIterator<InternalHttpFilter> iterator) {
        while (iterator.hasNext()) {
            ExecutionFlow<FilterContext> flow;
            InternalHttpFilter filter = iterator.next();
            if (!filter.isFiltersRequest()) continue;
            if (filter.hasContinuation()) {
                flow = filter.processRequestFilter(context, newContext -> {
                    if (newContext.response() != null) {
                        return ExecutionFlow.just(newContext);
                    }
                    return this.filterRequest((FilterContext)newContext, iterator);
                });
            } else {
                flow = filter.processRequestFilter(context);
                FilterContext flowContext = flow.tryCompleteValue();
                if (flowContext != null) {
                    if (context == flowContext) continue;
                    if (flowContext.response() != null) {
                        return ExecutionFlow.just(flowContext);
                    }
                    context = flowContext;
                    continue;
                }
                flow = flow.flatMap(newContext -> {
                    if (newContext.response() != null) {
                        return ExecutionFlow.just(newContext);
                    }
                    return this.filterRequest((FilterContext)newContext, iterator);
                });
            }
            FilterContext finalContext = context;
            return flow.onErrorResume(throwable -> this.processFailureFilterException(finalContext, iterator, (Throwable)throwable));
        }
        return this.provideResponseAndHandleErrors(context, iterator);
    }

    private ExecutionFlow<HttpResponse<?>> filterResponse(FilterContext context, ListIterator<InternalHttpFilter> iterator, @Nullable Throwable exception) {
        while (iterator.hasPrevious()) {
            InternalHttpFilter filter = iterator.previous();
            if (!filter.isFiltersResponse()) continue;
            ExecutionFlow<FilterContext> flow = filter.processResponseFilter(context, exception);
            FilterContext flowContext = flow.tryCompleteValue();
            if (flowContext != null) {
                if (context == flowContext) continue;
                flow = this.processResponse(flowContext.request(), flowContext.response(), flowContext.propagatedContext()).map(flowContext::withResponse);
                exception = null;
                flowContext = flow.tryCompleteValue();
                if (flowContext != null) {
                    context = flowContext;
                    continue;
                }
            }
            FilterContext finalContext = context;
            Throwable finalException = exception;
            return flow.flatMap(newContext -> {
                if (finalContext != newContext) {
                    return this.processResponse(newContext.request(), newContext.response(), newContext.propagatedContext()).map(newContext::withResponse);
                }
                return ExecutionFlow.just(newContext);
            }).onErrorResume(throwable -> this.processFailurePropagateException((Throwable)throwable, finalContext)).flatMap(newContext -> this.filterResponse((FilterContext)newContext, iterator, newContext.response() == null ? finalException : null));
        }
        if (context.response() != null) {
            return ExecutionFlow.just(context.response());
        }
        if (exception != null) {
            return ExecutionFlow.error(exception);
        }
        return ExecutionFlow.error(new IllegalStateException("No response after response filters completed!"));
    }

    private ExecutionFlow<FilterContext> processFailurePropagateException(Throwable throwable, FilterContext context) {
        ExecutionFlow<HttpResponse<?>> flow = this.processFailure(context.request(), throwable, context.propagatedContext());
        if (flow == null) {
            return ExecutionFlow.error(throwable);
        }
        return flow.map(context::withResponse);
    }

    private ExecutionFlow<FilterContext> provideResponseAndHandleErrors(FilterContext context, ListIterator<InternalHttpFilter> iterator) {
        ExecutionFlow<HttpResponse<?>> flow = this.provideResponse(context.request(), context.propagatedContext());
        if (flow.tryCompleteValue() != null) {
            return flow.map(context::withResponse);
        }
        return flow.map(context::withResponse).onErrorResume(throwable -> this.processFailureFilterException(context, iterator, (Throwable)throwable));
    }

    private ExecutionFlow<FilterContext> processFailureFilterException(FilterContext context, ListIterator<InternalHttpFilter> iterator, Throwable throwable) {
        ExecutionFlow<HttpResponse<?>> flow = this.processFailure(context.request(), throwable, context.propagatedContext());
        if (flow == null) {
            return this.filterResponse(context, iterator, throwable).map(context::withResponse);
        }
        return flow.map(context::withResponse);
    }

    final class RouteMatchResolverHttpFilter
    implements InternalHttpFilter {
        private ListIterator<InternalHttpFilter> filterIterator;

        RouteMatchResolverHttpFilter() {
        }

        @Override
        public boolean isFiltersRequest() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecutionFlow<FilterContext> processRequestFilter(FilterContext context) {
            HttpRequest<?> request = context.request();
            try {
                FilterRunner.this.doRouteMatch(request);
                ExecutionFlow<FilterContext> executionFlow = ExecutionFlow.just(context);
                return executionFlow;
            }
            catch (Throwable throwable) {
                ExecutionFlow<FilterContext> executionFlow = FilterRunner.this.processFailurePropagateException(throwable, context);
                return executionFlow;
            }
            finally {
                this.filterIterator.remove();
                while (this.filterIterator.hasPrevious()) {
                    this.filterIterator.previous();
                    this.filterIterator.remove();
                }
                List<InternalHttpFilter> postFilters = FilterRunner.this.findInternalFiltersAfterRouteMatch(request);
                for (InternalHttpFilter postFilter : postFilters) {
                    this.filterIterator.add(postFilter);
                }
                while (this.filterIterator.hasPrevious()) {
                    this.filterIterator.previous();
                }
            }
        }
    }
}

