/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.ssl.SslConfiguration;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.SslProvider;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;

@Internal
public final class NettyTlsUtils {
    private static boolean useOpenssl(SslConfiguration sslConfiguration) {
        return sslConfiguration.isPreferOpenssl() && SslProvider.isAlpnSupported(SslProvider.OPENSSL_REFCNT);
    }

    public static SslProvider sslProvider(SslConfiguration sslConfiguration) {
        return NettyTlsUtils.useOpenssl(sslConfiguration) ? SslProvider.OPENSSL_REFCNT : SslProvider.JDK;
    }

    @NonNull
    public static KeyManagerFactory storeToFactory(@NonNull SslConfiguration ssl, @Nullable KeyStore keyStore) throws Exception {
        KeyManagerFactory keyManagerFactory = NettyTlsUtils.useOpenssl(ssl) ? (keyStore == null || keyStore.aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()))) : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        Optional<String> password = ssl.getKey().getPassword();
        char[] keyPassword = password.map(String::toCharArray).orElse(null);
        Optional<String> pwd = ssl.getKeyStore().getPassword();
        if (keyPassword == null && pwd.isPresent()) {
            keyPassword = pwd.get().toCharArray();
        }
        keyManagerFactory.init(keyStore, keyPassword);
        return keyManagerFactory;
    }
}

