/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public interface EventLoopGroupFactory {
    public static final String NATIVE = "native";

    default public boolean isNative() {
        return false;
    }

    public EventLoopGroup createEventLoopGroup(int var1, Executor var2, @Nullable Integer var3);

    default public EventLoopGroup createEventLoopGroup(EventLoopGroupConfiguration configuration, ThreadFactory threadFactory) {
        ArgumentUtils.requireNonNull("configuration", configuration);
        ArgumentUtils.requireNonNull("threadFactory", threadFactory);
        return this.createEventLoopGroup(configuration.getNumThreads(), threadFactory, (Integer)configuration.getIoRatio().orElse(null));
    }

    public EventLoopGroup createEventLoopGroup(int var1, @Nullable ThreadFactory var2, @Nullable Integer var3);

    default public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return this.createEventLoopGroup(threads, (ThreadFactory)null, ioRatio);
    }

    @Deprecated(since="4.5.0", forRemoval=true)
    @NonNull
    default public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return this.channelClass(NettyChannelType.SERVER_SOCKET).asSubclass(ServerSocketChannel.class);
    }

    @NonNull
    @Deprecated(since="4.5.0", forRemoval=true)
    default public Class<? extends ServerDomainSocketChannel> domainServerSocketChannelClass() throws UnsupportedOperationException {
        return this.channelClass(NettyChannelType.DOMAIN_SERVER_SOCKET).asSubclass(ServerDomainSocketChannel.class);
    }

    @NonNull
    default public Class<? extends Channel> channelClass(NettyChannelType type) throws UnsupportedOperationException {
        return switch (type) {
            case NettyChannelType.SERVER_SOCKET -> this.serverSocketChannelClass();
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> this.domainServerSocketChannelClass();
            default -> throw new UnsupportedOperationException("Channel type not supported");
        };
    }

    @Deprecated(since="4.5.0", forRemoval=true)
    @NonNull
    default public Class<? extends ServerSocketChannel> serverSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(NettyChannelType.SERVER_SOCKET, configuration).asSubclass(ServerSocketChannel.class);
    }

    @Deprecated(since="4.5.0", forRemoval=true)
    @NonNull
    default public Class<? extends ServerDomainSocketChannel> domainServerSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(NettyChannelType.DOMAIN_SERVER_SOCKET, configuration).asSubclass(ServerDomainSocketChannel.class);
    }

    @NonNull
    default public Class<? extends Channel> channelClass(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return switch (type) {
            case NettyChannelType.SERVER_SOCKET -> this.serverSocketChannelClass(configuration);
            case NettyChannelType.CLIENT_SOCKET -> this.clientSocketChannelClass(configuration);
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> this.domainServerSocketChannelClass(configuration);
            default -> throw new UnsupportedOperationException("Channel type not supported");
        };
    }

    @Deprecated(since="4.5.0", forRemoval=true)
    @NonNull
    default public ServerSocketChannel serverSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        return (ServerSocketChannel)this.channelInstance(NettyChannelType.SERVER_SOCKET, configuration);
    }

    @Deprecated(since="4.5.0", forRemoval=true)
    @NonNull
    default public ServerChannel domainServerSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        return (ServerChannel)this.channelInstance(NettyChannelType.DOMAIN_SERVER_SOCKET, configuration);
    }

    @NonNull
    default public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return switch (type) {
            case NettyChannelType.SERVER_SOCKET -> this.serverSocketChannelInstance(configuration);
            case NettyChannelType.CLIENT_SOCKET -> this.clientSocketChannelInstance(configuration);
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> this.domainServerSocketChannelInstance(configuration);
            default -> throw new UnsupportedOperationException("Channel type not supported");
        };
    }

    @Deprecated(since="4.4.0")
    @NonNull
    default public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration, int fd) {
        return this.channelInstance(type, configuration, null, fd);
    }

    @NonNull
    default public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration, @Nullable Channel parent, int fd) {
        throw new UnsupportedOperationException("This transport does not support creating channels from file descriptors. Please use kqueue or epoll.");
    }

    @Deprecated(since="4.5.0", forRemoval=true)
    @NonNull
    default public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(NettyChannelType.CLIENT_SOCKET, configuration).asSubclass(SocketChannel.class);
    }

    @Deprecated(since="4.5.0", forRemoval=true)
    @NonNull
    default public SocketChannel clientSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        return (SocketChannel)this.channelInstance(NettyChannelType.CLIENT_SOCKET, configuration);
    }
}

