/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.websocket;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.RequestLifecycle;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketHandler;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.annotation.OnOpen;
import io.micronaut.websocket.annotation.ServerWebSocket;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class NettyServerWebSocketUpgradeHandler
implements RequestHandler {
    public static final String ID = "websocket-upgrade-handler";
    public static final String SCHEME_WEBSOCKET = "ws://";
    public static final String SCHEME_SECURE_WEBSOCKET = "wss://";
    public static final String COMPRESSION_HANDLER = "WebSocketServerCompressionHandler";
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerWebSocketUpgradeHandler.class);
    private static final AsciiString WEB_SOCKET_HEADER_VALUE = AsciiString.cached("websocket");
    private final Router router;
    private final WebSocketBeanRegistry webSocketBeanRegistry;
    private final WebSocketSessionRepository webSocketSessionRepository;
    private final RouteExecutor routeExecutor;
    private final NettyEmbeddedServices nettyEmbeddedServices;
    private final ConversionService conversionService;
    private final NettyHttpServerConfiguration serverConfiguration;
    private WebSocketServerHandshaker handshaker;
    private boolean cancelUpgrade = false;
    private RoutingInBoundHandler next;

    public NettyServerWebSocketUpgradeHandler(NettyEmbeddedServices embeddedServices, WebSocketSessionRepository webSocketSessionRepository, ConversionService conversionService, NettyHttpServerConfiguration serverConfiguration) {
        this.router = embeddedServices.getRouter();
        this.webSocketBeanRegistry = WebSocketBeanRegistry.forServer((BeanContext)embeddedServices.getApplicationContext());
        this.webSocketSessionRepository = webSocketSessionRepository;
        this.routeExecutor = embeddedServices.getRouteExecutor();
        this.nettyEmbeddedServices = embeddedServices;
        this.conversionService = conversionService;
        this.serverConfiguration = serverConfiguration;
    }

    static boolean isWebSocketUpgrade(@NonNull io.netty.handler.codec.http.HttpRequest request) {
        io.netty.handler.codec.http.HttpHeaders headers = request.headers();
        if (headers.containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
            return headers.containsValue(HttpHeaderNames.UPGRADE, WEB_SOCKET_HEADER_VALUE, true);
        }
        return false;
    }

    @Override
    public void accept(ChannelHandlerContext ctx, io.netty.handler.codec.http.HttpRequest request, CloseableByteBody body, OutboundAccess outboundAccess) {
        if (NettyServerWebSocketUpgradeHandler.isWebSocketUpgrade(request)) {
            NettyHttpRequest msg = new NettyHttpRequest(request, body, ctx, this.conversionService, this.serverConfiguration);
            Optional<UriRouteMatch> optionalRoute = this.router.find(HttpMethod.GET, msg.getPath(), msg).filter(rm -> rm.isAnnotationPresent(OnMessage.class) || rm.isAnnotationPresent(OnOpen.class)).findFirst();
            WebsocketRequestLifecycle requestLifecycle = new WebsocketRequestLifecycle(this.routeExecutor, optionalRoute.orElse(null));
            ExecutionFlow<HttpResponse> responseFlow = ExecutionFlow.async(ctx.channel().eventLoop(), () -> {
                try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus(new ServerHttpRequestContext(msg)).propagate();){
                    ExecutionFlow<HttpResponse<?>> executionFlow = requestLifecycle.handle(msg);
                    return executionFlow;
                }
            });
            responseFlow.onComplete((response, throwable) -> {
                if (response != null) {
                    this.writeResponse(ctx, msg, requestLifecycle.shouldProceedNormally, (HttpResponse<?>)response, outboundAccess);
                }
            });
        } else {
            this.next.accept(ctx, request, body, outboundAccess);
        }
    }

    @Override
    public void handleUnboundError(Throwable cause) {
        this.next.handleUnboundError(cause);
    }

    @Override
    public void responseWritten(Object attachment) {
        this.next.responseWritten(attachment);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyHttpRequest<?> msg, boolean shouldProceedNormally, HttpResponse<?> actualResponse, OutboundAccess outboundAccess) {
        if (this.cancelUpgrade) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelling websocket upgrade, handler was removed while request was processing");
            }
            return;
        }
        if (shouldProceedNormally) {
            UriRouteMatch routeMatch = actualResponse.getAttribute(HttpAttributes.ROUTE_MATCH, UriRouteMatch.class).orElseThrow(() -> new IllegalStateException("Route match is required!"));
            WebSocketBean webSocketBean = this.webSocketBeanRegistry.getWebSocket(routeMatch.getTarget().getClass());
            this.handleHandshake(ctx, msg, webSocketBean, actualResponse);
            ChannelPipeline pipeline = ctx.pipeline();
            try {
                NettyServerWebSocketHandler webSocketHandler = new NettyServerWebSocketHandler(this.nettyEmbeddedServices, this.webSocketSessionRepository, this.handshaker, webSocketBean, msg, routeMatch, ctx, this.serverConfiguration.getThreadSelection(), this.routeExecutor.getExecutorSelector(), this.routeExecutor.getCoroutineHelper().orElse(null));
                pipeline.addBefore(ctx.name(), "websocket-handler", webSocketHandler);
                pipeline.remove(ctx.name());
                try {
                    pipeline.remove("http-access-logger");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                ctx.channel().config().setAutoRead(true);
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error opening WebSocket: {}", (Object)e.getMessage(), (Object)e);
                }
                ctx.writeAndFlush(new CloseWebSocketFrame(CloseReason.INTERNAL_ERROR.getCode(), CloseReason.INTERNAL_ERROR.getReason()));
            }
        } else {
            this.next.writeResponse(outboundAccess, msg, actualResponse, null);
        }
    }

    private ChannelFuture handleHandshake(ChannelHandlerContext ctx, NettyHttpRequest req, WebSocketBean<?> webSocketBean, HttpResponse<?> response) {
        io.netty.handler.codec.http.HttpHeaders nettyHeaders;
        int maxFramePayloadLength = webSocketBean.messageMethod().map(m4 -> m4.intValue(OnMessage.class, "maxPayloadLength").orElse(65536)).orElse(65536);
        String subprotocols = webSocketBean.getBeanDefinition().stringValue(ServerWebSocket.class, "subprotocols").filter(s2 -> !StringUtils.isEmpty(s2)).orElse(null);
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(ctx, req), subprotocols, true, maxFramePayloadLength);
        this.handshaker = wsFactory.newHandshaker(req.getNativeRequest());
        HttpHeaders headers = response.getHeaders();
        if (headers instanceof NettyHttpHeaders) {
            NettyHttpHeaders httpHeaders = (NettyHttpHeaders)headers;
            nettyHeaders = httpHeaders.getNettyHeaders();
        } else {
            nettyHeaders = new DefaultHttpHeaders();
            for (Map.Entry entry : headers) {
                nettyHeaders.add(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        Channel channel = ctx.channel();
        if (this.handshaker == null) {
            return WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
        }
        return this.handshaker.handshake(channel, req.toFullHttpRequest(), nettyHeaders, channel.newPromise());
    }

    private String getWebSocketURL(ChannelHandlerContext ctx, HttpRequest req) {
        boolean isSecure = ctx.pipeline().get(SslHandler.class) != null;
        return (isSecure ? SCHEME_SECURE_WEBSOCKET : SCHEME_WEBSOCKET) + (String)req.getHeaders().get(HttpHeaderNames.HOST) + String.valueOf(req.getUri());
    }

    @Override
    public void removed() {
        this.cancelUpgrade = true;
    }

    public void setNext(RoutingInBoundHandler next) {
        this.next = next;
    }

    private static final class WebsocketRequestLifecycle
    extends RequestLifecycle {
        @Nullable
        final RouteMatch<?> route;
        boolean shouldProceedNormally;

        WebsocketRequestLifecycle(RouteExecutor routeExecutor, @Nullable RouteMatch<?> route) {
            super(routeExecutor);
            this.route = route;
        }

        ExecutionFlow<HttpResponse<?>> handle(HttpRequest<?> request) {
            MutableHttpResponse proceed = HttpResponse.ok();
            if (this.route != null) {
                request.setAttribute(HttpAttributes.ROUTE_MATCH, this.route);
                request.setAttribute(HttpAttributes.ROUTE_INFO, this.route);
                proceed.setAttribute(HttpAttributes.ROUTE_MATCH, this.route);
                proceed.setAttribute(HttpAttributes.ROUTE_INFO, this.route);
            }
            ExecutionFlow<HttpResponse<?>> response = this.route != null ? this.runWithFilters(request, (filteredRequest, propagatedContext) -> ExecutionFlow.just(proceed)) : this.onError(request, new HttpStatusException(HttpStatus.NOT_FOUND, "WebSocket Not Found")).putInContext("micronaut.http.server.request", request);
            return response.map(r -> {
                if (r == proceed) {
                    this.shouldProceedNormally = true;
                }
                return r;
            });
        }
    }
}

