/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.logging.impl;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.util.ClassicEnvUtil;
import ch.qos.logback.classic.util.DefaultJoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.logging.LoggingSystemException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;

public final class LogbackUtils {
    private LogbackUtils() {
    }

    public static void configure(@NonNull ClassLoader classLoader, @NonNull LoggerContext context, @NonNull String logbackXmlLocation) {
        LogbackUtils.configure(context, logbackXmlLocation, () -> {
            URL resource = classLoader.getResource(logbackXmlLocation);
            if (resource != null) {
                return resource;
            }
            File file = new File(logbackXmlLocation);
            if (file.exists()) {
                try {
                    resource = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new LoggingSystemException("Error creating URL for off-classpath resource", e);
                }
            }
            return resource;
        }, classLoader);
    }

    private static void configure(@NonNull LoggerContext context, @NonNull String logbackXmlLocation, Supplier<URL> resourceSupplier, ClassLoader classLoader) {
        Configurator configurator;
        List<Configurator> configuratorList = ClassicEnvUtil.loadFromServiceLoader(Configurator.class, classLoader);
        Configurator configurator2 = configurator = CollectionUtils.isNotEmpty(configuratorList) ? configuratorList.get(0) : null;
        if (configurator != null && !(configurator instanceof DefaultJoranConfigurator)) {
            context.getStatusManager().add(new InfoStatus("Using " + configurator.getClass().getName(), context));
            LogbackUtils.programmaticConfiguration(context, configurator);
        } else {
            URL resource = resourceSupplier.get();
            if (resource != null) {
                try {
                    DefaultJoranConfigurator defaultConfigurator = new DefaultJoranConfigurator();
                    defaultConfigurator.setContext(context);
                    defaultConfigurator.configureByResource(resource);
                }
                catch (JoranException e) {
                    throw new LoggingSystemException("Error while refreshing Logback", e);
                }
            } else {
                throw new LoggingSystemException("Resource " + logbackXmlLocation + " not found");
            }
        }
    }

    private static void programmaticConfiguration(@NonNull LoggerContext context, @NonNull Configurator configurator) {
        try {
            configurator.setContext(context);
            configurator.configure(context);
        }
        catch (Exception e) {
            throw new LoggingSystemException("Failed to initialize Configurator: %s using ServiceLoader".formatted(configurator.getClass().getCanonicalName()), e);
        }
    }
}

