/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;

final class EnumValueDeserializer<E extends Enum<E>>
implements Deserializer<E> {
    private final Argument<Object> valueType;
    private final Deserializer<?> valueDeserializer;
    private final boolean allowNull;
    private final Map<Object, E> serializedCache;

    EnumValueDeserializer(Argument<Object> valueType, Deserializer<?> valueDeserializer, boolean allowNull, Map<Object, E> serializedCache) {
        this.valueType = valueType;
        this.valueDeserializer = valueDeserializer;
        this.allowNull = allowNull;
        this.serializedCache = serializedCache;
    }

    @NonNull
    private E transform(@NonNull Decoder decoder, Object value) throws IOException {
        Enum enumValue = (Enum)this.serializedCache.get(value);
        if (enumValue == null) {
            String allowedValues = this.serializedCache.keySet().stream().map(Object::toString).collect(Collectors.joining(", "));
            throw decoder.createDeserializationException("Expected one of [%s] but was '%s'".formatted(allowedValues, value), value);
        }
        return (E)enumValue;
    }

    @Override
    public E deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) throws IOException {
        return this.transform(decoder, this.valueDeserializer.deserialize(decoder, context, this.valueType));
    }

    @Override
    public E deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) throws IOException {
        Object v = this.valueDeserializer.deserializeNullable(decoder, context, this.valueType);
        if (!this.allowNull && v == null) {
            return null;
        }
        return this.transform(decoder, v);
    }
}

