/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class ShortArraySerde
implements SerdeRegistrar<short[]> {
    ShortArraySerde() {
    }

    @Override
    public short[] deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super short[]> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        short[] buffer = new short[50];
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            if (buffer.length == index) {
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            if (!arrayDecoder.decodeNull()) {
                buffer[index] = arrayDecoder.decodeShort();
            }
            ++index;
        }
        arrayDecoder.finishStructure();
        return Arrays.copyOf(buffer, index);
    }

    @Override
    public short[] deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super short[]> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends short[]> type, short[] value) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        for (short i : value) {
            arrayEncoder.encodeShort(i);
        }
        arrayEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, short[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public Argument<short[]> getType() {
        return Argument.of(short[].class);
    }
}

