/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanReadProperty;
import io.micronaut.core.beans.UnsafeBeanReadProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.PropertyFilter;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.util.SerdeAnnotationUtil;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import io.micronaut.serde.support.util.SubtypeInfo;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.LoggerFactory;

@Internal
final class SerBean<T> {
    private static final Comparator<BeanReadProperty<?, Object>> BEAN_PROPERTY_COMPARATOR = (o1, o2) -> OrderUtil.COMPARATOR.compare(new Ordered((BeanReadProperty)o1){
        final /* synthetic */ BeanReadProperty val$o1;
        {
            this.val$o1 = beanReadProperty;
        }

        @Override
        public int getOrder() {
            return this.val$o1.intValue(Order.class).orElse(0);
        }
    }, new Ordered((BeanReadProperty)o2){
        final /* synthetic */ BeanReadProperty val$o2;
        {
            this.val$o2 = beanReadProperty;
        }

        @Override
        public int getOrder() {
            return this.val$o2.intValue(Order.class).orElse(0);
        }
    });
    private static final String JK_PROP = "com.fasterxml.jackson.annotation.JsonProperty";
    private static final String JACKSON_VALUE = "com.fasterxml.jackson.annotation.JsonValue";
    @NonNull
    public final BeanIntrospection<T> introspection;
    public final List<SerProperty<T, Object>> writeProperties;
    @Nullable
    public final String wrapperProperty;
    @Nullable
    public final String arrayWrapperProperty;
    @Nullable
    public SerProperty<T, Object> jsonValue;
    public final SerializationConfiguration configuration;
    public final boolean simpleBean;
    public final boolean subtyped;
    public final PropertyFilter propertyFilter;
    public final SubtypeInfo subtypeInfo;
    @Nullable
    private final SerdeArgumentConf serdeArgumentConf;
    private volatile boolean initialized;
    private volatile boolean initializing;
    private List<Initializer> initializers = new ArrayList<Initializer>();

    SerBean(Argument<T> type, SerdeIntrospections introspections, Serializer.EncoderContext encoderContext, @Nullable SerdeArgumentConf serdeArgumentConf, SerializationConfiguration serializationConfiguration, @Nullable BeanContext beanContext) throws SerdeException {
        this.serdeArgumentConf = serdeArgumentConf;
        this.configuration = encoderContext.getSerializationConfiguration().orElse(serializationConfiguration);
        this.introspection = introspections.getSerializableIntrospection(type);
        this.propertyFilter = this.getPropertyFilterIfPresent(beanContext, type.getSimpleName());
        this.subtypeInfo = serdeArgumentConf == null ? null : serdeArgumentConf.getSubtypeInfo();
        boolean allowIgnoredProperties = this.introspection.booleanValue(SerdeConfig.SerIgnored.class, "allowSerialize").orElse(false);
        @Nullable Predicate<String> argumentPropertyPredicate = serdeArgumentConf == null ? null : serdeArgumentConf.resolveAllowPropertyPredicate(allowIgnoredProperties);
        PropertyNamingStrategy defaultPropertyNamingStrategy = encoderContext.getSerdeConfiguration().map(SerdeConfiguration::getPropertyNamingStrategy).orElse(null);
        PropertyNamingStrategy entityPropertyNamingStrategy = this.getPropertyNamingStrategy(this.introspection, encoderContext, defaultPropertyNamingStrategy);
        List<Map.Entry> properties = this.introspection.getBeanReadProperties().stream().filter(this::filterProperty).sorted(BEAN_PROPERTY_COMPARATOR).map(beanProperty -> {
            Optional<Argument> constructorArgument = Arrays.stream(this.introspection.getConstructor().getArguments()).filter(a -> a.getName().equals(beanProperty.getName()) && a.getType().equals(beanProperty.getType())).findFirst();
            return constructorArgument.map(argument -> new AbstractMap.SimpleEntry<BeanReadProperty, AnnotationMetadataHierarchy>((BeanReadProperty)beanProperty, new AnnotationMetadataHierarchy(argument.getAnnotationMetadata(), beanProperty.getAnnotationMetadata()))).orElseGet(() -> new AbstractMap.SimpleEntry<BeanReadProperty, AnnotationMetadata>((BeanReadProperty)beanProperty, beanProperty.getAnnotationMetadata()));
        }).toList();
        Map.Entry serPropEntry = properties.stream().filter(bp -> ((AnnotationMetadata)bp.getValue()).hasAnnotation(SerdeConfig.SerValue.class) || ((AnnotationMetadata)bp.getValue()).hasAnnotation(JACKSON_VALUE)).findFirst().orElse(null);
        if (serPropEntry != null) {
            this.wrapperProperty = null;
            BeanReadProperty beanProperty2 = (BeanReadProperty)serPropEntry.getKey();
            Argument serType = beanProperty2.asArgument();
            AnnotationMetadata propertyAnnotationMetadata = (AnnotationMetadata)serPropEntry.getValue();
            this.jsonValue = new PropSerProperty(this, beanProperty2.getName(), beanProperty2.getName(), serType, propertyAnnotationMetadata, beanProperty2);
            this.initializers.add(ctx -> this.initProperty(this.jsonValue, ctx));
            this.writeProperties = Collections.emptyList();
        } else {
            BeanMethod serMethod = this.introspection.getBeanMethods().stream().filter(m4 -> m4.isAnnotationPresent(SerdeConfig.SerValue.class) || m4.getAnnotationMetadata().hasAnnotation(JACKSON_VALUE)).findFirst().orElse(null);
            if (serMethod != null) {
                this.wrapperProperty = null;
                this.jsonValue = new MethodSerProperty(this, serMethod.getName(), serMethod.getName(), serMethod.getReturnType().asArgument(), serMethod.getAnnotationMetadata(), serMethod);
                this.initializers.add(ctx -> this.initProperty(this.jsonValue, ctx));
                this.writeProperties = Collections.emptyList();
            } else {
                AnnotationMetadataHierarchy annotationMetadata = new AnnotationMetadataHierarchy(this.introspection, type.getAnnotationMetadata());
                ArrayList<BeanMethod<T, Object>> jsonGetters = new ArrayList<BeanMethod<T, Object>>(this.introspection.getBeanMethods().size());
                for (BeanMethod<T, Object> beanMethod : this.introspection.getBeanMethods()) {
                    if (!beanMethod.isAnnotationPresent(SerdeConfig.SerGetter.class) && !beanMethod.isAnnotationPresent(SerdeConfig.SerAnyGetter.class)) continue;
                    jsonGetters.add(beanMethod);
                }
                HashSet<String> addedProperties = CollectionUtils.newHashSet(properties.size());
                PropertySubtypeDescriptor propertySubtypeDescriptor = SerBean.findDescriptor(this.subtypeInfo, annotationMetadata, type);
                if (!properties.isEmpty() || !jsonGetters.isEmpty() || propertySubtypeDescriptor != null) {
                    this.writeProperties = new ArrayList<SerProperty<T, Object>>(properties.size() + jsonGetters.size());
                    if (propertySubtypeDescriptor != null) {
                        String string = propertySubtypeDescriptor.name;
                        SerProperty prop = "$CLASS_SIMPLE_NAME".equals(propertySubtypeDescriptor.value) ? new CustomSerProperty<Object, String>(this, string, Argument.of(String.class, string), t2 -> t2.getClass().getSimpleName()) : new InjectedSerProperty(this, string, Argument.of(String.class, string), propertySubtypeDescriptor.value);
                        this.writeProperties.add(prop);
                        this.initializers.add(context -> {
                            try {
                                this.initProperty(prop, context);
                            }
                            catch (SerdeException e) {
                                throw new IntrospectionException("Error configuring subtype binding for type " + this.introspection.getBeanType() + ": " + e.getMessage());
                            }
                        });
                    }
                    for (Map.Entry entry : properties) {
                        BeanReadProperty property = (BeanReadProperty)entry.getKey();
                        Argument argument = property.asArgument();
                        AnnotationMetadata propertyAnnotationMetadata = (AnnotationMetadata)entry.getValue();
                        PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(property.getAnnotationMetadata(), encoderContext, entityPropertyNamingStrategy);
                        SubtypeInfo propSubtypeInfo = SubtypeInfo.createForProperty(propertyAnnotationMetadata);
                        if (propSubtypeInfo != null && propSubtypeInfo.discriminatorType() == SerdeConfig.SerSubtyped.DiscriminatorType.EXTERNAL_PROPERTY) {
                            CustomSerProperty<Object, String> serProperty = new CustomSerProperty<Object, String>(this, propSubtypeInfo.discriminatorName(), Argument.STRING, bean -> {
                                Object subtypeValue = property.get(bean);
                                if (subtypeValue == null) {
                                    return null;
                                }
                                String[] names = propSubtypeInfo.subtypes().get(subtypeValue.getClass());
                                if (names == null) {
                                    throw new IllegalStateException("Cannot find a subtype definition for class: [" + subtypeValue.getClass().getName() + "] and value [" + subtypeValue + "]");
                                }
                                return names[0];
                            });
                            this.initializers.add(ctx -> {
                                try {
                                    this.initProperty(serProperty, ctx);
                                }
                                catch (SerdeException e) {
                                    throw new SerdeException("Error resolving serializer for property [" + property + "] of type [" + argument.getType().getName() + "]: " + e.getMessage(), e);
                                }
                            });
                            this.writeProperties.add(serProperty);
                        }
                        String originalName = argument.getName();
                        String resolvedPropertyName = this.resolveName(propertyAnnotationMetadata, originalName, serdeArgumentConf, propertyNamingStrategy);
                        if (argumentPropertyPredicate != null && !argumentPropertyPredicate.test(resolvedPropertyName)) continue;
                        addedProperties.add(resolvedPropertyName);
                        PropSerProperty serProperty = new PropSerProperty(this, resolvedPropertyName, originalName, argument, propertyAnnotationMetadata, property);
                        this.initializers.add(ctx -> {
                            try {
                                this.initProperty(serProperty, ctx);
                            }
                            catch (SerdeException e) {
                                throw new SerdeException("Error resolving serializer for property [" + property + "] of type [" + argument.getType().getName() + "]: " + e.getMessage(), e);
                            }
                        });
                        this.writeProperties.add(serProperty);
                    }
                    for (BeanMethod beanMethod : jsonGetters) {
                        PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(beanMethod.getAnnotationMetadata(), encoderContext, entityPropertyNamingStrategy);
                        AnnotationMetadata jsonGetterAnnotationMetadata = beanMethod.getAnnotationMetadata();
                        String originalName = NameUtils.getPropertyNameForGetter(beanMethod.getName());
                        String resolvedPropertyName = this.resolveName(jsonGetterAnnotationMetadata, originalName, serdeArgumentConf, propertyNamingStrategy);
                        if (argumentPropertyPredicate != null && !argumentPropertyPredicate.test(resolvedPropertyName) || !addedProperties.add(resolvedPropertyName)) continue;
                        Argument returnType = beanMethod.getReturnType().asArgument();
                        MethodSerProperty prop = new MethodSerProperty(this, resolvedPropertyName, originalName, returnType, jsonGetterAnnotationMetadata, beanMethod);
                        this.writeProperties.add(prop);
                        this.initializers.add(ctx -> this.initProperty(prop, ctx));
                    }
                } else {
                    this.writeProperties = new ArrayList<SerProperty<T, Object>>();
                }
                this.wrapperProperty = this.introspection.stringValue(SerdeConfig.class, "wrapperProperty").orElse(null);
            }
        }
        if (!this.writeProperties.isEmpty() && serdeArgumentConf != null && serdeArgumentConf.order() != null) {
            ArrayList<SerProperty<T, Object>> orderProps = new ArrayList<SerProperty<T, Object>>(this.writeProperties);
            List order = Arrays.stream(serdeArgumentConf.order()).flatMap(propName -> {
                Optional<SerProperty> prop = orderProps.stream().filter(p -> p.name.equals(propName) || p.originalName.equals(propName)).findFirst();
                prop.ifPresent(orderProps::remove);
                return prop.stream();
            }).toList();
            this.writeProperties.sort(Comparator.comparingInt(order::indexOf));
        }
        this.arrayWrapperProperty = this.introspection.stringValue(SerdeConfig.class, "arrayWrapperProperty").orElse(null);
        this.simpleBean = this.isSimpleBean();
        boolean isAbstractIntrospection = Modifier.isAbstract(this.introspection.getBeanType().getModifiers());
        this.subtyped = isAbstractIntrospection || this.subtypeInfo != null && !this.subtypeInfo.subtypes().containsKey(type.getType()) || this.introspection.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class);
    }

    @Nullable
    private static PropertySubtypeDescriptor findDescriptor(@Nullable SubtypeInfo subtypeInfo, AnnotationMetadata annotationMetadata, Argument<?> type) {
        if (subtypeInfo == null) {
            SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = annotationMetadata.enumValue(SerdeConfig.class, "typeDiscriminatorType", SerdeConfig.SerSubtyped.DiscriminatorType.class).orElse(null);
            if (discriminatorType == SerdeConfig.SerSubtyped.DiscriminatorType.EXISTING_PROPERTY || discriminatorType == SerdeConfig.SerSubtyped.DiscriminatorType.EXTERNAL_PROPERTY) {
                return null;
            }
            String name = annotationMetadata.stringValue(SerdeConfig.class, "typeProperty").orElse(null);
            if (name == null) {
                return null;
            }
            String value = annotationMetadata.stringValue(SerdeConfig.class, "typeName").orElse(null);
            if (value == null) {
                return null;
            }
            return new PropertySubtypeDescriptor(name, value);
        }
        if (subtypeInfo.discriminatorType() != SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY) {
            return null;
        }
        String[] values = subtypeInfo.subtypes().get(type.getType());
        if (values == null) {
            return null;
        }
        return new PropertySubtypeDescriptor(subtypeInfo.discriminatorName(), values[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ReentrantLock lock, Serializer.EncoderContext encoderContext) throws SerdeException {
        if (!this.initialized) {
            lock.lock();
            try {
                if (!this.initialized && !this.initializing) {
                    this.initializing = true;
                    for (Initializer initializer : this.initializers) {
                        initializer.initialize(encoderContext);
                    }
                    this.initializers = null;
                    this.initialized = true;
                    this.initializing = false;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private <Y, Z> void initProperty(SerProperty<Y, Z> prop, Serializer.EncoderContext encoderContext) throws SerdeException {
        if (prop.serializer != null) {
            return;
        }
        Class customSer = prop.annotationMetadata.classValue(SerdeConfig.class, "serializerClass").orElse(null);
        Argument argument = prop.argument;
        if (this.serdeArgumentConf != null) {
            argument = this.serdeArgumentConf.extendArgumentWithPrefixSuffix(argument);
        }
        Object serializer = customSer != null ? encoderContext.findCustomSerializer(customSer) : encoderContext.findSerializer(argument);
        prop.serializer = serializer.createSpecific(encoderContext, argument);
        if (prop.serializableInto) {
            Serializer serializer2 = prop.serializer;
            if (serializer2 instanceof ObjectSerializer) {
                ObjectSerializer objectSerializer;
                prop.objectSerializer = objectSerializer = (ObjectSerializer)serializer2;
            } else {
                throw new SerdeException("Serializer for a property: " + prop.name + " doesn't support serializing into an existing object");
            }
        }
        prop.annotationMetadata = null;
    }

    private boolean isSimpleBean() {
        if (this.propertyFilter != null || this.jsonValue != null) {
            return false;
        }
        for (SerProperty<T, Object> property : this.writeProperties) {
            if (!property.serializableInto && property.backRef == null && property.include == SerdeConfig.SerInclude.ALWAYS && property.views == null && property.managedRef == null) continue;
            return false;
        }
        return true;
    }

    private PropertyNamingStrategy getPropertyNamingStrategy(AnnotationMetadata annotationMetadata, Serializer.EncoderContext encoderContext, PropertyNamingStrategy defaultNamingStrategy) throws SerdeException {
        Class namingStrategyClass = annotationMetadata.classValue(SerdeConfig.class, "runtimeNaming").orElse(null);
        return namingStrategyClass == null ? defaultNamingStrategy : encoderContext.findNamingStrategy(namingStrategyClass);
    }

    private String resolveName(final AnnotationMetadata propertyAnnotationMetadata, final String name, @Nullable SerdeArgumentConf serdeArgumentConf, PropertyNamingStrategy propertyNamingStrategy) {
        String resolvedName = propertyAnnotationMetadata.stringValue(SerdeConfig.class, "property").orElseGet(() -> {
            if (propertyNamingStrategy == null) {
                return null;
            }
            return propertyNamingStrategy.translate(new AnnotatedElement(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public AnnotationMetadata getAnnotationMetadata() {
                    return propertyAnnotationMetadata;
                }
            });
        });
        if (resolvedName == null) {
            resolvedName = propertyAnnotationMetadata.stringValue(JK_PROP).orElse(name);
        }
        if (serdeArgumentConf != null) {
            return serdeArgumentConf.applyPrefixSuffix(resolvedName);
        }
        return resolvedName;
    }

    private PropertyFilter getPropertyFilterIfPresent(@Nullable BeanContext beanContext, String typeName) {
        Optional<String> filterName = this.introspection.stringValue(SerdeConfig.class, "filter");
        if (beanContext != null && filterName.isPresent() && !filterName.get().isEmpty()) {
            return beanContext.findBean(PropertyFilter.class, Qualifiers.byName(filterName.get())).orElseGet(() -> {
                LoggerFactory.getLogger(SerBean.class).warn("Json filter with name '{}' was defined on type {} but no PropertyFilter bean with the name exists", filterName.get(), (Object)typeName);
                return null;
            });
        }
        return null;
    }

    private boolean filterProperty(BeanReadProperty<T, Object> property) {
        return property.booleanValue(SerdeConfig.class, "ignored").orElse(false) == false && property.booleanValue(SerdeConfig.class, "ignoredSerialization").orElse(false) == false && property.booleanValue(SerdeConfig.class, "writeOnly").orElse(false) == false;
    }

    static final class PropSerProperty<B, P>
    extends SerProperty<B, P> {
        private final UnsafeBeanReadProperty<B, P> beanProperty;

        public PropSerProperty(SerBean<B> bean, String name, String originalName, Argument<P> argument, AnnotationMetadata annotationMetadata, BeanReadProperty<B, P> beanProperty) {
            super(bean, name, originalName, argument, annotationMetadata);
            this.beanProperty = (UnsafeBeanReadProperty)beanProperty;
        }

        @Override
        public P get(B bean) {
            return this.beanProperty.getUnsafe(bean);
        }
    }

    @Internal
    static abstract class SerProperty<B, P> {
        public final String name;
        public final String originalName;
        public final Argument<P> argument;
        public final Class<?>[] views;
        public final String managedRef;
        public final String backRef;
        public final SerdeConfig.SerInclude include;
        public final boolean serializableInto;
        public Serializer<P> serializer;
        @Nullable
        public ObjectSerializer<P> objectSerializer;
        public AnnotationMetadata annotationMetadata;

        public SerProperty(SerBean<B> bean, @NonNull String name, @NonNull String originalName, @NonNull Argument<P> argument) {
            this(bean, name, originalName, argument, argument.getAnnotationMetadata());
        }

        public SerProperty(SerBean<B> bean, @NonNull String name, @NonNull String originalName, @NonNull Argument<P> argument, @NonNull AnnotationMetadata annotationMetadata) {
            this.name = name;
            this.originalName = originalName;
            this.argument = argument;
            AnnotationMetadata beanMetadata = bean.introspection.getAnnotationMetadata();
            AnnotationMetadata hierarchy = annotationMetadata.isEmpty() ? beanMetadata : new AnnotationMetadataHierarchy(beanMetadata, annotationMetadata);
            this.views = SerdeAnnotationUtil.resolveViews(beanMetadata, annotationMetadata);
            this.include = hierarchy.enumValue(SerdeConfig.class, "include", SerdeConfig.SerInclude.class).orElse(bean.configuration.getInclusion());
            this.managedRef = annotationMetadata.stringValue(SerdeConfig.SerManagedRef.class).orElse(null);
            this.backRef = annotationMetadata.stringValue(SerdeConfig.SerBackRef.class).orElse(null);
            this.annotationMetadata = annotationMetadata;
            this.serializableInto = annotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class) || annotationMetadata.hasAnnotation(SerdeConfig.SerAnyGetter.class);
        }

        public abstract P get(B var1);
    }

    private static interface Initializer {
        public void initialize(Serializer.EncoderContext var1) throws SerdeException;
    }

    static final class MethodSerProperty<B, P>
    extends SerProperty<B, P> {
        private final BeanMethod<B, P> beanMethod;

        public MethodSerProperty(SerBean<B> bean, String name, String originalName, Argument<P> argument, AnnotationMetadata annotationMetadata, BeanMethod<B, P> beanMethod) {
            super(bean, name, originalName, argument, annotationMetadata);
            this.beanMethod = beanMethod;
        }

        @Override
        public P get(B bean) {
            return (P)this.beanMethod.invoke(bean, new Object[0]);
        }
    }

    private record PropertySubtypeDescriptor(String name, String value) {
    }

    static final class CustomSerProperty<B, P>
    extends SerProperty<B, P> {
        private final Function<B, P> reader;

        public CustomSerProperty(SerBean<B> bean, String name, Argument<P> argument, Function<B, P> reader) {
            super(bean, name, name, argument);
            this.reader = reader;
        }

        @Override
        public P get(B bean) {
            return this.reader.apply(bean);
        }
    }

    static final class InjectedSerProperty<B, P>
    extends SerProperty<B, P> {
        private final P injected;

        public InjectedSerProperty(SerBean<B> bean, String name, Argument<P> argument, P injected) {
            super(bean, name, name, argument);
            this.injected = injected;
        }

        @Override
        public P get(B bean) {
            return this.injected;
        }
    }
}

