/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.web.router.DefaultRequestMatcher;
import io.micronaut.web.router.ErrorRouteInfo;
import io.micronaut.web.router.ErrorRouteMatch;
import io.micronaut.web.router.RouteMatch;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

@Internal
public final class DefaultErrorRouteInfo<T, R>
extends DefaultRequestMatcher<T, R>
implements ErrorRouteInfo<T, R> {
    @Nullable
    private final Class<?> originatingType;
    private final Class<? extends Throwable> exceptionType;
    private final ConversionService conversionService;

    public DefaultErrorRouteInfo(@Nullable Class<?> originatingType, Class<? extends Throwable> exceptionType, MethodExecutionHandle<T, R> targetMethod, @Nullable String bodyArgumentName, @Nullable Argument<?> bodyArgument, List<MediaType> consumesMediaTypes, List<MediaType> producesMediaTypes, List<Predicate<HttpRequest<?>>> predicates, ConversionService conversionService, MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        super(targetMethod, bodyArgument, bodyArgumentName, consumesMediaTypes, producesMediaTypes, true, true, predicates, messageBodyHandlerRegistry);
        this.originatingType = originatingType;
        this.exceptionType = exceptionType;
        this.conversionService = conversionService;
    }

    @Override
    public Class<?> originatingType() {
        return this.originatingType;
    }

    @Override
    public Class<? extends Throwable> exceptionType() {
        return this.exceptionType;
    }

    @Override
    public Optional<RouteMatch<R>> match(Class<?> originatingClass, Throwable exception) {
        if (originatingClass == this.originatingType && this.exceptionType.isInstance(exception)) {
            return Optional.of(new ErrorRouteMatch(exception, this, this.conversionService));
        }
        return Optional.empty();
    }

    @Override
    public Optional<RouteMatch<R>> match(Throwable exception) {
        if (this.originatingType == null && this.exceptionType.isInstance(exception)) {
            return Optional.of(new ErrorRouteMatch(exception, this, this.conversionService));
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public HttpStatus findStatus(HttpStatus defaultStatus) {
        return super.findStatus(defaultStatus == null ? HttpStatus.INTERNAL_SERVER_ERROR : defaultStatus);
    }

    public int hashCode() {
        return ObjectUtils.hash(super.hashCode(), this.exceptionType, this.originatingType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultErrorRouteInfo that = (DefaultErrorRouteInfo)o;
        return this.exceptionType.equals(that.exceptionType) && Objects.equals(this.originatingType, that.originatingType);
    }

    public String toString() {
        return " " + this.exceptionType.getSimpleName() + " -> " + this.getTargetMethod().getDeclaringType().getSimpleName() + "#" + String.valueOf(this.getTargetMethod());
    }
}

