/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.RouteCondition;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.annotation.EvaluatedAnnotationValue;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.scheduling.executor.ThreadSelection;
import io.micronaut.web.router.DefaultErrorRouteInfo;
import io.micronaut.web.router.DefaultFilterRoute;
import io.micronaut.web.router.DefaultStatusRouteInfo;
import io.micronaut.web.router.DefaultUrlRouteInfo;
import io.micronaut.web.router.ErrorRoute;
import io.micronaut.web.router.ErrorRouteInfo;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.ResourceRoute;
import io.micronaut.web.router.Route;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.StatusRoute;
import io.micronaut.web.router.StatusRouteInfo;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteInfo;
import io.micronaut.web.router.exceptions.RoutingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultRouteBuilder
implements RouteBuilder {
    public static final RouteBuilder.UriNamingStrategy CAMEL_CASE_NAMING_STRATEGY = new RouteBuilder.UriNamingStrategy(){};
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultRouteBuilder.class);
    protected final ExecutionHandleLocator executionHandleLocator;
    protected final RouteBuilder.UriNamingStrategy uriNamingStrategy;
    protected final ConversionService conversionService;
    protected final Charset defaultCharset;
    private final ExecutorSelector executorSelector;
    private final MessageBodyHandlerRegistry messageBodyHandlerRegistry;
    private DefaultUriRoute currentParentRoute;
    private final List<UriRoute> uriRoutes = new ArrayList<UriRoute>();
    private final List<StatusRoute> statusRoutes = new ArrayList<StatusRoute>();
    private final List<ErrorRoute> errorRoutes = new ArrayList<ErrorRoute>();
    private final List<FilterRoute> filterRoutes = new ArrayList<FilterRoute>();
    private final Set<Integer> exposedPorts = new HashSet<Integer>(5);

    public DefaultRouteBuilder(ExecutionHandleLocator executionHandleLocator) {
        this(executionHandleLocator, CAMEL_CASE_NAMING_STRATEGY);
    }

    public DefaultRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy) {
        this(executionHandleLocator, uriNamingStrategy, ConversionService.SHARED);
    }

    public DefaultRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService conversionService) {
        this.executionHandleLocator = executionHandleLocator;
        this.uriNamingStrategy = uriNamingStrategy;
        this.conversionService = conversionService;
        if (executionHandleLocator instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)executionHandleLocator;
            Environment environment = applicationContext.getEnvironment();
            this.defaultCharset = environment.get("micronaut.application.default-charset", Charset.class, StandardCharsets.UTF_8);
            this.executorSelector = applicationContext.findBean(ExecutorSelector.class).orElse(null);
            this.messageBodyHandlerRegistry = applicationContext.findBean(MessageBodyHandlerRegistry.class).orElse(MessageBodyHandlerRegistry.EMPTY);
        } else {
            this.defaultCharset = StandardCharsets.UTF_8;
            this.executorSelector = null;
            this.messageBodyHandlerRegistry = MessageBodyHandlerRegistry.EMPTY;
        }
    }

    @Override
    public Set<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public List<FilterRoute> getFilterRoutes() {
        return this.filterRoutes;
    }

    @Override
    public FilterRoute addFilter(String pathPattern, BeanLocator beanLocator, BeanDefinition<? extends HttpFilter> definition) {
        DefaultFilterRoute fr = new DefaultFilterRoute(pathPattern, () -> GenericHttpFilter.createLegacyFilter((HttpFilter)beanLocator.getBean(definition), new FilterOrder.Dynamic(definition.getOrder())), definition, false);
        this.filterRoutes.add(fr);
        return fr;
    }

    final FilterRoute addFilter(Supplier<GenericHttpFilter> internalFilter, AnnotationMetadata annotationMetadata, boolean isPreMatching) {
        DefaultFilterRoute fr = new DefaultFilterRoute(internalFilter, annotationMetadata, isPreMatching);
        this.filterRoutes.add(fr);
        return fr;
    }

    @Override
    public List<StatusRoute> getStatusRoutes() {
        return Collections.unmodifiableList(this.statusRoutes);
    }

    @Override
    public List<ErrorRoute> getErrorRoutes() {
        return Collections.unmodifiableList(this.errorRoutes);
    }

    @Override
    public List<UriRoute> getUriRoutes() {
        return Collections.unmodifiableList(this.uriRoutes);
    }

    @Override
    public RouteBuilder.UriNamingStrategy getUriNamingStrategy() {
        return this.uriNamingStrategy;
    }

    @Override
    public ResourceRoute resources(Class<?> cls) {
        return new DefaultResourceRoute(cls);
    }

    @Override
    public ResourceRoute single(Class<?> cls) {
        return new DefaultSingleRoute(cls);
    }

    @Override
    public StatusRoute status(Class<?> originatingClass, HttpStatus status, Class<?> type, String method, Class<?>[] parameterTypes) {
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle<Object, Object> executableHandle = executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        DefaultStatusRoute statusRoute = new DefaultStatusRoute(originatingClass, status, executableHandle, this.conversionService);
        this.statusRoutes.add(statusRoute);
        return statusRoute;
    }

    @Override
    public StatusRoute status(HttpStatus status, Class<?> type, String method, Class<?>[] parameterTypes) {
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle<Object, Object> executableHandle = executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        DefaultStatusRoute statusRoute = new DefaultStatusRoute(status, executableHandle, this.conversionService);
        this.statusRoutes.add(statusRoute);
        return statusRoute;
    }

    @Override
    public ErrorRoute error(Class<?> originatingClass, Class<? extends Throwable> error, Class<?> type, String method, Class<?>[] parameterTypes) {
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle<Object, Object> executableHandle = executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        DefaultErrorRoute errorRoute = new DefaultErrorRoute(originatingClass, error, executableHandle, this.conversionService);
        this.errorRoutes.add(errorRoute);
        return errorRoute;
    }

    @Override
    public ErrorRoute error(Class<? extends Throwable> error, Class<?> type, String method, Class<?>[] parameterTypes) {
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle<Object, Object> executableHandle = executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        DefaultErrorRoute errorRoute = new DefaultErrorRoute(error, executableHandle, this.conversionService);
        this.errorRoutes.add(errorRoute);
        return errorRoute;
    }

    @Override
    public UriRoute GET(String uri, Object target, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.GET, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute GET(String uri, Class<?> type, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.GET, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute POST(String uri, Object target, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.POST, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute POST(String uri, Class<?> type, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.POST, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute PUT(String uri, Object target, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.PUT, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute PUT(String uri, Class<?> type, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.PUT, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute PATCH(String uri, Object target, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.PATCH, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute PATCH(String uri, Class<?> type, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.PATCH, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute DELETE(String uri, Object target, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.DELETE, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute DELETE(String uri, Class<?> type, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.DELETE, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute OPTIONS(String uri, Object target, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.OPTIONS, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute OPTIONS(String uri, Class<?> type, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.OPTIONS, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute HEAD(String uri, Object target, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.HEAD, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute HEAD(String uri, Class<?> type, String method, Class<?> ... parameterTypes) {
        return this.buildRoute(HttpMethod.HEAD, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute TRACE(String uri, Object target, String method, Class<?>[] parameterTypes) {
        return this.buildRoute(HttpMethod.TRACE, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute TRACE(String uri, Class<?> type, String method, Class<?>[] parameterTypes) {
        return this.buildRoute(HttpMethod.TRACE, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute GET(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.GET, uri, beanDefinition, method);
    }

    @Override
    public UriRoute POST(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.POST, uri, beanDefinition, method);
    }

    @Override
    public UriRoute PUT(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.PUT, uri, beanDefinition, method);
    }

    @Override
    public UriRoute PATCH(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.PATCH, uri, beanDefinition, method);
    }

    @Override
    public UriRoute DELETE(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.DELETE, uri, beanDefinition, method);
    }

    @Override
    public UriRoute OPTIONS(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.OPTIONS, uri, beanDefinition, method);
    }

    @Override
    public UriRoute HEAD(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.HEAD, uri, beanDefinition, method);
    }

    @Override
    public UriRoute TRACE(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.TRACE, uri, beanDefinition, method);
    }

    protected UriRoute buildRoute(HttpMethod httpMethod, String uri, Class<?> type, String method, Class<?> ... parameterTypes) {
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle<Object, Object> executableHandle = executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        return this.buildRoute(httpMethod, uri, executableHandle);
    }

    protected UriRoute buildRoute(HttpMethod httpMethod, String uri, MethodExecutionHandle<Object, Object> executableHandle) {
        return this.buildRoute(httpMethod.name(), httpMethod, uri, executableHandle);
    }

    protected UriRoute buildRoute(HttpMethod httpMethod, String uri, List<MediaType> mediaTypes, MethodExecutionHandle<Object, Object> executableHandle) {
        return this.buildRoute(httpMethod.name(), httpMethod, uri, mediaTypes, executableHandle);
    }

    private UriRoute buildRoute(String httpMethodName, HttpMethod httpMethod, String uri, MethodExecutionHandle<Object, Object> executableHandle) {
        return this.buildRoute(httpMethodName, httpMethod, uri, List.of(MediaType.APPLICATION_JSON_TYPE), executableHandle);
    }

    private UriRoute buildRoute(String httpMethodName, HttpMethod httpMethod, String uri, List<MediaType> mediaTypes, MethodExecutionHandle<Object, Object> executableHandle) {
        DefaultUriRoute route;
        if (this.currentParentRoute != null) {
            route = new DefaultUriRoute(httpMethod, this.currentParentRoute.uriMatchTemplate.nest(uri), mediaTypes, executableHandle, httpMethodName, this.conversionService);
            this.currentParentRoute.nestedRoutes.add(route);
        } else {
            route = new DefaultUriRoute(httpMethod, (CharSequence)uri, mediaTypes, executableHandle, httpMethodName, this.conversionService);
        }
        this.uriRoutes.add(route);
        return route;
    }

    private UriRoute buildBeanRoute(HttpMethod httpMethod, String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(httpMethod.name(), httpMethod, uri, beanDefinition, method);
    }

    protected UriRoute buildBeanRoute(String httpMethodName, HttpMethod httpMethod, String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        MethodExecutionHandle<Object, Object> executionHandle = this.executionHandleLocator.createExecutionHandle(beanDefinition, method);
        return this.buildRoute(httpMethodName, httpMethod, uri, executionHandle);
    }

    class DefaultResourceRoute
    implements ResourceRoute {
        private final Map<HttpMethod, Route> resourceRoutes;
        private final DefaultUriRoute getRoute;

        DefaultResourceRoute(Map<HttpMethod, Route> resourceRoutes, DefaultUriRoute getRoute) {
            this.resourceRoutes = resourceRoutes;
            this.getRoute = getRoute;
        }

        DefaultResourceRoute(Class<?> type) {
            Map<HttpMethod, Route> routeMap = this.resourceRoutes = new LinkedHashMap<HttpMethod, Route>();
            this.getRoute = this.buildGetRoute(type, routeMap);
            this.buildRemainingRoutes(type, routeMap);
        }

        @Override
        public RouteInfo<Object> toRouteInfo() {
            throw new IllegalStateException("Not implemented!");
        }

        @Override
        public ResourceRoute consumes(MediaType ... mediaTypes) {
            if (mediaTypes != null) {
                for (Route route : this.resourceRoutes.values()) {
                    route.consumes(mediaTypes);
                }
            }
            return this;
        }

        @Override
        public Route consumesAll() {
            return this.consumes(MediaType.EMPTY_ARRAY);
        }

        @Override
        public ResourceRoute nest(Runnable nested) {
            DefaultUriRoute previous = DefaultRouteBuilder.this.currentParentRoute;
            DefaultRouteBuilder.this.currentParentRoute = this.getRoute;
            try {
                nested.run();
            }
            finally {
                DefaultRouteBuilder.this.currentParentRoute = previous;
            }
            return this;
        }

        @Override
        public ResourceRoute where(Predicate<HttpRequest<?>> condition) {
            for (Route route : this.resourceRoutes.values()) {
                route.where(condition);
            }
            return this;
        }

        @Override
        public ResourceRoute produces(MediaType ... mediaType) {
            if (mediaType != null) {
                for (Route route : this.resourceRoutes.values()) {
                    route.produces(mediaType);
                }
            }
            return this;
        }

        @Override
        public ResourceRoute body(String argument) {
            return this;
        }

        @Override
        public Route body(Argument<?> argument) {
            return this;
        }

        @Override
        public ResourceRoute readOnly(boolean readOnly) {
            List<HttpMethod> excluded = Arrays.asList(HttpMethod.DELETE, HttpMethod.PATCH, HttpMethod.POST, HttpMethod.PUT);
            return this.handleExclude(excluded);
        }

        @Override
        public ResourceRoute exclude(HttpMethod ... methods) {
            return this.handleExclude(Arrays.asList(methods));
        }

        protected ResourceRoute newResourceRoute(Map<HttpMethod, Route> newMap, DefaultUriRoute getRoute) {
            return new DefaultResourceRoute(newMap, getRoute);
        }

        protected DefaultUriRoute buildGetRoute(Class<?> type, Map<HttpMethod, Route> routeMap) {
            DefaultUriRoute getRoute = (DefaultUriRoute)DefaultRouteBuilder.this.GET(type, RouteBuilder.ID);
            routeMap.put(HttpMethod.GET, getRoute);
            return getRoute;
        }

        protected void buildRemainingRoutes(Class<?> type, Map<HttpMethod, Route> routeMap) {
            routeMap.put(HttpMethod.GET, DefaultRouteBuilder.this.GET(type));
            routeMap.put(HttpMethod.POST, DefaultRouteBuilder.this.POST(type));
            routeMap.put(HttpMethod.DELETE, DefaultRouteBuilder.this.DELETE(type, RouteBuilder.ID));
            routeMap.put(HttpMethod.PATCH, DefaultRouteBuilder.this.PATCH(type, RouteBuilder.ID));
            routeMap.put(HttpMethod.PUT, DefaultRouteBuilder.this.PUT(type, RouteBuilder.ID));
        }

        private ResourceRoute handleExclude(List<HttpMethod> excluded) {
            LinkedHashMap<HttpMethod, Route> newMap = new LinkedHashMap<HttpMethod, Route>();
            this.resourceRoutes.forEach((key, value) -> {
                if (excluded.contains(key)) {
                    DefaultRouteBuilder.this.uriRoutes.remove(value);
                } else {
                    newMap.put((HttpMethod)key, (Route)value);
                }
            });
            return this.newResourceRoute(newMap, this.getRoute);
        }
    }

    final class DefaultSingleRoute
    extends DefaultResourceRoute {
        DefaultSingleRoute(Map<HttpMethod, Route> resourceRoutes, DefaultUriRoute getRoute) {
            super(resourceRoutes, getRoute);
        }

        DefaultSingleRoute(Class<?> type) {
            super(type);
        }

        @Override
        protected ResourceRoute newResourceRoute(Map<HttpMethod, Route> newMap, DefaultUriRoute getRoute) {
            return new DefaultSingleRoute(newMap, getRoute);
        }

        @Override
        protected DefaultUriRoute buildGetRoute(Class<?> type, Map<HttpMethod, Route> routeMap) {
            DefaultUriRoute getRoute = (DefaultUriRoute)DefaultRouteBuilder.this.GET(type);
            routeMap.put(HttpMethod.GET, getRoute);
            return getRoute;
        }

        @Override
        protected void buildRemainingRoutes(Class<?> type, Map<HttpMethod, Route> routeMap) {
            routeMap.put(HttpMethod.POST, DefaultRouteBuilder.this.POST(type));
            routeMap.put(HttpMethod.DELETE, DefaultRouteBuilder.this.DELETE(type));
            routeMap.put(HttpMethod.PATCH, DefaultRouteBuilder.this.PATCH(type));
            routeMap.put(HttpMethod.PUT, DefaultRouteBuilder.this.PUT(type));
        }
    }

    final class DefaultStatusRoute
    extends AbstractRoute
    implements StatusRoute {
        private final int statusCode;
        private final Class<?> originatingClass;

        public DefaultStatusRoute(HttpStatus status, MethodExecutionHandle<Object, Object> targetMethod, ConversionService conversionService) {
            this(null, status, targetMethod, conversionService);
        }

        public DefaultStatusRoute(Class<?> originatingClass, HttpStatus status, MethodExecutionHandle<Object, Object> targetMethod, ConversionService conversionService) {
            super(targetMethod, conversionService, Collections.emptyList());
            this.originatingClass = originatingClass;
            this.statusCode = status.getCode();
        }

        @Override
        public StatusRouteInfo<Object, Object> toRouteInfo() {
            return new DefaultStatusRouteInfo<Object, Object>(this.originatingClass, this.statusCode, this.targetMethod, this.bodyArgumentName, this.bodyArgument, this.consumesMediaTypes, this.producesMediaTypes, this.conditions, this.conversionService, DefaultRouteBuilder.this.messageBodyHandlerRegistry);
        }

        @Override
        @Nullable
        public Class<?> originatingType() {
            return this.originatingClass;
        }

        @Override
        public HttpStatus status() {
            return HttpStatus.valueOf(this.statusCode);
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public StatusRoute consumes(MediaType ... mediaType) {
            return this;
        }

        @Override
        public Route consumesAll() {
            return this;
        }

        @Override
        public StatusRoute nest(Runnable nested) {
            return this;
        }

        @Override
        public StatusRoute where(Predicate<HttpRequest<?>> condition) {
            return (StatusRoute)super.where(condition);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultStatusRoute)) {
                return false;
            }
            DefaultStatusRoute that = (DefaultStatusRoute)o;
            if (!super.equals(o)) {
                return false;
            }
            return this.statusCode == that.statusCode && Objects.equals(this.originatingClass, that.originatingClass);
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash(super.hashCode(), this.statusCode, this.originatingClass);
        }
    }

    final class DefaultErrorRoute
    extends AbstractRoute
    implements ErrorRoute {
        private final Class<? extends Throwable> error;
        private final Class<?> originatingClass;

        public DefaultErrorRoute(Class<? extends Throwable> error, MethodExecutionHandle<Object, Object> targetMethod, ConversionService conversionService) {
            this(null, error, targetMethod, conversionService);
        }

        public DefaultErrorRoute(Class<?> originatingClass, Class<? extends Throwable> error, MethodExecutionHandle<Object, Object> targetMethod, ConversionService conversionService) {
            super(targetMethod, conversionService, Collections.emptyList());
            this.originatingClass = originatingClass;
            this.error = error;
        }

        @Override
        public ErrorRouteInfo<Object, Object> toRouteInfo() {
            return new DefaultErrorRouteInfo<Object, Object>(this.originatingClass, this.error, this.targetMethod, this.bodyArgumentName, this.bodyArgument, this.consumesMediaTypes, this.producesMediaTypes, this.conditions, this.conversionService, DefaultRouteBuilder.this.messageBodyHandlerRegistry);
        }

        @Override
        @Nullable
        public Class<?> originatingType() {
            return this.originatingClass;
        }

        @Override
        public Class<? extends Throwable> exceptionType() {
            return this.error;
        }

        @Override
        public ErrorRoute consumes(MediaType ... mediaType) {
            return (ErrorRoute)super.consumes(mediaType);
        }

        @Override
        public ErrorRoute produces(MediaType ... mediaType) {
            return (ErrorRoute)super.produces(mediaType);
        }

        @Override
        public Route consumesAll() {
            super.consumesAll();
            return this;
        }

        @Override
        public ErrorRoute nest(Runnable nested) {
            return this;
        }

        @Override
        public ErrorRoute where(Predicate<HttpRequest<?>> condition) {
            return (ErrorRoute)super.where(condition);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DefaultErrorRoute that = (DefaultErrorRoute)o;
            return this.error.equals(that.error) && Objects.equals(this.originatingClass, that.originatingClass);
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash(super.hashCode(), this.error, this.originatingClass);
        }

        public String toString() {
            return " " + this.error.getSimpleName() + " -> " + this.targetMethod.getDeclaringType().getSimpleName() + "#" + String.valueOf(this.targetMethod);
        }
    }

    final class DefaultUriRoute
    extends AbstractRoute
    implements UriRoute {
        final String httpMethodName;
        final HttpMethod httpMethod;
        final UriMatchTemplate uriMatchTemplate;
        final List<DefaultUriRoute> nestedRoutes;
        private Integer port;
        private final RouteExecutorSelector executorSelector;

        DefaultUriRoute(HttpMethod httpMethod, CharSequence uriTemplate, MethodExecutionHandle<Object, Object> targetMethod, String httpMethodName, ConversionService conversionService) {
            this(httpMethod, uriTemplate, MediaType.APPLICATION_JSON_TYPE, targetMethod, httpMethodName, conversionService);
        }

        DefaultUriRoute(HttpMethod httpMethod, CharSequence uriTemplate, MediaType mediaType, MethodExecutionHandle<Object, Object> targetMethod, String httpMethodName, ConversionService conversionService) {
            this(httpMethod, new UriMatchTemplate(uriTemplate), Collections.singletonList(mediaType), targetMethod, httpMethodName, conversionService);
        }

        DefaultUriRoute(HttpMethod httpMethod, CharSequence uriTemplate, List<MediaType> mediaTypes, MethodExecutionHandle<Object, Object> targetMethod, String httpMethodName, ConversionService conversionService) {
            this(httpMethod, new UriMatchTemplate(uriTemplate), mediaTypes, targetMethod, httpMethodName, conversionService);
        }

        DefaultUriRoute(HttpMethod httpMethod, UriMatchTemplate uriTemplate, MethodExecutionHandle<Object, Object> targetMethod, String httpMethodName, ConversionService conversionService) {
            this(httpMethod, uriTemplate, Collections.singletonList(MediaType.APPLICATION_JSON_TYPE), targetMethod, httpMethodName, conversionService);
        }

        DefaultUriRoute(HttpMethod httpMethod, UriMatchTemplate uriTemplate, List<MediaType> mediaTypes, MethodExecutionHandle<Object, Object> targetMethod, String httpMethodName, ConversionService conversionService) {
            AnnotationValue<RouteCondition> annotation;
            super(targetMethod, conversionService, mediaTypes);
            this.nestedRoutes = new ArrayList<DefaultUriRoute>(2);
            this.executorSelector = new RouteExecutorSelector();
            this.httpMethod = httpMethod;
            this.uriMatchTemplate = uriTemplate;
            this.httpMethodName = httpMethodName;
            if (targetMethod.isPresent(RouteCondition.class, "value") && (annotation = targetMethod.getAnnotation(RouteCondition.class)) instanceof EvaluatedAnnotationValue) {
                this.where((T request) -> annotation.booleanValue().orElse(false));
            }
        }

        @Override
        public UriRouteInfo<Object, Object> toRouteInfo() {
            return new DefaultUrlRouteInfo<Object, Object>(this.httpMethod, this.uriMatchTemplate, DefaultRouteBuilder.this.defaultCharset, this.targetMethod, this.bodyArgumentName, this.bodyArgument, this.consumesMediaTypes, this.producesMediaTypes, this.conditions, this.port, this.conversionService, this.executorSelector, DefaultRouteBuilder.this.messageBodyHandlerRegistry);
        }

        @Override
        public String getHttpMethodName() {
            return this.httpMethodName;
        }

        public String toString() {
            return this.getHttpMethodName() + " " + String.valueOf(this.uriMatchTemplate) + " -> " + this.targetMethod.getDeclaringType().getSimpleName() + "#" + this.targetMethod.getName() + " (" + String.join((CharSequence)",", this.consumesMediaTypes) + ")";
        }

        @Override
        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public UriRoute body(String argument) {
            return (UriRoute)super.body(argument);
        }

        @Override
        public UriRoute exposedPort(int port) {
            this.port = port;
            this.where((T httpRequest) -> httpRequest.getServerAddress().getPort() == port);
            DefaultRouteBuilder.this.exposedPorts.add(port);
            return this;
        }

        @Override
        public Integer getPort() {
            return this.port;
        }

        @Override
        public UriRoute consumes(MediaType ... mediaTypes) {
            return (UriRoute)super.consumes(mediaTypes);
        }

        @Override
        public UriRoute produces(MediaType ... mediaType) {
            return (UriRoute)super.produces(mediaType);
        }

        @Override
        public UriRoute consumesAll() {
            return (UriRoute)super.consumesAll();
        }

        @Override
        public UriRoute nest(Runnable nested) {
            DefaultUriRoute previous = DefaultRouteBuilder.this.currentParentRoute;
            DefaultRouteBuilder.this.currentParentRoute = this;
            try {
                nested.run();
            }
            finally {
                DefaultRouteBuilder.this.currentParentRoute = previous;
            }
            return this;
        }

        @Override
        public UriRoute where(Predicate<HttpRequest<?>> condition) {
            return (UriRoute)super.where(condition);
        }

        @Override
        public UriMatchTemplate getUriMatchTemplate() {
            return this.uriMatchTemplate;
        }

        @Override
        public int compareTo(@NonNull UriRoute o) {
            return this.uriMatchTemplate.compareTo(o.getUriMatchTemplate());
        }

        private final class RouteExecutorSelector
        implements ExecutorSelector {
            private RouteExecutorSelector() {
            }

            @Override
            public Optional<ExecutorService> select(MethodReference<?, ?> method, ThreadSelection threadSelection) {
                if (DefaultRouteBuilder.this.executorSelector != null) {
                    return DefaultRouteBuilder.this.executorSelector.select(DefaultUriRoute.this.targetMethod.getExecutableMethod(), threadSelection);
                }
                return Optional.empty();
            }

            @Override
            public Optional<ExecutorService> select(String name) {
                if (DefaultRouteBuilder.this.executorSelector != null) {
                    return DefaultRouteBuilder.this.executorSelector.select(name);
                }
                return Optional.empty();
            }
        }
    }

    static abstract class AbstractRoute
    implements Route {
        protected final List<Predicate<HttpRequest<?>>> conditions = new ArrayList();
        protected final MethodExecutionHandle<Object, Object> targetMethod;
        protected final ConversionService conversionService;
        protected List<MediaType> consumesMediaTypes;
        protected List<MediaType> producesMediaTypes = List.of();
        protected String bodyArgumentName;
        protected Argument<?> bodyArgument;

        AbstractRoute(MethodExecutionHandle<Object, Object> targetMethod, ConversionService conversionService, List<MediaType> mediaTypes) {
            this.targetMethod = targetMethod;
            this.conversionService = conversionService;
            this.consumesMediaTypes = mediaTypes;
            for (Argument argument : targetMethod.getArguments()) {
                if (!argument.getAnnotationMetadata().hasAnnotation(Body.class)) continue;
                this.bodyArgument = argument;
            }
        }

        @Override
        public Route consumes(MediaType ... mediaTypes) {
            if (mediaTypes != null) {
                this.consumesMediaTypes = List.of(mediaTypes);
            }
            return this;
        }

        @Override
        public List<MediaType> getConsumes() {
            return this.consumesMediaTypes;
        }

        @Override
        public Route consumesAll() {
            this.consumesMediaTypes = Collections.emptyList();
            return this;
        }

        @Override
        public Route where(Predicate<HttpRequest<?>> condition) {
            if (condition != null) {
                this.conditions.add(condition);
            }
            return this;
        }

        @Override
        public Route body(String argument) {
            this.bodyArgumentName = argument;
            return this;
        }

        @Override
        public Route body(Argument<?> argument) {
            this.bodyArgument = argument;
            return this;
        }

        @Override
        public Route produces(MediaType ... mediaType) {
            if (mediaType != null) {
                this.producesMediaTypes = List.of(mediaType);
            }
            return this;
        }

        @Override
        public List<MediaType> getProduces() {
            return this.producesMediaTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractRoute)) {
                return false;
            }
            AbstractRoute that = (AbstractRoute)o;
            return Objects.equals(this.consumesMediaTypes, that.consumesMediaTypes) && Objects.equals(this.producesMediaTypes, that.producesMediaTypes);
        }

        public int hashCode() {
            return ObjectUtils.hash(this.consumesMediaTypes, this.producesMediaTypes);
        }
    }
}

