/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.exceptions;

import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestAttribute;
import io.micronaut.web.router.exceptions.RoutingException;
import io.micronaut.web.router.exceptions.UnsatisfiedBodyRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedCookieValueRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedHeaderRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedPartRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedPathVariableRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedQueryValueRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedRequestAttributeRouteException;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class UnsatisfiedRouteException
extends RoutingException {
    private final Argument<?> argument;

    UnsatisfiedRouteException(String message, Argument<?> argument) {
        super(message);
        this.argument = argument;
    }

    public static UnsatisfiedRouteException create(Argument<?> argument) {
        Optional<Class<? extends Annotation>> classOptional = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (classOptional.isPresent()) {
            Class<? extends Annotation> clazz = classOptional.get();
            String name = argument.getAnnotationMetadata().stringValue(clazz).orElse(argument.getName());
            if (clazz == Body.class) {
                throw new UnsatisfiedBodyRouteException(name, argument);
            }
            if (clazz == QueryValue.class) {
                throw new UnsatisfiedQueryValueRouteException(name, argument);
            }
            if (clazz == PathVariable.class) {
                throw new UnsatisfiedPathVariableRouteException(name, argument);
            }
            if (clazz == Header.class) {
                throw new UnsatisfiedHeaderRouteException(name, argument);
            }
            if (clazz == Part.class) {
                throw new UnsatisfiedPartRouteException(name, argument);
            }
            if (clazz == RequestAttribute.class) {
                throw new UnsatisfiedRequestAttributeRouteException(name, argument);
            }
            if (clazz == CookieValue.class) {
                throw new UnsatisfiedCookieValueRouteException(name, argument);
            }
            throw new UnsatisfiedRouteException("Required " + clazz.getSimpleName() + " [" + name + "] not specified", argument);
        }
        throw new UnsatisfiedRouteException("Required argument [" + String.valueOf(argument) + "] not specified", argument);
    }

    public Argument<?> getArgument() {
        return this.argument;
    }
}

