/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;

@Deprecated
public final class RootlessDockerClientProviderStrategy
extends DockerClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(RootlessDockerClientProviderStrategy.class);
    public static final int PRIORITY = 81;
    @Nullable
    private final AtomicReference<Object> socketPath = new AtomicReference();

    private Path resolveSocketPath() {
        return this.tryEnv().orElseGet(() -> {
            Path homePath = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".docker").resolve("run");
            return this.tryFolder(homePath).orElseGet(() -> {
                Path implicitPath = Paths.get("/run/user/" + LibC.INSTANCE.getuid(), new String[0]);
                return this.tryFolder(implicitPath).orElse(null);
            });
        });
    }

    private Optional<Path> tryEnv() {
        String xdgRuntimeDir = System.getenv("XDG_RUNTIME_DIR");
        if (StringUtils.isBlank(xdgRuntimeDir)) {
            log.debug("$XDG_RUNTIME_DIR is not set.");
            return Optional.empty();
        }
        Path path = Paths.get(xdgRuntimeDir, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            log.debug("$XDG_RUNTIME_DIR is set to '{}' but the folder does not exist.", (Object)path);
            return Optional.empty();
        }
        Path socketPath = path.resolve("docker.sock");
        if (!Files.exists(socketPath, new LinkOption[0])) {
            log.debug("$XDG_RUNTIME_DIR is set but '{}' does not exist.", (Object)socketPath);
            return Optional.empty();
        }
        return Optional.of(socketPath);
    }

    private Optional<Path> tryFolder(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            log.debug("'{}' does not exist.", (Object)path);
            return Optional.empty();
        }
        Path socketPath = path.resolve("docker.sock");
        if (!Files.exists(socketPath, new LinkOption[0])) {
            log.debug("'{}' does not exist.", (Object)socketPath);
            return Optional.empty();
        }
        return Optional.of(socketPath);
    }

    @Override
    public TransportConfig getTransportConfig() throws InvalidConfigurationException {
        return TransportConfig.builder().dockerHost(URI.create("unix://" + this.getSocketPath().toString())).build();
    }

    @Override
    protected boolean isApplicable() {
        return SystemUtils.IS_OS_LINUX && this.getSocketPath() != null && Files.exists(this.getSocketPath(), new LinkOption[0]);
    }

    @Override
    public String getDescription() {
        return "Rootless Docker accessed via Unix socket (" + this.getSocketPath() + ")";
    }

    @Override
    protected int getPriority() {
        return 81;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Path getSocketPath() {
        Object value = this.socketPath.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.socketPath;
            synchronized (atomicReference) {
                value = this.socketPath.get();
                if (value == null) {
                    Path actualValue = this.resolveSocketPath();
                    value = actualValue == null ? this.socketPath : actualValue;
                    this.socketPath.set(value);
                }
            }
        }
        return (Path)(value == this.socketPath ? null : value);
    }

    private static interface LibC
    extends Library {
        public static final LibC INSTANCE = Native.loadLibrary("c", LibC.class);

        public int getuid();
    }
}

