/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.LogContainerCmd;
import java.io.Closeable;
import java.util.function.Consumer;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.output.WaitingConsumer;

public final class LogUtils {
    public static void followOutput(DockerClient dockerClient, String containerId, Consumer<OutputFrame> consumer, OutputFrame.OutputType ... types) {
        LogUtils.attachConsumer(dockerClient, containerId, consumer, true, types);
    }

    public static void followOutput(DockerClient dockerClient, String containerId, Consumer<OutputFrame> consumer) {
        LogUtils.followOutput(dockerClient, containerId, consumer, OutputFrame.OutputType.STDOUT, OutputFrame.OutputType.STDERR);
    }

    public static String getOutput(DockerClient dockerClient, String containerId, OutputFrame.OutputType ... types) {
        String string;
        block10: {
            if (containerId == null) {
                return "";
            }
            if (types.length == 0) {
                types = new OutputFrame.OutputType[]{OutputFrame.OutputType.STDOUT, OutputFrame.OutputType.STDERR};
            }
            ToStringConsumer consumer = new ToStringConsumer();
            WaitingConsumer wait = new WaitingConsumer();
            Closeable closeable = LogUtils.attachConsumer(dockerClient, containerId, consumer.andThen(wait), false, types);
            try {
                wait.waitUntilEnd();
                string = consumer.toUtf8String();
                if (closeable == null) break block10;
            }
            catch (Throwable throwable) {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            closeable.close();
        }
        return string;
    }

    private static Closeable attachConsumer(DockerClient dockerClient, String containerId, Consumer<OutputFrame> consumer, boolean followStream, OutputFrame.OutputType ... types) {
        LogContainerCmd cmd = dockerClient.logContainerCmd(containerId).withFollowStream(followStream).withSince(0);
        FrameConsumerResultCallback callback = new FrameConsumerResultCallback();
        for (OutputFrame.OutputType type : types) {
            callback.addConsumer(type, consumer);
            if (type == OutputFrame.OutputType.STDOUT) {
                cmd.withStdOut(true);
            }
            if (type != OutputFrame.OutputType.STDERR) continue;
            cmd.withStdErr(true);
        }
        return cmd.exec(callback);
    }

    private LogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

