/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.testcontainers;

import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.runtime.converters.time.TimeConverterRegistrar;
import io.micronaut.testresources.testcontainers.MemoryUnitParser;
import io.micronaut.testresources.testcontainers.TestContainerMetadata;
import io.micronaut.testresources.testcontainers.TestContainers;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.MountableFile;

final class TestContainerMetadataSupport {
    static final String TEST_RESOURCES_CONTAINERS = "containers.";
    static final int GENERIC_ORDER = 1000;
    static final int SPECIFIC_ORDER = 0;
    private static final DefaultConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private static final String CLASSPATH_PREFIX = "classpath:";

    private TestContainerMetadataSupport() {
    }

    static Stream<TestContainerMetadata> containerMetadataFor(List<String> containerNames, Map<String, Object> testResourcesConfig) {
        return containerNames.stream().map(name -> TestContainerMetadataSupport.convertToMetadata(testResourcesConfig, name)).filter(Optional::isPresent).map(Optional::get);
    }

    static Optional<TestContainerMetadata> convertToMetadata(Map<String, Object> testResourcesConfig, String name) {
        String prefix = TEST_RESOURCES_CONTAINERS + name + ".";
        String imageName = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "image-name", testResourcesConfig);
        String imageTag = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "image-tag", testResourcesConfig);
        Map<String, Integer> exposedPorts = TestContainerMetadataSupport.extractExposedPortsFrom(prefix, testResourcesConfig);
        Set<String> hostNames = TestContainerMetadataSupport.extractHostsFrom(prefix, testResourcesConfig);
        Map<String, String> rwFsBinds = TestContainerMetadataSupport.extractFsBindsFrom(prefix, testResourcesConfig, false);
        Map<String, String> roFsBinds = TestContainerMetadataSupport.extractFsBindsFrom(prefix, testResourcesConfig, true);
        Map<String, String> env = TestContainerMetadataSupport.extractMapFrom(prefix, "env", testResourcesConfig);
        Map<String, String> labels = TestContainerMetadataSupport.extractMapFrom(prefix, "labels", testResourcesConfig);
        List<String> command = TestContainerMetadataSupport.extractListFrom(prefix, testResourcesConfig, "command");
        String workingDirectory = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "working-directory", testResourcesConfig);
        Duration startupTimeout = CONVERSION_SERVICE.convert((Object)TestContainerMetadataSupport.extractStringParameterFrom(prefix, "startup-timeout", testResourcesConfig), Duration.class).orElse(null);
        List<TestContainerMetadata.CopyFileToContainer> fileCopies = TestContainerMetadataSupport.extractFileCopiesFrom(prefix, testResourcesConfig);
        Long memory = TestContainerMetadataSupport.extractMemoryParameterFrom(prefix, testResourcesConfig, "memory");
        Long swapMemory = TestContainerMetadataSupport.extractMemoryParameterFrom(prefix, testResourcesConfig, "swap-memory");
        Long sharedMemory = TestContainerMetadataSupport.extractMemoryParameterFrom(prefix, testResourcesConfig, "shared-memory");
        String network = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "network", testResourcesConfig);
        Set<String> networkAliases = TestContainerMetadataSupport.extractSetFrom(prefix, testResourcesConfig, "network-aliases");
        return Optional.of(new TestContainerMetadata(name, imageName, imageTag, exposedPorts, hostNames, rwFsBinds, roFsBinds, command, workingDirectory, env, labels, startupTimeout, fileCopies, memory, swapMemory, sharedMemory, network, networkAliases));
    }

    private static Long extractMemoryParameterFrom(String prefix, Map<String, Object> testResourcesConfig, String key) {
        String asString = TestContainerMetadataSupport.extractStringParameterFrom(prefix, key, testResourcesConfig);
        if (asString != null) {
            return MemoryUnitParser.parse(asString);
        }
        return null;
    }

    private static Map<String, Integer> extractExposedPortsFrom(String prefix, Map<String, Object> testResourcesConfiguration) {
        return Optional.ofNullable(testResourcesConfiguration.get(prefix + "exposed-ports")).map(o -> {
            if (o instanceof List) {
                List list = (List)o;
                class MappedPort {
                    final String key;
                    final int value;

                    MappedPort(Object key, Object value) {
                        this.key = String.valueOf(key);
                        this.value = Integer.parseInt(String.valueOf(value));
                    }

                    public String getKey() {
                        return this.key;
                    }

                    public int getValue() {
                        return this.value;
                    }
                }
                return list.stream().flatMap(definition -> {
                    if (definition instanceof Map) {
                        return ((Map)definition).entrySet().stream().map(e -> new MappedPort(e.getKey(), e.getValue()));
                    }
                    return Stream.empty();
                }).collect(Collectors.toMap(MappedPort::getKey, MappedPort::getValue));
            }
            return Collections.emptyMap();
        }).orElse(Collections.emptyMap());
    }

    private static String extractStringParameterFrom(String prefix, String key, Map<String, Object> testResourcesConfiguration) {
        return Optional.ofNullable(testResourcesConfiguration.get(prefix + key)).map(String::valueOf).orElse(null);
    }

    private static Set<String> extractSetFrom(String prefix, Map<String, Object> testResourcesConfiguration, String key) {
        return Optional.ofNullable(testResourcesConfiguration.get(prefix + key)).map(o -> {
            if (o instanceof List) {
                List list = (List)o;
                return list.stream().map(String::valueOf).collect(Collectors.toSet());
            }
            return Collections.singleton(String.valueOf(o));
        }).orElse(Collections.emptySet());
    }

    private static List<String> extractListFrom(String prefix, Map<String, Object> testResourcesConfiguration, String key) {
        return Optional.ofNullable(testResourcesConfiguration.get(prefix + key)).map(o -> {
            if (o instanceof List) {
                List list = (List)o;
                return list.stream().map(String::valueOf).collect(Collectors.toList());
            }
            return Collections.singletonList(String.valueOf(o));
        }).orElse(Collections.emptyList());
    }

    private static Set<String> extractHostsFrom(String prefix, Map<String, Object> testResourcesConfiguration) {
        return TestContainerMetadataSupport.extractSetFrom(prefix, testResourcesConfiguration, "hostnames");
    }

    private static Map<String, String> extractFsBindsFrom(String prefix, Map<String, Object> testResourcesConfiguration, boolean readOnly) {
        return TestContainerMetadataSupport.extractMapFrom(prefix, (readOnly ? "ro-" : "rw-") + "fs-bind", testResourcesConfiguration);
    }

    private static List<TestContainerMetadata.CopyFileToContainer> extractFileCopiesFrom(String prefix, Map<String, Object> testResourcesConfiguration) {
        Map<String, String> copyDefinitions = TestContainerMetadataSupport.extractMapFrom(prefix, "copy-to-container", testResourcesConfiguration);
        return copyDefinitions.entrySet().stream().map(e -> {
            String source = (String)e.getKey();
            String destination = (String)e.getValue();
            if (source.startsWith(CLASSPATH_PREFIX)) {
                String classpath = source.substring(CLASSPATH_PREFIX.length());
                return new TestContainerMetadata.CopyFileToContainer(MountableFile.forClasspathResource((String)classpath), destination);
            }
            return new TestContainerMetadata.CopyFileToContainer(MountableFile.forHostPath((String)source), destination);
        }).collect(Collectors.toList());
    }

    private static Map<String, String> extractMapFrom(String prefix, String key, Map<String, Object> testResourcesConfiguration) {
        return Optional.ofNullable(testResourcesConfiguration.get(prefix + key)).map(o -> {
            if (o instanceof List) {
                List list = (List)o;
                class StringEntry {
                    final String key;
                    final String value;

                    StringEntry(Object key, Object value) {
                        this.key = String.valueOf(key);
                        this.value = String.valueOf(value);
                    }

                    public String getKey() {
                        return this.key;
                    }

                    public String getValue() {
                        return this.value;
                    }
                }
                return list.stream().flatMap(definition -> {
                    if (definition instanceof Map) {
                        return ((Map)definition).entrySet().stream().map(e -> new StringEntry(e.getKey(), e.getValue()));
                    }
                    return Stream.empty();
                }).collect(Collectors.toMap(StringEntry::getKey, StringEntry::getValue));
            }
            return Collections.emptyMap();
        }).orElse(Collections.emptyMap());
    }

    static GenericContainer<?> applyMetadata(TestContainerMetadata md, GenericContainer<?> container) {
        Collection<Integer> exposedPorts = md.getExposedPorts().values();
        if (!exposedPorts.isEmpty()) {
            container.withExposedPorts(exposedPorts.toArray(new Integer[0]));
        }
        md.getRwFsBinds().forEach((hostPath, containerPath) -> TestContainerMetadataSupport.applyFsBind(container, hostPath, containerPath, BindMode.READ_WRITE));
        md.getRoFsBinds().forEach((hostPath, containerPath) -> TestContainerMetadataSupport.applyFsBind(container, hostPath, containerPath, BindMode.READ_ONLY));
        if (!md.getCommand().isEmpty()) {
            container.withCommand(md.getCommand().toArray(new String[0]));
        }
        container.withEnv(md.getEnv());
        container.withLabels(md.getLabels());
        md.getStartupTimeout().ifPresent(arg_0 -> container.withStartupTimeout(arg_0));
        md.getFileCopies().forEach(copy -> container.withCopyFileToContainer(copy.getFile(), copy.getDestination()));
        md.getSharedMemory().ifPresent(arg_0 -> container.withSharedMemorySize(arg_0));
        md.getMemory().ifPresent(memory -> container.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemory(memory)));
        md.getSwapMemory().ifPresent(memory -> container.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemorySwap(memory)));
        md.getNetwork().ifPresent(network -> container.withNetwork(TestContainers.network(network)));
        if (!md.getNetworkAliases().isEmpty()) {
            container.withNetworkAliases(md.getNetworkAliases().toArray(new String[0]));
        }
        return container;
    }

    static void applyFsBind(GenericContainer<?> container, String hostPath, String containerPath, BindMode bindMode) {
        if (hostPath.startsWith(CLASSPATH_PREFIX)) {
            container.withClasspathResourceMapping(hostPath.substring(CLASSPATH_PREFIX.length()), containerPath, bindMode);
        } else {
            container.withFileSystemBind(hostPath, containerPath, bindMode);
        }
    }

    static {
        TimeConverterRegistrar registrar = new TimeConverterRegistrar();
        registrar.register((ConversionService)CONVERSION_SERVICE);
    }
}

