/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.testcontainers;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

final class TestContainerMetadata {
    private final String id;
    private final String imageName;
    private final String imageTag;
    private final Map<String, Integer> exposedPorts;
    private final Set<String> hostNames;
    private final Map<String, String> rwFsBinds;
    private final Map<String, String> roFsBinds;
    private final Set<String> rwTmpfsMappings;
    private final Set<String> roTmpfsMappings;
    private final List<String> command;
    private final String workingDirectory;
    private final Map<String, String> env;
    private final Map<String, String> labels;
    private final Duration startupTimeout;
    private final List<CopyFileToContainer> fileCopies;
    private final Long memory;
    private final Long swapMemory;
    private final Long sharedMemory;
    private final String network;
    private final Set<String> networkAliases;
    private final WaitStrategy waitStrategy;

    TestContainerMetadata(String id, String imageName, String imageTag, Map<String, Integer> exposedPorts, Set<String> hostNames, Map<String, String> rwFsBinds, Map<String, String> roFsBinds, Set<String> rwTmpfsMappings, Set<String> roTmpfsMappings, List<String> command, String workingDirectory, Map<String, String> env, Map<String, String> labels, Duration startupTimeout, List<CopyFileToContainer> fileCopies, Long memory, Long swapMemory, Long sharedMemory, String network, Set<String> networkAliases, WaitStrategy waitStrategy) {
        this.id = id;
        this.imageName = imageName;
        this.imageTag = imageTag;
        this.exposedPorts = exposedPorts;
        this.hostNames = hostNames;
        this.rwFsBinds = rwFsBinds;
        this.roFsBinds = roFsBinds;
        this.rwTmpfsMappings = rwTmpfsMappings;
        this.roTmpfsMappings = roTmpfsMappings;
        this.command = command;
        this.workingDirectory = workingDirectory;
        this.env = env;
        this.labels = labels;
        this.startupTimeout = startupTimeout;
        this.fileCopies = fileCopies;
        this.memory = memory;
        this.swapMemory = swapMemory;
        this.sharedMemory = sharedMemory;
        this.network = network;
        this.networkAliases = networkAliases;
        this.waitStrategy = waitStrategy;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getImageName() {
        return Optional.ofNullable(this.imageName);
    }

    public Optional<String> getImageTag() {
        return Optional.ofNullable(this.imageTag);
    }

    public Map<String, Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    public Set<String> getHostNames() {
        return this.hostNames;
    }

    public Map<String, String> getRwFsBinds() {
        return this.rwFsBinds;
    }

    public Map<String, String> getRoFsBinds() {
        return this.roFsBinds;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public Optional<String> getWorkingDirectory() {
        return Optional.ofNullable(this.workingDirectory);
    }

    public Optional<Duration> getStartupTimeout() {
        return Optional.ofNullable(this.startupTimeout);
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public List<CopyFileToContainer> getFileCopies() {
        return this.fileCopies;
    }

    public Optional<Long> getMemory() {
        return Optional.ofNullable(this.memory);
    }

    public Optional<Long> getSwapMemory() {
        return Optional.ofNullable(this.swapMemory);
    }

    public Optional<Long> getSharedMemory() {
        return Optional.ofNullable(this.sharedMemory);
    }

    public Optional<String> getNetwork() {
        return Optional.ofNullable(this.network);
    }

    public Set<String> getNetworkAliases() {
        return this.networkAliases;
    }

    public Optional<WaitStrategy> getWaitStrategy() {
        return Optional.ofNullable(this.waitStrategy);
    }

    public Set<String> getRwTmpfsMappings() {
        return this.rwTmpfsMappings;
    }

    public Set<String> getRoTmpfsMappings() {
        return this.roTmpfsMappings;
    }

    public static final class CopyFileToContainer {
        private final MountableFile file;
        private final String destination;

        public CopyFileToContainer(MountableFile file, String destination) {
            this.file = file;
            this.destination = destination;
        }

        public MountableFile getFile() {
            return this.file;
        }

        public String getDestination() {
            return this.destination;
        }
    }
}

