/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.testcontainers;

import io.micronaut.testresources.core.ToggableTestResourcesResolver;
import io.micronaut.testresources.testcontainers.TestContainerMetadata;
import io.micronaut.testresources.testcontainers.TestContainerMetadataSupport;
import io.micronaut.testresources.testcontainers.TestContainers;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public abstract class AbstractTestContainersProvider<T extends GenericContainer<? extends T>>
implements ToggableTestResourcesResolver {
    public String getName() {
        return "containers." + this.getSimpleName();
    }

    public int getOrder() {
        return 0;
    }

    protected abstract String getSimpleName();

    protected abstract String getDefaultImageName();

    protected abstract T createContainer(DockerImageName var1, Map<String, Object> var2, Map<String, Object> var3);

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return true;
    }

    protected Optional<String> resolveWithoutContainer(String propertyName, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        return Optional.empty();
    }

    public final Optional<String> resolve(String propertyName, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        if (this.shouldAnswer(propertyName, properties, testResourcesConfig)) {
            Optional<String> firstPass = this.resolveWithoutContainer(propertyName, properties, testResourcesConfig);
            if (firstPass.isPresent()) {
                return firstPass;
            }
            return this.resolveProperty(propertyName, TestContainers.getOrCreate(propertyName, this.getClass(), this.getSimpleName(), properties, () -> {
                String defaultImageName = this.getDefaultImageName();
                DockerImageName imageName = DockerImageName.parse((String)defaultImageName);
                Optional<TestContainerMetadata> metadata = TestContainerMetadataSupport.containerMetadataFor(Collections.singletonList(this.getSimpleName()), testResourcesConfig).findAny();
                if (metadata.isPresent()) {
                    TestContainerMetadata md = metadata.get();
                    if (md.getImageName().isPresent()) {
                        imageName = DockerImageName.parse((String)md.getImageName().get()).asCompatibleSubstituteFor(defaultImageName);
                    }
                    if (md.getImageTag().isPresent()) {
                        imageName = imageName.withTag(md.getImageTag().get());
                    }
                }
                return imageName;
            }, imageName -> {
                Optional<TestContainerMetadata> metadata = TestContainerMetadataSupport.containerMetadataFor(Collections.singletonList(this.getSimpleName()), testResourcesConfig).findAny();
                Object container = this.createContainer((DockerImageName)imageName, properties, testResourcesConfig);
                this.configureContainer(container, properties, testResourcesConfig);
                metadata.ifPresent(md -> TestContainerMetadataSupport.applyMetadata(md, container));
                return container;
            }));
        }
        return Optional.empty();
    }

    protected void configureContainer(T container, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
    }

    protected abstract Optional<String> resolveProperty(String var1, T var2);

    protected final String stringOrNull(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

