/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.testcontainers;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MemoryUnitParser {
    private static final Pattern MEMORY_UNIT_PATTERN = Pattern.compile("^(\\d+(?:[.]\\d+)?)\\s*([kmg])?(b?)$");

    private MemoryUnitParser() {
    }

    static Long parse(String memory) {
        Matcher m = MEMORY_UNIT_PATTERN.matcher(memory.trim().toLowerCase(Locale.ROOT));
        if (m.find()) {
            double value = Double.parseDouble(m.group(1));
            String unit = m.group(2);
            if ("k".equals(unit)) {
                return (long)(value * 1024.0);
            }
            if ("m".equals(unit)) {
                return (long)(1048576.0 * value);
            }
            if ("g".equals(unit)) {
                return (long)(1.073741824E9 * value);
            }
            return (long)value;
        }
        return null;
    }
}

