/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.testcontainers;

import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.runtime.converters.time.TimeConverterRegistrar;
import io.micronaut.testresources.testcontainers.MemoryUnitParser;
import io.micronaut.testresources.testcontainers.TestContainerMetadata;
import io.micronaut.testresources.testcontainers.TestContainers;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

final class TestContainerMetadataSupport {
    static final String TEST_RESOURCES_CONTAINERS = "containers.";
    static final int GENERIC_ORDER = 1000;
    static final int SPECIFIC_ORDER = 0;
    private static final ConversionService CONVERSION_SERVICE;
    private static final String CLASSPATH_PREFIX = "classpath:";

    private TestContainerMetadataSupport() {
    }

    static Stream<TestContainerMetadata> containerMetadataFor(List<String> containerNames, Map<String, Object> testResourcesConfig) {
        return containerNames.stream().map(name -> TestContainerMetadataSupport.convertToMetadata(testResourcesConfig, name)).filter(Optional::isPresent).map(Optional::get);
    }

    static Optional<TestContainerMetadata> convertToMetadata(Map<String, Object> testResourcesConfig, String name) {
        String prefix = TEST_RESOURCES_CONTAINERS + name + ".";
        String imageName = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "image-name", testResourcesConfig);
        String imageTag = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "image-tag", testResourcesConfig);
        Map<String, Integer> exposedPorts = TestContainerMetadataSupport.extractExposedPortsFrom(prefix, testResourcesConfig);
        Set<String> hostNames = TestContainerMetadataSupport.extractHostsFrom(prefix, testResourcesConfig);
        Map<String, String> rwFsBinds = TestContainerMetadataSupport.extractFsBindsFrom(prefix, testResourcesConfig, false);
        Map<String, String> roFsBinds = TestContainerMetadataSupport.extractFsBindsFrom(prefix, testResourcesConfig, true);
        Set<String> rwTmpfsMappings = TestContainerMetadataSupport.extractTmpfsMappingsFrom(prefix, testResourcesConfig, false);
        Set<String> roTmpfsMappings = TestContainerMetadataSupport.extractTmpfsMappingsFrom(prefix, testResourcesConfig, true);
        Map<String, String> env = TestContainerMetadataSupport.extractMapFrom(prefix, "env", testResourcesConfig);
        Map<String, String> labels = TestContainerMetadataSupport.extractMapFrom(prefix, "labels", testResourcesConfig);
        List<String> command = TestContainerMetadataSupport.extractListFrom(prefix, testResourcesConfig, "command");
        String workingDirectory = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "working-directory", testResourcesConfig);
        Duration startupTimeout = CONVERSION_SERVICE.convert((Object)TestContainerMetadataSupport.extractStringParameterFrom(prefix, "startup-timeout", testResourcesConfig), Duration.class).orElse(null);
        List<TestContainerMetadata.CopyFileToContainer> fileCopies = TestContainerMetadataSupport.extractFileCopiesFrom(prefix, testResourcesConfig);
        Long memory = TestContainerMetadataSupport.extractMemoryParameterFrom(prefix, testResourcesConfig, "memory");
        Long swapMemory = TestContainerMetadataSupport.extractMemoryParameterFrom(prefix, testResourcesConfig, "swap-memory");
        Long sharedMemory = TestContainerMetadataSupport.extractMemoryParameterFrom(prefix, testResourcesConfig, "shared-memory");
        String network = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "network", testResourcesConfig);
        Set<String> networkAliases = TestContainerMetadataSupport.extractSetFrom(prefix, testResourcesConfig, "network-aliases");
        String networkMode = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "network-mode", testResourcesConfig);
        Set<String> dependsOn = TestContainerMetadataSupport.extractSetFrom(prefix, testResourcesConfig, "depends-on");
        WaitStrategy waitStrategy = TestContainerMetadataSupport.extractWaitStrategyFrom(prefix, testResourcesConfig);
        return Optional.of(new TestContainerMetadata(name, imageName, imageTag, exposedPorts, hostNames, rwFsBinds, roFsBinds, rwTmpfsMappings, roTmpfsMappings, command, workingDirectory, env, labels, startupTimeout, fileCopies, memory, swapMemory, sharedMemory, network, networkAliases, networkMode, waitStrategy, dependsOn));
    }

    private static Long extractMemoryParameterFrom(String prefix, Map<String, Object> testResourcesConfig, String key) {
        String asString = TestContainerMetadataSupport.extractStringParameterFrom(prefix, key, testResourcesConfig);
        if (asString != null) {
            return MemoryUnitParser.parse(asString);
        }
        return null;
    }

    private static Map<String, Integer> extractExposedPortsFrom(String prefix, Map<String, Object> testResourcesConfig) {
        return Optional.ofNullable(testResourcesConfig.get(prefix + "exposed-ports")).map(o -> {
            if (o instanceof List) {
                List list = (List)o;
                class MappedPort {
                    final String key;
                    final int value;

                    MappedPort(Object key, Object value) {
                        this.key = String.valueOf(key);
                        this.value = Integer.parseInt(String.valueOf(value));
                    }

                    public String getKey() {
                        return this.key;
                    }

                    public int getValue() {
                        return this.value;
                    }
                }
                return list.stream().flatMap(definition -> {
                    if (definition instanceof Map) {
                        return ((Map)definition).entrySet().stream().map(e -> new MappedPort(e.getKey(), e.getValue()));
                    }
                    return Stream.empty();
                }).collect(Collectors.toMap(MappedPort::getKey, MappedPort::getValue));
            }
            return Collections.emptyMap();
        }).orElse(Collections.emptyMap());
    }

    private static String extractStringParameterFrom(String prefix, String key, Map<String, Object> testResourcesConfig) {
        return Optional.ofNullable(testResourcesConfig.get(prefix + key)).map(String::valueOf).orElse(null);
    }

    private static Integer extractIntParameterFrom(String prefix, String key, Map<String, Object> testResourcesConfig) {
        return Optional.ofNullable(testResourcesConfig.get(prefix + key)).map(Integer.class::cast).orElse(null);
    }

    private static Set<String> extractSetFrom(String prefix, Map<String, Object> testResourcesConfig, String key) {
        return Optional.ofNullable(testResourcesConfig.get(prefix + key)).map(o -> {
            if (o instanceof List) {
                List list = (List)o;
                return list.stream().map(String::valueOf).collect(Collectors.toSet());
            }
            return Collections.singleton(String.valueOf(o));
        }).orElse(Collections.emptySet());
    }

    private static List<String> extractListFrom(String prefix, Map<String, Object> testResourcesConfig, String key) {
        return Optional.ofNullable(testResourcesConfig.get(prefix + key)).map(o -> {
            if (o instanceof List) {
                List list = (List)o;
                return list.stream().map(String::valueOf).collect(Collectors.toList());
            }
            return Collections.singletonList(String.valueOf(o));
        }).orElse(Collections.emptyList());
    }

    private static Set<String> extractHostsFrom(String prefix, Map<String, Object> testResourcesConfig) {
        return TestContainerMetadataSupport.extractSetFrom(prefix, testResourcesConfig, "hostnames");
    }

    private static Set<String> extractTmpfsMappingsFrom(String prefix, Map<String, Object> testResourcesConfig, boolean readOnly) {
        return TestContainerMetadataSupport.extractSetFrom(prefix, testResourcesConfig, (readOnly ? "ro-" : "rw-") + "tmpfs-mappings");
    }

    private static Map<String, String> extractFsBindsFrom(String prefix, Map<String, Object> testResourcesConfig, boolean readOnly) {
        return TestContainerMetadataSupport.extractMapFrom(prefix, (readOnly ? "ro-" : "rw-") + "fs-bind", testResourcesConfig);
    }

    private static List<TestContainerMetadata.CopyFileToContainer> extractFileCopiesFrom(String prefix, Map<String, Object> testResourcesConfig) {
        Map<String, String> copyDefinitions = TestContainerMetadataSupport.extractMapFrom(prefix, "copy-to-container", testResourcesConfig);
        return copyDefinitions.entrySet().stream().map(e -> {
            String source = (String)e.getKey();
            String destination = (String)e.getValue();
            if (source.startsWith(CLASSPATH_PREFIX)) {
                String classpath = source.substring(CLASSPATH_PREFIX.length());
                return new TestContainerMetadata.CopyFileToContainer(MountableFile.forClasspathResource((String)classpath), destination);
            }
            return new TestContainerMetadata.CopyFileToContainer(MountableFile.forHostPath((String)source), destination);
        }).collect(Collectors.toList());
    }

    private static Map<String, String> extractMapFrom(String prefix, String key, Map<String, Object> testResourcesConfig) {
        return Optional.ofNullable(testResourcesConfig.get(prefix + key)).map(o -> {
            if (o instanceof List) {
                List list = (List)o;
                class StringEntry {
                    final String key;
                    final String value;

                    StringEntry(Object key, Object value) {
                        this.key = String.valueOf(key);
                        this.value = String.valueOf(value);
                    }

                    public String getKey() {
                        return this.key;
                    }

                    public String getValue() {
                        return this.value;
                    }
                }
                return list.stream().flatMap(definition -> {
                    if (definition instanceof Map) {
                        return ((Map)definition).entrySet().stream().map(e -> new StringEntry(e.getKey(), e.getValue()));
                    }
                    return Stream.empty();
                }).collect(Collectors.toMap(StringEntry::getKey, StringEntry::getValue));
            }
            return Collections.emptyMap();
        }).orElse(Collections.emptyMap());
    }

    private static WaitStrategy extractWaitStrategyFrom(String prefix, Map<String, Object> testResourcesConfig) {
        String waitStrategyPrefix = prefix + "wait-strategy.";
        ArrayList<WaitStrategy> strategies = new ArrayList<WaitStrategy>();
        Set strategyIds = testResourcesConfig.keySet().stream().map(k -> TestContainerMetadataSupport.determineWaitStrategyIdFor(prefix, testResourcesConfig, waitStrategyPrefix, k)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        Iterator iterator = strategyIds.iterator();
        block14: while (iterator.hasNext()) {
            String strategyId;
            switch (strategyId = (String)iterator.next()) {
                case "log": {
                    strategies.add((WaitStrategy)TestContainerMetadataSupport.parseLogStrategy(waitStrategyPrefix + "log.", testResourcesConfig));
                    continue block14;
                }
                case "http": {
                    strategies.add((WaitStrategy)TestContainerMetadataSupport.parseHttpStrategy(waitStrategyPrefix + "http.", testResourcesConfig));
                    continue block14;
                }
                case "port": {
                    TestContainerMetadataSupport.assertAllowedKeys(prefix + ".port", testResourcesConfig, new String[0]);
                    strategies.add((WaitStrategy)Wait.forListeningPort());
                    continue block14;
                }
                case "healthcheck": {
                    TestContainerMetadataSupport.assertAllowedKeys(prefix + ".healthcheck", testResourcesConfig, new String[0]);
                    strategies.add((WaitStrategy)Wait.forHealthcheck());
                    continue block14;
                }
                case "all": {
                    strategies.add(TestContainerMetadataSupport.parseAllStrategy(waitStrategyPrefix + "all.", testResourcesConfig));
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Unknown wait strategy: " + strategyId);
        }
        if (strategies.size() == 1) {
            return (WaitStrategy)strategies.get(0);
        }
        if (strategies.size() > 1) {
            return TestContainerMetadataSupport.buildWaitAllStrategy(strategies);
        }
        return null;
    }

    private static WaitAllStrategy buildWaitAllStrategy(List<WaitStrategy> strategies) {
        WaitAllStrategy waitAllStrategy = strategies.stream().filter(WaitAllStrategy.class::isInstance).map(WaitAllStrategy.class::cast).findFirst().orElse(new WaitAllStrategy());
        for (WaitStrategy strategy : strategies) {
            if (strategy instanceof WaitAllStrategy) continue;
            waitAllStrategy = waitAllStrategy.withStrategy(strategy);
        }
        return waitAllStrategy;
    }

    private static WaitStrategy parseAllStrategy(String prefix, Map<String, Object> testResourcesConfig) {
        TestContainerMetadataSupport.assertAllowedKeys(prefix, testResourcesConfig, "mode", "timeout");
        String modeStr = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "mode", testResourcesConfig);
        WaitAllStrategy.Mode mode = WaitAllStrategy.Mode.WITH_OUTER_TIMEOUT;
        if (modeStr != null) {
            mode = WaitAllStrategy.Mode.valueOf((String)modeStr.toUpperCase(Locale.US));
        }
        WaitAllStrategy waitAllStrategy = new WaitAllStrategy(mode);
        String timeoutStr = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "timeout", testResourcesConfig);
        if (timeoutStr != null) {
            Duration startupTimeout = CONVERSION_SERVICE.convert((Object)timeoutStr, Duration.class).orElse(null);
            waitAllStrategy = waitAllStrategy.withStartupTimeout(startupTimeout);
        }
        return waitAllStrategy;
    }

    @Nullable
    private static String determineWaitStrategyIdFor(String prefix, Map<String, Object> testResourcesConfig, String waitStrategyPrefix, String k) {
        String simpleWaitStrategyPrefix = prefix + "wait-strategy";
        if (k.equals(simpleWaitStrategyPrefix)) {
            return String.valueOf(testResourcesConfig.get(simpleWaitStrategyPrefix));
        }
        if (k.startsWith(waitStrategyPrefix)) {
            if ((k = k.substring(waitStrategyPrefix.length())).contains(".")) {
                return k.substring(0, k.indexOf("."));
            }
            return k;
        }
        return null;
    }

    private static HttpWaitStrategy parseHttpStrategy(String prefix, Map<String, Object> testResourcesConfig) {
        TestContainerMetadataSupport.assertAllowedKeys(prefix, testResourcesConfig, "path", "port", "tls", "status-code");
        String path = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "path", testResourcesConfig);
        Integer port = TestContainerMetadataSupport.extractIntParameterFrom(prefix, "port", testResourcesConfig);
        String tls = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "tls", testResourcesConfig);
        List<String> statusCode = TestContainerMetadataSupport.extractListFrom(prefix, testResourcesConfig, "status-code");
        HttpWaitStrategy httpWaitStrategy = new HttpWaitStrategy().forPath(path);
        if (port != null) {
            httpWaitStrategy = httpWaitStrategy.forPort(port.intValue());
        }
        if (tls != null && Boolean.TRUE.equals(Boolean.parseBoolean(tls))) {
            httpWaitStrategy = httpWaitStrategy.usingTls();
        }
        if (!statusCode.isEmpty()) {
            for (String status : statusCode) {
                httpWaitStrategy = httpWaitStrategy.forStatusCode(Integer.parseInt(status));
            }
        }
        return httpWaitStrategy;
    }

    private static LogMessageWaitStrategy parseLogStrategy(String prefix, Map<String, Object> testResourcesConfig) {
        TestContainerMetadataSupport.assertAllowedKeys(prefix, testResourcesConfig, "regex", "times");
        String regex = TestContainerMetadataSupport.extractStringParameterFrom(prefix, "regex", testResourcesConfig);
        Integer times = TestContainerMetadataSupport.extractIntParameterFrom(prefix, "times", testResourcesConfig);
        return Wait.forLogMessage((String)regex, (int)(times != null ? times : 1));
    }

    private static void assertAllowedKeys(String prefix, Map<String, Object> testResourcesConfig, String ... allowed) {
        LinkedHashSet<String> allowedKeys = new LinkedHashSet<String>(Arrays.asList(allowed));
        List disallowed = testResourcesConfig.keySet().stream().filter(k -> k.startsWith(prefix)).map(k -> k.substring(prefix.length())).map(k -> {
            if (k.contains(".")) {
                return k.substring(0, k.indexOf("."));
            }
            return k;
        }).filter(k -> !allowedKeys.contains(k)).collect(Collectors.toList());
        if (!disallowed.isEmpty()) {
            if (allowed.length == 0) {
                throw new IllegalArgumentException("Wait strategy " + prefix + " is not configurable but the following keys are set: " + disallowed);
            }
            if (disallowed.size() == 1) {
                throw new IllegalArgumentException("Wait strategy " + prefix + " does not support the following key: " + (String)disallowed.get(0) + ". Allowed keys are: " + allowedKeys);
            }
            throw new IllegalArgumentException("Wait strategy " + prefix + " does not support the following keys: " + disallowed + ". Allowed keys are: " + allowedKeys);
        }
    }

    static GenericContainer<?> applyMetadata(TestContainerMetadata md, GenericContainer<?> container) {
        Collection<Integer> exposedPorts = md.getExposedPorts().values();
        if (!exposedPorts.isEmpty()) {
            container.withExposedPorts(exposedPorts.toArray(new Integer[0]));
        }
        md.getRwFsBinds().forEach((hostPath, containerPath) -> TestContainerMetadataSupport.applyFsBind(container, hostPath, containerPath, BindMode.READ_WRITE));
        md.getRoFsBinds().forEach((hostPath, containerPath) -> TestContainerMetadataSupport.applyFsBind(container, hostPath, containerPath, BindMode.READ_ONLY));
        md.getRwTmpfsMappings().forEach(mapping -> TestContainerMetadataSupport.applyTmpFsMapping(container, mapping, BindMode.READ_WRITE));
        md.getRoTmpfsMappings().forEach(mapping -> TestContainerMetadataSupport.applyTmpFsMapping(container, mapping, BindMode.READ_ONLY));
        if (!md.getCommand().isEmpty()) {
            container.withCommand(md.getCommand().toArray(new String[0]));
        }
        container.withEnv(md.getEnv());
        container.withLabels(md.getLabels());
        md.getStartupTimeout().ifPresent(arg_0 -> container.withStartupTimeout(arg_0));
        md.getFileCopies().forEach(copy -> container.withCopyFileToContainer(copy.getFile(), copy.getDestination()));
        md.getSharedMemory().ifPresent(arg_0 -> container.withSharedMemorySize(arg_0));
        md.getMemory().ifPresent(memory -> container.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemory(memory)));
        md.getSwapMemory().ifPresent(memory -> container.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemorySwap(memory)));
        md.getNetwork().ifPresent(network -> container.withNetwork(TestContainers.network(network)));
        if (!md.getNetworkAliases().isEmpty()) {
            container.withNetworkAliases(md.getNetworkAliases().toArray(new String[0]));
        }
        md.getNetworkMode().ifPresent(arg_0 -> container.withNetworkMode(arg_0));
        md.getWaitStrategy().ifPresent(arg_0 -> container.setWaitStrategy(arg_0));
        return container;
    }

    static void applyFsBind(GenericContainer<?> container, String hostPath, String containerPath, BindMode bindMode) {
        if (hostPath.startsWith(CLASSPATH_PREFIX)) {
            container.withClasspathResourceMapping(hostPath.substring(CLASSPATH_PREFIX.length()), containerPath, bindMode);
        } else {
            container.withFileSystemBind(hostPath, containerPath, bindMode);
        }
    }

    static void applyTmpFsMapping(GenericContainer<?> container, String mapping, BindMode bindMode) {
        container.withTmpFs(Collections.singletonMap(mapping, bindMode.accessMode.name()));
    }

    static {
        DefaultMutableConversionService mcs = new DefaultMutableConversionService();
        TimeConverterRegistrar registrar = new TimeConverterRegistrar();
        registrar.register((MutableConversionService)mcs);
        CONVERSION_SERVICE = mcs;
    }
}

