/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.testcontainers;

import io.micronaut.core.annotation.Internal;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

@Internal
public final class DockerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerSupport.class);
    private static final int TIMEOUT = Integer.getInteger("docker.check.timeout.seconds", 10);
    private static final Lock LOCK = new ReentrantLock();
    private static final AtomicReference<Boolean> AVAILABLE = new AtomicReference();

    private DockerSupport() {
    }

    private static boolean performDockerCheck() {
        boolean available;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Boolean> future = executor.submit(() -> DockerClientFactory.instance().isDockerAvailable());
            available = future.get(TIMEOUT, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            available = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            available = false;
        }
        finally {
            executor.shutdown();
        }
        if (!available) {
            LOGGER.error("Docker support doesn't seem to be available, test resources will not work correctly. Please check your Docker install.");
        }
        return available;
    }

    public static boolean isDockerAvailable() {
        Boolean available = AVAILABLE.get();
        if (available != null) {
            return available;
        }
        LOCK.lock();
        try {
            available = AVAILABLE.get();
            if (Boolean.TRUE.equals(available)) {
                boolean bl = available;
                return bl;
            }
            available = DockerSupport.performDockerCheck();
            AVAILABLE.set(available);
            boolean bl = available;
            return bl;
        }
        finally {
            LOCK.unlock();
        }
    }
}

