/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.toml;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.toml.Lexer;
import io.micronaut.toml.TomlStreamReadException;
import io.micronaut.toml.TomlToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public final class Parser {
    private final TomlStreamReadException.ErrorContext errorContext;
    private final Lexer lexer;
    private TomlToken next;

    private Parser(TomlStreamReadException.ErrorContext errorContext, Reader input) throws IOException {
        this.errorContext = errorContext;
        this.lexer = new Lexer(input, errorContext);
        this.lexer.prohibitInternalBufferAllocate = false;
        this.next = this.lexer.yylex();
    }

    public static JsonNode parse(String input) throws IOException {
        Parser parser = new Parser(new TomlStreamReadException.ErrorContext(input), new StringReader(input));
        return parser.parse();
    }

    private TomlToken peek() throws TomlStreamReadException {
        TomlToken here = this.next;
        if (here == null) {
            throw this.errorContext.atPosition(this.lexer).generic("Premature end of file");
        }
        return here;
    }

    private TomlToken poll(int nextState) throws IOException {
        TomlToken here = this.peek();
        this.lexer.yybegin(nextState);
        this.next = this.lexer.yylex();
        return here;
    }

    private void pollExpected(TomlToken expected, int nextState) throws IOException {
        TomlToken actual = this.poll(nextState);
        if (actual != expected) {
            throw this.errorContext.atPosition(this.lexer).unexpectedToken(actual, expected.toString());
        }
    }

    public JsonNode parse() throws IOException {
        TomlObjectBuilder root;
        TomlObjectBuilder currentTable = root = new TomlObjectBuilder();
        while (this.next != null) {
            FieldRef fieldRef;
            TomlToken token = this.peek();
            if (token == TomlToken.UNQUOTED_KEY || token == TomlToken.STRING) {
                this.parseKeyVal(currentTable, 8);
                continue;
            }
            if (token == TomlToken.STD_TABLE_OPEN) {
                this.pollExpected(TomlToken.STD_TABLE_OPEN, 4);
                fieldRef = this.parseAndEnterKey(root, true);
                currentTable = this.getOrCreateObject(fieldRef.object, fieldRef.key);
                if (currentTable.defined) {
                    throw this.errorContext.atPosition(this.lexer).generic("Table redefined");
                }
                currentTable.defined = true;
                this.pollExpected(TomlToken.STD_TABLE_CLOSE, 8);
                continue;
            }
            if (token == TomlToken.ARRAY_TABLE_OPEN) {
                this.pollExpected(TomlToken.ARRAY_TABLE_OPEN, 4);
                fieldRef = this.parseAndEnterKey(root, true);
                TomlArrayBuilder array = this.getOrCreateArray(fieldRef.object, fieldRef.key);
                if (array.closed) {
                    throw this.errorContext.atPosition(this.lexer).generic("Array already finished");
                }
                currentTable = array.addObject();
                this.pollExpected(TomlToken.ARRAY_TABLE_CLOSE, 8);
                continue;
            }
            throw this.errorContext.atPosition(this.lexer).unexpectedToken(token, "key or table");
        }
        int eofState = this.lexer.yystate();
        if (eofState != 2 && eofState != 8) {
            throw this.errorContext.atPosition(this.lexer).generic("EOF in wrong state");
        }
        return root.build();
    }

    private FieldRef parseAndEnterKey(TomlObjectBuilder outer, boolean forTable) throws IOException {
        TomlNodeBuilder existing;
        TomlObjectBuilder node = outer;
        while (true) {
            String part;
            TomlToken partToken;
            if (node.closed) {
                throw this.errorContext.atPosition(this.lexer).generic("Object already closed");
            }
            if (!forTable) {
                node.defined = true;
            }
            if ((partToken = this.peek()) == TomlToken.STRING) {
                part = this.lexer.textBuffer.toString();
            } else if (partToken == TomlToken.UNQUOTED_KEY) {
                part = this.lexer.yytext();
            } else {
                throw this.errorContext.atPosition(this.lexer).unexpectedToken(partToken, "quoted or unquoted key");
            }
            this.pollExpected(partToken, 4);
            if (this.peek() != TomlToken.DOT_SEP) {
                return new FieldRef(node, part);
            }
            this.pollExpected(TomlToken.DOT_SEP, 4);
            existing = node.get(part);
            if (existing == null) {
                node = node.putObject(part);
                continue;
            }
            if (existing instanceof TomlObjectBuilder) {
                node = (TomlObjectBuilder)existing;
                continue;
            }
            if (!(existing instanceof TomlArrayBuilder)) break;
            TomlArrayBuilder array = (TomlArrayBuilder)existing;
            if (array.closed) {
                throw this.errorContext.atPosition(this.lexer).generic("Array already closed");
            }
            node = (TomlObjectBuilder)array.get(array.size() - 1);
        }
        throw this.errorContext.atPosition(this.lexer).generic("Path into existing non-object value of type " + existing.getNodeType());
    }

    private TomlNodeBuilder parseValue(int nextState) throws IOException {
        TomlToken firstToken = this.peek();
        switch (firstToken) {
            case STRING: {
                String text = this.lexer.textBuffer.toString();
                this.pollExpected(TomlToken.STRING, nextState);
                return new Scalar(JsonNode.createStringNode((String)text));
            }
            case TRUE: {
                this.pollExpected(TomlToken.TRUE, nextState);
                return new Scalar(JsonNode.createBooleanNode((boolean)true));
            }
            case FALSE: {
                this.pollExpected(TomlToken.FALSE, nextState);
                return new Scalar(JsonNode.createBooleanNode((boolean)false));
            }
            case OFFSET_DATE_TIME: 
            case LOCAL_DATE_TIME: 
            case LOCAL_DATE: 
            case LOCAL_TIME: {
                return new Scalar(this.parseDateTime(nextState));
            }
            case FLOAT: {
                return new Scalar(this.parseFloat(nextState));
            }
            case INTEGER: {
                return new Scalar(this.parseInt(nextState));
            }
            case ARRAY_OPEN: {
                return this.parseArray(nextState);
            }
            case INLINE_TABLE_OPEN: {
                return this.parseInlineTable(nextState);
            }
        }
        throw this.errorContext.atPosition(this.lexer).unexpectedToken(firstToken, "value");
    }

    private JsonNode parseDateTime(int nextState) throws IOException {
        Object text = this.lexer.yytext();
        TomlToken token = this.poll(nextState);
        if ((token == TomlToken.LOCAL_DATE_TIME || token == TomlToken.OFFSET_DATE_TIME) && ((String)text).charAt(10) == ' ') {
            text = ((String)text).substring(0, 10) + "T" + ((String)text).substring(11);
        }
        return JsonNode.createStringNode((String)text);
    }

    private JsonNode parseInt(int nextState) throws IOException {
        char[] buffer = this.lexer.getTextBuffer();
        int start = this.lexer.getTextBufferStart();
        int length = this.lexer.getTextBufferEnd() - this.lexer.getTextBufferStart();
        for (int i = 0; i < length; ++i) {
            if (buffer[start + i] != '_') continue;
            buffer = new String(buffer, start, length).replace("_", "").toCharArray();
            start = 0;
            length = buffer.length;
            break;
        }
        JsonNode v = this.parseInt0(buffer, start, length);
        this.pollExpected(TomlToken.INTEGER, nextState);
        return v;
    }

    private JsonNode parseInt0(char[] buffer, int start, int length) throws TomlStreamReadException {
        boolean negative;
        char baseChar;
        if (length > 2 && ((baseChar = buffer[start + 1]) == 'x' || baseChar == 'o' || baseChar == 'b')) {
            String text = new String(buffer, start += 2, length -= 2);
            try {
                if (baseChar == 'x') {
                    if (length <= 7) {
                        return JsonNode.createNumberNode((int)Integer.parseInt(text, 16));
                    }
                    if (length <= 15) {
                        return JsonNode.createNumberNode((long)Long.parseLong(text, 16));
                    }
                    return JsonNode.createNumberNode((BigInteger)new BigInteger(text, 16));
                }
                if (baseChar == 'o') {
                    if (length <= 10) {
                        return JsonNode.createNumberNode((int)Integer.parseInt(text, 8));
                    }
                    if (text.length() <= 21) {
                        return JsonNode.createNumberNode((long)Long.parseLong(text, 8));
                    }
                    return JsonNode.createNumberNode((BigInteger)new BigInteger(text, 8));
                }
                assert (baseChar == 'b');
                if (length <= 31) {
                    return JsonNode.createNumberNode((int)Integer.parseUnsignedInt(text, 2));
                }
                if (length <= 63) {
                    return JsonNode.createNumberNode((long)Long.parseUnsignedLong(text, 2));
                }
                return JsonNode.createNumberNode((BigInteger)new BigInteger(text, 2));
            }
            catch (NumberFormatException e) {
                throw this.errorContext.atPosition(this.lexer).invalidNumber(e);
            }
        }
        if (buffer[start] == '-') {
            ++start;
            --length;
            negative = true;
        } else if (buffer[start] == '+') {
            ++start;
            --length;
            negative = false;
        } else {
            negative = false;
        }
        String bufferString = new String(buffer, start, length);
        if (length <= 9) {
            int v = Integer.parseInt(bufferString);
            if (negative) {
                v = -v;
            }
            return JsonNode.createNumberNode((int)v);
        }
        if (length <= 18) {
            long v = Long.parseLong(bufferString);
            if (negative) {
                v = -v;
            }
            if ((long)((int)v) == v) {
                return JsonNode.createNumberNode((int)((int)v));
            }
            return JsonNode.createNumberNode((long)v);
        }
        try {
            return JsonNode.createNumberNode((BigInteger)new BigInteger(bufferString));
        }
        catch (NumberFormatException e) {
            throw this.errorContext.atPosition(this.lexer).invalidNumber(e);
        }
    }

    private JsonNode parseFloat(int nextState) throws IOException {
        String text = this.lexer.yytext().replace("_", "");
        this.pollExpected(TomlToken.FLOAT, nextState);
        if (text.endsWith("nan")) {
            return JsonNode.createNumberNode((float)Float.NaN);
        }
        if (text.endsWith("inf")) {
            return JsonNode.createNumberNode((float)(text.startsWith("-") ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY));
        }
        try {
            BigDecimal dec = new BigDecimal(text);
            return JsonNode.createNumberNode((BigDecimal)dec);
        }
        catch (NumberFormatException e) {
            throw this.errorContext.atPosition(this.lexer).invalidNumber(e);
        }
    }

    private TomlObjectBuilder parseInlineTable(int nextState) throws IOException {
        TomlObjectBuilder node;
        block3: {
            TomlToken sepToken;
            this.pollExpected(TomlToken.INLINE_TABLE_OPEN, 4);
            node = new TomlObjectBuilder();
            while (true) {
                TomlToken token;
                if ((token = this.peek()) == TomlToken.INLINE_TABLE_CLOSE) {
                    if (!node.isEmpty()) {
                        throw this.errorContext.atPosition(this.lexer).generic("Trailing comma not permitted for inline tables");
                    }
                    break block3;
                }
                this.parseKeyVal(node, 12);
                sepToken = this.peek();
                if (sepToken == TomlToken.INLINE_TABLE_CLOSE) break block3;
                if (sepToken != TomlToken.COMMA) break;
                this.pollExpected(TomlToken.COMMA, 4);
            }
            throw this.errorContext.atPosition(this.lexer).unexpectedToken(sepToken, "comma or table end");
        }
        this.pollExpected(TomlToken.INLINE_TABLE_CLOSE, nextState);
        node.closed = true;
        node.defined = true;
        return node;
    }

    private TomlArrayBuilder parseArray(int nextState) throws IOException {
        TomlToken token;
        this.pollExpected(TomlToken.ARRAY_OPEN, 6);
        TomlArrayBuilder node = new TomlArrayBuilder();
        while ((token = this.peek()) != TomlToken.ARRAY_CLOSE) {
            TomlNodeBuilder value = this.parseValue(10);
            node.add(value);
            TomlToken sepToken = this.peek();
            if (sepToken == TomlToken.ARRAY_CLOSE) break;
            if (sepToken == TomlToken.COMMA) {
                this.pollExpected(TomlToken.COMMA, 6);
                continue;
            }
            throw this.errorContext.atPosition(this.lexer).unexpectedToken(sepToken, "comma or array end");
        }
        this.pollExpected(TomlToken.ARRAY_CLOSE, nextState);
        node.closed = true;
        return node;
    }

    private void parseKeyVal(TomlObjectBuilder target, int nextState) throws IOException {
        FieldRef fieldRef = this.parseAndEnterKey(target, false);
        this.pollExpected(TomlToken.KEY_VAL_SEP, 6);
        TomlNodeBuilder value = this.parseValue(nextState);
        if (fieldRef.object.has(fieldRef.key)) {
            throw this.errorContext.atPosition(this.lexer).generic("Duplicate key");
        }
        fieldRef.object.set(fieldRef.key, value);
    }

    private TomlObjectBuilder getOrCreateObject(TomlObjectBuilder node, String field) throws TomlStreamReadException {
        TomlNodeBuilder existing = node.get(field);
        if (existing == null) {
            return node.putObject(field);
        }
        if (existing instanceof TomlObjectBuilder) {
            return (TomlObjectBuilder)existing;
        }
        throw this.errorContext.atPosition(this.lexer).generic("Path into existing non-object value of type " + existing.getNodeType());
    }

    private TomlArrayBuilder getOrCreateArray(TomlObjectBuilder node, String field) throws TomlStreamReadException {
        TomlNodeBuilder existing = node.get(field);
        if (existing == null) {
            return node.putArray(field);
        }
        if (existing instanceof TomlArrayBuilder) {
            return (TomlArrayBuilder)existing;
        }
        throw this.errorContext.atPosition(this.lexer).generic("Path into existing non-array value of type " + node.getNodeType());
    }

    private static class TomlObjectBuilder
    implements TomlNodeBuilder {
        final Map<String, TomlNodeBuilder> nodes = new LinkedHashMap<String, TomlNodeBuilder>();
        boolean closed = false;
        boolean defined = false;

        private TomlObjectBuilder() {
        }

        @Override
        public JsonNode build() {
            LinkedHashMap<String, JsonNode> baked = new LinkedHashMap<String, JsonNode>();
            for (Map.Entry<String, TomlNodeBuilder> entry : this.nodes.entrySet()) {
                JsonNode prev = baked.put(entry.getKey(), entry.getValue().build());
                if (prev != null) {
                    throw new AssertionError((Object)"duplicate key, should have been caught earlier");
                }
            }
            return JsonNode.createObjectNode(baked);
        }

        public TomlObjectBuilder putObject(String key) {
            TomlObjectBuilder child = new TomlObjectBuilder();
            this.nodes.put(key, child);
            return child;
        }

        @Nullable
        public TomlNodeBuilder get(String key) {
            return this.nodes.get(key);
        }

        public TomlArrayBuilder putArray(String key) {
            TomlArrayBuilder child = new TomlArrayBuilder();
            this.nodes.put(key, child);
            return child;
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public boolean has(String key) {
            return this.nodes.containsKey(key);
        }

        public void set(String key, TomlNodeBuilder value) {
            this.nodes.put(key, value);
        }

        @Override
        public String getNodeType() {
            return "table";
        }
    }

    private static class FieldRef {
        final TomlObjectBuilder object;
        final String key;

        FieldRef(TomlObjectBuilder object, String key) {
            this.object = object;
            this.key = key;
        }
    }

    private static class TomlArrayBuilder
    implements TomlNodeBuilder {
        final List<TomlNodeBuilder> nodes = new ArrayList<TomlNodeBuilder>();
        boolean closed = false;

        private TomlArrayBuilder() {
        }

        @Override
        public JsonNode build() {
            return JsonNode.createArrayNode(this.nodes.stream().map(TomlNodeBuilder::build).collect(Collectors.toList()));
        }

        public int size() {
            return this.nodes.size();
        }

        public TomlNodeBuilder get(int i) {
            return this.nodes.get(i);
        }

        public TomlObjectBuilder addObject() {
            TomlObjectBuilder child = new TomlObjectBuilder();
            this.nodes.add(child);
            return child;
        }

        @Override
        public String getNodeType() {
            return "array";
        }

        public void add(TomlNodeBuilder value) {
            this.nodes.add(value);
        }
    }

    private static interface TomlNodeBuilder {
        public JsonNode build();

        public String getNodeType();
    }

    private static class Scalar
    implements TomlNodeBuilder {
        private final JsonNode value;

        Scalar(JsonNode value) {
            this.value = value;
        }

        @Override
        public JsonNode build() {
            return this.value;
        }

        @Override
        public String getNodeType() {
            if (this.value.isNumber()) {
                return "number";
            }
            if (this.value.isBoolean()) {
                return "boolean";
            }
            if (this.value.isString()) {
                return "string";
            }
            return this.value.toString();
        }
    }
}

