// DO NOT EDIT
// Generated by JFlex 1.9.1 http://jflex.de/
// source: /home/runner/work/micronaut-toml/micronaut-toml/toml/src/main/jflex/io/micronaut/toml/toml.jflex

/*
 * Copyright 2017-2021 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * This file is adapted from jackson-dataformats-text, also developed by me (Jonas Konrad), also licensed under ASL 2.
 *
 * The TOML grammar and some parts of the test suite are adapted from the TOML project, which is licensed under the
 * MIT license:
 *
 * The MIT License
 *
 * Copyright (c) Tom Preston-Werner
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

 package io.micronaut.toml;


@SuppressWarnings("fallthrough")
class Lexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 4000;

  // Lexical states.
  public static final int YYINITIAL = 0;
  public static final int EXPECT_EXPRESSION = 2;
  public static final int EXPECT_INLINE_KEY = 4;
  public static final int EXPECT_VALUE = 6;
  public static final int EXPECT_EOL = 8;
  public static final int EXPECT_ARRAY_SEP = 10;
  public static final int EXPECT_TABLE_SEP = 12;
  public static final int ML_BASIC_STRING = 14;
  public static final int BASIC_STRING = 16;
  public static final int ML_LITERAL_STRING = 18;
  public static final int LITERAL_STRING = 20;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\u10ff\u0100";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\4\1\5"+
    "\1\6\1\7\3\5\1\10\3\5\1\11\1\12\1\13"+
    "\1\14\1\5\1\15\1\16\6\17\2\20\1\21\2\5"+
    "\1\22\3\5\4\23\1\24\1\23\15\25\1\26\1\27"+
    "\4\25\1\30\1\31\1\32\1\33\1\5\1\34\1\5"+
    "\1\35\1\36\2\23\1\37\1\40\2\25\1\41\2\25"+
    "\1\42\1\25\1\43\1\44\2\25\1\45\1\46\1\47"+
    "\1\50\2\25\1\51\2\25\1\52\1\5\1\53\1\5"+
    "\1\0\u0180\5";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[512];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\13\0\1\1\1\2\1\3\1\4\2\5\1\2\1\6"+
    "\1\5\1\7\1\10\1\11\1\12\1\1\1\3\1\13"+
    "\1\14\1\15\1\1\2\2\1\3\1\6\1\4\1\7"+
    "\1\3\2\16\1\17\1\20\4\3\1\21\1\5\1\22"+
    "\1\2\1\23\1\5\1\2\1\4\1\24\1\1\1\23"+
    "\1\24\1\25\1\26\1\2\1\27\1\30\1\31\1\30"+
    "\1\25\1\32\1\12\1\33\1\0\1\34\5\0\2\16"+
    "\3\0\1\35\4\0\1\16\16\0\1\36\1\0\1\27"+
    "\1\0\1\37\1\40\1\41\1\42\1\43\1\44\2\0"+
    "\1\45\1\46\1\35\1\47\1\35\2\0\1\47\4\16"+
    "\1\0\1\47\1\0\1\31\2\0\1\31\1\35\1\0"+
    "\1\16\1\0\1\50\1\51\2\0\1\52\2\0\1\53"+
    "\1\54\2\0\1\55\3\0\1\56\4\0\1\57\4\0"+
    "\1\60\1\57\1\61\10\0\1\62\2\0\1\63\1\0"+
    "\1\62\3\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[180];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\54\0\130\0\204\0\260\0\334\0\u0108\0\u0134"+
    "\0\u0160\0\u018c\0\u01b8\0\u01e4\0\u01e4\0\u01e4\0\u01e4\0\u0210"+
    "\0\u01e4\0\u023c\0\u01e4\0\u0268\0\u01e4\0\u0294\0\u02c0\0\u02ec"+
    "\0\u0318\0\u0318\0\u0344\0\u0370\0\u01e4\0\u039c\0\u039c\0\u03c8"+
    "\0\u039c\0\u03f4\0\u0420\0\u044c\0\u0478\0\u04a4\0\u04d0\0\u04fc"+
    "\0\u01e4\0\u0528\0\u0554\0\u0580\0\u05ac\0\u05d8\0\u0604\0\u01e4"+
    "\0\u0630\0\u01e4\0\u065c\0\u0688\0\u06b4\0\u06e0\0\u070c\0\u070c"+
    "\0\u0738\0\u0764\0\u01e4\0\u0790\0\u07bc\0\u07e8\0\u01e4\0\u0814"+
    "\0\u0840\0\u086c\0\u0898\0\u08c4\0\u0318\0\u01e4\0\u039c\0\u03c8"+
    "\0\u0420\0\u08f0\0\u091c\0\u0948\0\u0974\0\u0554\0\u0580\0\u09a0"+
    "\0\u09cc\0\u09f8\0\u0a24\0\u0a50\0\u0a7c\0\u0aa8\0\u0ad4\0\u0b00"+
    "\0\u0b2c\0\u0b58\0\u0b84\0\u0bb0\0\u0bdc\0\u0688\0\u06b4\0\u0c08"+
    "\0\u0c34\0\u070c\0\u0c60\0\u0c8c\0\u0cb8\0\u0ce4\0\u01e4\0\u0d10"+
    "\0\u01e4\0\u01e4\0\u01e4\0\u01e4\0\u01e4\0\u01e4\0\u0d3c\0\u0d68"+
    "\0\u01e4\0\u01e4\0\u0d94\0\u0dc0\0\u0dec\0\u0e18\0\u0e44\0\u0e70"+
    "\0\u0e9c\0\u0ec8\0\u0ef4\0\u0f20\0\u0f4c\0\u01e4\0\u0f78\0\u0fa4"+
    "\0\u0fd0\0\u0ffc\0\u1028\0\u1054\0\u1080\0\u10ac\0\u10d8\0\u01e4"+
    "\0\u1104\0\u1130\0\u115c\0\u1188\0\u11b4\0\u11e0\0\u01e4\0\u01e4"+
    "\0\u120c\0\u1238\0\u01e4\0\u1264\0\u1290\0\u12bc\0\u01e4\0\u12e8"+
    "\0\u1314\0\u1340\0\u136c\0\u1398\0\u13c4\0\u13f0\0\u141c\0\u1448"+
    "\0\u1474\0\u141c\0\u01e4\0\u14a0\0\u14cc\0\u14f8\0\u1524\0\u1550"+
    "\0\u157c\0\u15a8\0\u15d4\0\u1600\0\u162c\0\u1658\0\u01e4\0\u1684"+
    "\0\u16b0\0\u16dc\0\u1708\0\u1734";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[180];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\14\2\15\3\16\1\17\44\16\1\14\1\20\1\21"+
    "\1\22\1\20\1\16\1\23\1\24\1\25\2\16\1\26"+
    "\1\16\4\26\1\16\1\27\6\26\1\30\2\16\16\26"+
    "\2\16\1\14\1\31\2\15\1\32\1\16\1\23\1\17"+
    "\1\25\2\16\1\26\1\33\4\26\1\16\1\27\6\26"+
    "\2\16\1\34\16\26\1\16\1\35\1\14\1\36\1\37"+
    "\1\40\1\41\1\16\1\42\1\43\1\44\1\45\1\16"+
    "\1\45\1\16\1\46\3\47\10\16\1\50\1\16\1\51"+
    "\4\16\1\52\1\53\1\16\1\54\3\16\1\55\2\16"+
    "\1\56\1\16\1\14\1\57\1\60\1\61\1\57\2\62"+
    "\1\24\44\62\1\14\2\63\1\64\1\63\2\62\1\65"+
    "\2\62\1\66\20\62\1\51\20\62\1\14\1\67\2\15"+
    "\1\70\2\62\1\17\2\62\1\71\40\62\1\35\1\14"+
    "\1\72\1\73\1\74\2\72\1\75\23\72\1\76\21\72"+
    "\1\14\1\72\2\15\2\72\1\77\23\72\1\100\21\72"+
    "\1\14\1\101\1\73\1\74\4\101\1\102\43\101\1\14"+
    "\1\101\2\15\4\101\1\77\43\101\55\0\1\20\2\0"+
    "\1\20\15\0\1\27\33\0\1\21\52\0\1\24\2\0"+
    "\50\24\13\0\1\26\1\0\4\26\2\0\6\26\3\0"+
    "\16\26\3\0\1\27\2\0\1\27\50\0\1\103\2\0"+
    "\1\103\24\0\1\104\23\0\1\105\2\0\1\105\7\0"+
    "\1\33\5\0\1\27\10\0\1\34\17\0\1\35\1\0"+
    "\1\33\2\0\1\33\102\0\1\106\21\0\2\107\1\110"+
    "\1\107\2\0\1\111\23\0\1\51\22\0\1\107\57\0"+
    "\1\112\46\0\1\111\1\107\1\110\50\111\10\0\1\113"+
    "\60\0\1\114\3\115\20\0\1\116\1\0\1\117\24\0"+
    "\1\120\4\121\3\0\1\122\11\0\1\123\1\122\4\0"+
    "\1\124\4\0\1\125\16\0\1\120\4\126\3\0\1\122"+
    "\7\0\1\127\2\0\1\122\15\0\2\50\1\130\1\50"+
    "\2\0\1\131\101\0\1\132\61\0\1\133\45\0\1\134"+
    "\63\0\1\135\7\0\1\56\2\0\1\56\50\0\1\57"+
    "\2\0\1\57\51\0\1\60\52\0\2\63\1\136\1\63"+
    "\2\0\1\137\46\0\1\63\52\0\1\137\1\63\1\136"+
    "\50\137\1\0\2\66\1\140\1\66\2\0\1\141\45\0"+
    "\1\142\2\0\1\142\5\0\1\71\40\0\1\35\1\0"+
    "\1\71\2\0\1\71\50\0\1\72\2\0\2\72\1\0"+
    "\23\72\1\0\21\72\2\0\1\73\57\0\1\143\46\0"+
    "\1\144\1\145\1\146\1\144\1\0\1\147\20\0\1\150"+
    "\2\0\1\151\3\0\1\152\1\0\1\153\2\0\1\154"+
    "\1\0\1\155\1\0\1\156\1\157\11\0\1\147\20\0"+
    "\1\150\2\0\1\151\3\0\1\152\1\0\1\153\2\0"+
    "\1\154\1\0\1\155\1\0\1\156\1\157\4\0\1\101"+
    "\2\0\4\101\1\0\43\101\10\0\1\160\44\0\1\103"+
    "\2\0\1\103\50\0\1\104\2\0\1\104\55\0\1\161"+
    "\55\0\1\162\57\0\1\120\4\163\3\0\1\122\12\0"+
    "\1\122\30\0\1\120\4\115\3\0\1\122\7\0\1\127"+
    "\2\0\1\122\31\0\4\164\50\0\4\165\1\166\43\0"+
    "\1\167\1\0\1\167\1\0\4\170\50\0\2\171\52\0"+
    "\3\172\51\0\4\173\2\0\2\173\10\0\4\173\27\0"+
    "\1\120\4\174\1\166\2\0\1\122\7\0\1\127\2\0"+
    "\1\122\31\0\4\115\35\0\1\50\52\0\1\131\1\50"+
    "\1\130\50\131\42\0\1\175\51\0\1\176\56\0\1\176"+
    "\60\0\1\177\5\0\1\66\52\0\1\141\1\66\1\140"+
    "\50\141\6\0\1\200\46\0\1\144\1\145\1\146\1\144"+
    "\50\0\2\145\1\146\1\145\51\0\1\145\66\0\4\201"+
    "\2\0\2\201\10\0\4\201\30\0\4\202\2\0\2\202"+
    "\10\0\4\202\23\0\1\203\60\0\4\163\50\0\4\164"+
    "\3\0\1\122\7\0\1\120\2\0\1\122\31\0\4\204"+
    "\50\0\4\205\50\0\4\170\50\0\4\170\13\0\1\167"+
    "\34\0\2\171\15\0\1\123\34\0\3\172\14\0\1\124"+
    "\34\0\4\173\2\0\2\173\7\0\1\125\4\173\27\0"+
    "\1\120\4\206\3\0\1\122\7\0\1\127\2\0\1\122"+
    "\62\0\1\207\44\0\1\210\22\0\1\211\62\0\4\212"+
    "\2\0\2\212\10\0\4\212\30\0\4\213\2\0\2\213"+
    "\10\0\4\213\23\0\1\214\56\0\1\215\1\0\4\163"+
    "\50\0\4\216\46\0\1\215\1\120\4\115\3\0\1\122"+
    "\7\0\1\127\2\0\1\122\53\0\1\217\22\0\1\220"+
    "\62\0\4\221\2\0\2\221\10\0\4\221\30\0\4\222"+
    "\2\0\2\222\10\0\4\222\23\0\1\223\60\0\4\224"+
    "\54\0\1\225\47\0\4\226\2\0\2\226\10\0\4\226"+
    "\30\0\4\227\2\0\2\227\10\0\4\227\30\0\4\230"+
    "\50\0\4\231\50\0\4\232\2\0\2\232\10\0\4\232"+
    "\26\0\1\233\55\0\4\234\50\0\4\235\2\0\2\235"+
    "\10\0\4\235\30\0\4\236\47\0\1\237\54\0\4\240"+
    "\2\0\2\240\10\0\4\240\30\0\4\241\50\0\4\242"+
    "\50\0\4\243\2\0\2\243\10\0\4\243\17\0\1\244"+
    "\21\0\1\244\20\0\1\244\21\0\4\245\50\0\4\246"+
    "\54\0\1\247\47\0\4\250\50\0\4\251\54\0\1\252"+
    "\47\0\4\253\50\0\4\254\44\0\1\255\1\0\1\255"+
    "\1\256\13\0\1\257\40\0\4\260\50\0\4\261\50\0"+
    "\4\262\44\0\1\255\1\0\1\255\1\0\4\261\7\0"+
    "\1\257\44\0\1\263\47\0\4\264\50\0\4\257\33\0";

  private static int [] zzUnpacktrans() {
    int [] result = new int[5984];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\13\0\4\11\1\1\1\11\1\1\1\11\1\1\1\11"+
    "\7\1\1\11\13\1\1\11\6\1\1\11\1\1\1\11"+
    "\10\1\1\11\3\1\1\11\5\1\1\0\1\11\5\0"+
    "\2\1\3\0\1\1\4\0\1\1\16\0\1\1\1\0"+
    "\1\11\1\0\6\11\2\0\2\11\3\1\2\0\5\1"+
    "\1\0\1\11\1\0\1\1\2\0\2\1\1\0\1\1"+
    "\1\0\1\11\1\1\2\0\1\1\2\0\2\11\2\0"+
    "\1\11\3\0\1\11\4\0\1\1\4\0\2\1\1\11"+
    "\10\0\1\1\2\0\1\11\1\0\1\1\3\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[180];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[]; // JACKSON: remove initializer, moved to .jflex file

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  private final TomlStreamReadException.ErrorContext errorContext;

  boolean prohibitInternalBufferAllocate = false;

  private boolean trimmedNewline;
  final StringBuilder textBuffer;

  private void requestLargerBuffer() throws TomlStreamReadException {
      if (prohibitInternalBufferAllocate) {
          throw errorContext.atPosition(this).generic("Token too long, but buffer resizing prohibited");
      }

      char[] newBuffer = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
  }

  private void startString() {
      textBuffer.setLength(0);
      trimmedNewline = false;
  }

  private void appendNormalTextToken() {
      // equivalent to append(yytext()), without the roundtrip through the String constructor
      textBuffer.append(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }

  private void appendNewlineWithPossibleTrim() {
      if (!trimmedNewline && textBuffer.length() == 0) {
          trimmedNewline = true;
      } else {
          // \n or \r\n todo: "TOML parsers should feel free to normalize newline to whatever makes sense for their platform."
          appendNormalTextToken();
      }
  }

  private void appendUnicodeEscapeShort() {
      int value = (Character.digit(yycharat(2), 16) << 12) |
                   (Character.digit(yycharat(3), 16) << 8) |
                   (Character.digit(yycharat(4), 16) << 4) |
                   Character.digit(yycharat(5), 16);
      textBuffer.append((char) value);
  }

  private void appendUnicodeEscapeLong() throws java.io.IOException {
     int value = (Character.digit(yycharat(2), 16) << 28) |
                 (Character.digit(yycharat(3), 16) << 24) |
                 (Character.digit(yycharat(4), 16) << 20) |
                 (Character.digit(yycharat(5), 16) << 16) |
                 (Character.digit(yycharat(6), 16) << 12) |
                 (Character.digit(yycharat(7), 16) << 8) |
                 (Character.digit(yycharat(8), 16) << 4) |
                 Character.digit(yycharat(9), 16);
     if (Character.isValidCodePoint(value)) {
         // "Such code points can be represented using a single char."
         if (value <= Character.MAX_VALUE) {
             textBuffer.append((char) value);
         } else {
             textBuffer.append(Character.highSurrogate(value));
             textBuffer.append(Character.lowSurrogate(value));
         }
     } else {
         throw errorContext.atPosition(this).generic("Invalid code point " + Integer.toHexString(value));
     }
  }

  int getLine() { return yyline; }
  int getColumn() { return yycolumn; }
  long getCharPos() { return yychar; }

  char[] getTextBuffer() { return zzBuffer; };
  int getTextBufferStart() { return zzStartRead; };
  int getTextBufferEnd() { return zzMarkedPos; };


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Lexer(java.io.Reader in, TomlStreamReadException.ErrorContext errorContext) {
  this.errorContext = errorContext;
yybegin(EXPECT_EXPRESSION);
this.textBuffer = new StringBuilder();
this.zzBuffer = new char[256];
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      // JACKSON: replace resize logic, more in .jflex
      requestLargerBuffer();
      // JACKSON: the low surrogate is read below
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }

  // JACKSON: remove yyreset without replacement

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public TomlToken yylex() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { throw errorContext.atPosition(this).generic("Illegal control character");
            }
          // fall through
          case 52: break;
          case 2:
            { throw errorContext.atPosition(this).generic("Newline not permitted here");
            }
          // fall through
          case 53: break;
          case 3:
            { throw errorContext.atPosition(this).generic("Unknown token");
            }
          // fall through
          case 54: break;
          case 4:
            { throw errorContext.atPosition(this).generic("Comment not permitted here");
            }
          // fall through
          case 55: break;
          case 5:
            { 
            }
          // fall through
          case 56: break;
          case 6:
            { yybegin(BASIC_STRING);
          startString();
            }
          // fall through
          case 57: break;
          case 7:
            { yybegin(LITERAL_STRING);
          startString();
            }
          // fall through
          case 58: break;
          case 8:
            { return TomlToken.UNQUOTED_KEY;
            }
          // fall through
          case 59: break;
          case 9:
            { return TomlToken.KEY_VAL_SEP;
            }
          // fall through
          case 60: break;
          case 10:
            { return TomlToken.STD_TABLE_OPEN;
            }
          // fall through
          case 61: break;
          case 11:
            { return TomlToken.DOT_SEP;
            }
          // fall through
          case 62: break;
          case 12:
            { return TomlToken.STD_TABLE_CLOSE;
            }
          // fall through
          case 63: break;
          case 13:
            { return TomlToken.INLINE_TABLE_CLOSE;
            }
          // fall through
          case 64: break;
          case 14:
            { return TomlToken.INTEGER;
            }
          // fall through
          case 65: break;
          case 15:
            { return TomlToken.ARRAY_OPEN;
            }
          // fall through
          case 66: break;
          case 16:
            { return TomlToken.ARRAY_CLOSE;
            }
          // fall through
          case 67: break;
          case 17:
            { return TomlToken.INLINE_TABLE_OPEN;
            }
          // fall through
          case 68: break;
          case 18:
            { yybegin(EXPECT_EXPRESSION);
            }
          // fall through
          case 69: break;
          case 19:
            { throw errorContext.atPosition(this).generic("More data after value has already ended. Invalid value preceding this position?");
            }
          // fall through
          case 70: break;
          case 20:
            { return TomlToken.COMMA;
            }
          // fall through
          case 71: break;
          case 21:
            { appendNormalTextToken();
            }
          // fall through
          case 72: break;
          case 22:
            { appendNewlineWithPossibleTrim();
            }
          // fall through
          case 73: break;
          case 23:
            { textBuffer.append('"');
            }
          // fall through
          case 74: break;
          case 24:
            { throw errorContext.atPosition(this).generic("Unknown escape sequence");
            }
          // fall through
          case 75: break;
          case 25:
            { return TomlToken.STRING;
            }
          // fall through
          case 76: break;
          case 26:
            { textBuffer.append('\'');
            }
          // fall through
          case 77: break;
          case 27:
            { return TomlToken.ARRAY_TABLE_OPEN;
            }
          // fall through
          case 78: break;
          case 28:
            { return TomlToken.ARRAY_TABLE_CLOSE;
            }
          // fall through
          case 79: break;
          case 29:
            { throw errorContext.atPosition(this).generic("Zero-prefixed ints are not valid. If you want an octal literal, use the prefix '0o'");
            }
          // fall through
          case 80: break;
          case 30:
            { trimmedNewline = true;
            }
          // fall through
          case 81: break;
          case 31:
            { textBuffer.append('\\');
            }
          // fall through
          case 82: break;
          case 32:
            { textBuffer.append('\b');
            }
          // fall through
          case 83: break;
          case 33:
            { textBuffer.append('\f');
            }
          // fall through
          case 84: break;
          case 34:
            { textBuffer.append('\n');
            }
          // fall through
          case 85: break;
          case 35:
            { textBuffer.append('\r');
            }
          // fall through
          case 86: break;
          case 36:
            { textBuffer.append('\t');
            }
          // fall through
          case 87: break;
          case 37:
            { yybegin(ML_BASIC_STRING);
          startString();
            }
          // fall through
          case 88: break;
          case 38:
            { yybegin(ML_LITERAL_STRING);
          startString();
            }
          // fall through
          case 89: break;
          case 39:
            { return TomlToken.FLOAT;
            }
          // fall through
          case 90: break;
          case 40:
            { return TomlToken.TRUE;
            }
          // fall through
          case 91: break;
          case 41:
            { textBuffer.append('"');
          return TomlToken.STRING;
            }
          // fall through
          case 92: break;
          case 42:
            { textBuffer.append('\'');
          return TomlToken.STRING;
            }
          // fall through
          case 93: break;
          case 43:
            { return TomlToken.FALSE;
            }
          // fall through
          case 94: break;
          case 44:
            { textBuffer.append('"');
          textBuffer.append('"');
          return TomlToken.STRING;
            }
          // fall through
          case 95: break;
          case 45:
            { textBuffer.append('\'');
          textBuffer.append('\'');
          return TomlToken.STRING;
            }
          // fall through
          case 96: break;
          case 46:
            { appendUnicodeEscapeShort();
            }
          // fall through
          case 97: break;
          case 47:
            { return TomlToken.LOCAL_TIME;
            }
          // fall through
          case 98: break;
          case 48:
            { return TomlToken.LOCAL_DATE;
            }
          // fall through
          case 99: break;
          case 49:
            { appendUnicodeEscapeLong();
            }
          // fall through
          case 100: break;
          case 50:
            { return TomlToken.LOCAL_DATE_TIME;
            }
          // fall through
          case 101: break;
          case 51:
            { return TomlToken.OFFSET_DATE_TIME;
            }
          // fall through
          case 102: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
