/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.toml;

import io.micronaut.toml.TomlStreamReadException;
import io.micronaut.toml.TomlToken;
import java.io.IOException;
import java.io.Reader;

class Lexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 4000;
    public static final int YYINITIAL = 0;
    public static final int EXPECT_EXPRESSION = 2;
    public static final int EXPECT_INLINE_KEY = 4;
    public static final int EXPECT_VALUE = 6;
    public static final int EXPECT_EOL = 8;
    public static final int EXPECT_ARRAY_SEP = 10;
    public static final int EXPECT_TABLE_SEP = 12;
    public static final int ML_BASIC_STRING = 14;
    public static final int BASIC_STRING = 16;
    public static final int ML_LITERAL_STRING = 18;
    public static final int LITERAL_STRING = 20;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10};
    private static final int[] ZZ_CMAP_TOP = Lexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u10ff\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = Lexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0001\u0001\u0001\u0002\u0002\u0000\u0001\u0003\u0012\u0000\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0003\u0005\u0001\b\u0003\u0005\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\u0005\u0001\r\u0001\u000e\u0006\u000f\u0002\u0010\u0001\u0011\u0002\u0005\u0001\u0012\u0003\u0005\u0004\u0013\u0001\u0014\u0001\u0013\r\u0015\u0001\u0016\u0001\u0017\u0004\u0015\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u0005\u0001\u001c\u0001\u0005\u0001\u001d\u0001\u001e\u0002\u0013\u0001\u001f\u0001 \u0002\u0015\u0001!\u0002\u0015\u0001\"\u0001\u0015\u0001#\u0001$\u0002\u0015\u0001%\u0001&\u0001'\u0001(\u0002\u0015\u0001)\u0002\u0015\u0001*\u0001\u0005\u0001+\u0001\u0005\u0001\u0000\u0180\u0005";
    private static final int[] ZZ_ACTION = Lexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u000b\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0002\u0005\u0001\u0002\u0001\u0006\u0001\u0005\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u0001\u0001\u0003\u0001\u000b\u0001\f\u0001\r\u0001\u0001\u0002\u0002\u0001\u0003\u0001\u0006\u0001\u0004\u0001\u0007\u0001\u0003\u0002\u000e\u0001\u000f\u0001\u0010\u0004\u0003\u0001\u0011\u0001\u0005\u0001\u0012\u0001\u0002\u0001\u0013\u0001\u0005\u0001\u0002\u0001\u0004\u0001\u0014\u0001\u0001\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0002\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u0018\u0001\u0015\u0001\u001a\u0001\n\u0001\u001b\u0001\u0000\u0001\u001c\u0005\u0000\u0002\u000e\u0003\u0000\u0001\u001d\u0004\u0000\u0001\u000e\u000e\u0000\u0001\u001e\u0001\u0000\u0001\u0017\u0001\u0000\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0002\u0000\u0001%\u0001&\u0001\u001d\u0001'\u0001\u001d\u0002\u0000\u0001'\u0004\u000e\u0001\u0000\u0001'\u0001\u0000\u0001\u0019\u0002\u0000\u0001\u0019\u0001\u001d\u0001\u0000\u0001\u000e\u0001\u0000\u0001(\u0001)\u0002\u0000\u0001*\u0002\u0000\u0001+\u0001,\u0002\u0000\u0001-\u0003\u0000\u0001.\u0004\u0000\u0001/\u0004\u0000\u00010\u0001/\u00011\b\u0000\u00012\u0002\u0000\u00013\u0001\u0000\u00012\u0003\u0000";
    private static final int[] ZZ_ROWMAP = Lexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000,\u0000X\u0000\u0084\u0000\u00b0\u0000\u00dc\u0000\u0108\u0000\u0134\u0000\u0160\u0000\u018c\u0000\u01b8\u0000\u01e4\u0000\u01e4\u0000\u01e4\u0000\u01e4\u0000\u0210\u0000\u01e4\u0000\u023c\u0000\u01e4\u0000\u0268\u0000\u01e4\u0000\u0294\u0000\u02c0\u0000\u02ec\u0000\u0318\u0000\u0318\u0000\u0344\u0000\u0370\u0000\u01e4\u0000\u039c\u0000\u039c\u0000\u03c8\u0000\u039c\u0000\u03f4\u0000\u0420\u0000\u044c\u0000\u0478\u0000\u04a4\u0000\u04d0\u0000\u04fc\u0000\u01e4\u0000\u0528\u0000\u0554\u0000\u0580\u0000\u05ac\u0000\u05d8\u0000\u0604\u0000\u01e4\u0000\u0630\u0000\u01e4\u0000\u065c\u0000\u0688\u0000\u06b4\u0000\u06e0\u0000\u070c\u0000\u070c\u0000\u0738\u0000\u0764\u0000\u01e4\u0000\u0790\u0000\u07bc\u0000\u07e8\u0000\u01e4\u0000\u0814\u0000\u0840\u0000\u086c\u0000\u0898\u0000\u08c4\u0000\u0318\u0000\u01e4\u0000\u039c\u0000\u03c8\u0000\u0420\u0000\u08f0\u0000\u091c\u0000\u0948\u0000\u0974\u0000\u0554\u0000\u0580\u0000\u09a0\u0000\u09cc\u0000\u09f8\u0000\u0a24\u0000\u0a50\u0000\u0a7c\u0000\u0aa8\u0000\u0ad4\u0000\u0b00\u0000\u0b2c\u0000\u0b58\u0000\u0b84\u0000\u0bb0\u0000\u0bdc\u0000\u0688\u0000\u06b4\u0000\u0c08\u0000\u0c34\u0000\u070c\u0000\u0c60\u0000\u0c8c\u0000\u0cb8\u0000\u0ce4\u0000\u01e4\u0000\u0d10\u0000\u01e4\u0000\u01e4\u0000\u01e4\u0000\u01e4\u0000\u01e4\u0000\u01e4\u0000\u0d3c\u0000\u0d68\u0000\u01e4\u0000\u01e4\u0000\u0d94\u0000\u0dc0\u0000\u0dec\u0000\u0e18\u0000\u0e44\u0000\u0e70\u0000\u0e9c\u0000\u0ec8\u0000\u0ef4\u0000\u0f20\u0000\u0f4c\u0000\u01e4\u0000\u0f78\u0000\u0fa4\u0000\u0fd0\u0000\u0ffc\u0000\u1028\u0000\u1054\u0000\u1080\u0000\u10ac\u0000\u10d8\u0000\u01e4\u0000\u1104\u0000\u1130\u0000\u115c\u0000\u1188\u0000\u11b4\u0000\u11e0\u0000\u01e4\u0000\u01e4\u0000\u120c\u0000\u1238\u0000\u01e4\u0000\u1264\u0000\u1290\u0000\u12bc\u0000\u01e4\u0000\u12e8\u0000\u1314\u0000\u1340\u0000\u136c\u0000\u1398\u0000\u13c4\u0000\u13f0\u0000\u141c\u0000\u1448\u0000\u1474\u0000\u141c\u0000\u01e4\u0000\u14a0\u0000\u14cc\u0000\u14f8\u0000\u1524\u0000\u1550\u0000\u157c\u0000\u15a8\u0000\u15d4\u0000\u1600\u0000\u162c\u0000\u1658\u0000\u01e4\u0000\u1684\u0000\u16b0\u0000\u16dc\u0000\u1708\u0000\u1734";
    private static final int[] ZZ_TRANS = Lexer.zzUnpacktrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0002\f\u0002\r\u0003\u000e\u0001\u000f$\u000e\u0001\f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0010\u0001\u000e\u0001\u0013\u0001\u0014\u0001\u0015\u0002\u000e\u0001\u0016\u0001\u000e\u0004\u0016\u0001\u000e\u0001\u0017\u0006\u0016\u0001\u0018\u0002\u000e\u000e\u0016\u0002\u000e\u0001\f\u0001\u0019\u0002\r\u0001\u001a\u0001\u000e\u0001\u0013\u0001\u000f\u0001\u0015\u0002\u000e\u0001\u0016\u0001\u001b\u0004\u0016\u0001\u000e\u0001\u0017\u0006\u0016\u0002\u000e\u0001\u001c\u000e\u0016\u0001\u000e\u0001\u001d\u0001\f\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\u000e\u0001\"\u0001#\u0001$\u0001%\u0001\u000e\u0001%\u0001\u000e\u0001&\u0003'\b\u000e\u0001(\u0001\u000e\u0001)\u0004\u000e\u0001*\u0001+\u0001\u000e\u0001,\u0003\u000e\u0001-\u0002\u000e\u0001.\u0001\u000e\u0001\f\u0001/\u00010\u00011\u0001/\u00022\u0001\u0014$2\u0001\f\u00023\u00014\u00013\u00022\u00015\u00022\u00016\u00102\u0001)\u00102\u0001\f\u00017\u0002\r\u00018\u00022\u0001\u000f\u00022\u00019 2\u0001\u001d\u0001\f\u0001:\u0001;\u0001<\u0002:\u0001=\u0013:\u0001>\u0011:\u0001\f\u0001:\u0002\r\u0002:\u0001?\u0013:\u0001@\u0011:\u0001\f\u0001A\u0001;\u0001<\u0004A\u0001B#A\u0001\f\u0001A\u0002\r\u0004A\u0001?#A-\u0000\u0001\u0010\u0002\u0000\u0001\u0010\r\u0000\u0001\u0017\u001b\u0000\u0001\u0011*\u0000\u0001\u0014\u0002\u0000(\u0014\u000b\u0000\u0001\u0016\u0001\u0000\u0004\u0016\u0002\u0000\u0006\u0016\u0003\u0000\u000e\u0016\u0003\u0000\u0001\u0017\u0002\u0000\u0001\u0017(\u0000\u0001C\u0002\u0000\u0001C\u0014\u0000\u0001D\u0013\u0000\u0001E\u0002\u0000\u0001E\u0007\u0000\u0001\u001b\u0005\u0000\u0001\u0017\b\u0000\u0001\u001c\u000f\u0000\u0001\u001d\u0001\u0000\u0001\u001b\u0002\u0000\u0001\u001bB\u0000\u0001F\u0011\u0000\u0002G\u0001H\u0001G\u0002\u0000\u0001I\u0013\u0000\u0001)\u0012\u0000\u0001G/\u0000\u0001J&\u0000\u0001I\u0001G\u0001H(I\b\u0000\u0001K0\u0000\u0001L\u0003M\u0010\u0000\u0001N\u0001\u0000\u0001O\u0014\u0000\u0001P\u0004Q\u0003\u0000\u0001R\t\u0000\u0001S\u0001R\u0004\u0000\u0001T\u0004\u0000\u0001U\u000e\u0000\u0001P\u0004V\u0003\u0000\u0001R\u0007\u0000\u0001W\u0002\u0000\u0001R\r\u0000\u0002(\u0001X\u0001(\u0002\u0000\u0001YA\u0000\u0001Z1\u0000\u0001[%\u0000\u0001\\3\u0000\u0001]\u0007\u0000\u0001.\u0002\u0000\u0001.(\u0000\u0001/\u0002\u0000\u0001/)\u0000\u00010*\u0000\u00023\u0001^\u00013\u0002\u0000\u0001_&\u0000\u00013*\u0000\u0001_\u00013\u0001^(_\u0001\u0000\u00026\u0001`\u00016\u0002\u0000\u0001a%\u0000\u0001b\u0002\u0000\u0001b\u0005\u0000\u00019 \u0000\u0001\u001d\u0001\u0000\u00019\u0002\u0000\u00019(\u0000\u0001:\u0002\u0000\u0002:\u0001\u0000\u0013:\u0001\u0000\u0011:\u0002\u0000\u0001;/\u0000\u0001c&\u0000\u0001d\u0001e\u0001f\u0001d\u0001\u0000\u0001g\u0010\u0000\u0001h\u0002\u0000\u0001i\u0003\u0000\u0001j\u0001\u0000\u0001k\u0002\u0000\u0001l\u0001\u0000\u0001m\u0001\u0000\u0001n\u0001o\t\u0000\u0001g\u0010\u0000\u0001h\u0002\u0000\u0001i\u0003\u0000\u0001j\u0001\u0000\u0001k\u0002\u0000\u0001l\u0001\u0000\u0001m\u0001\u0000\u0001n\u0001o\u0004\u0000\u0001A\u0002\u0000\u0004A\u0001\u0000#A\b\u0000\u0001p$\u0000\u0001C\u0002\u0000\u0001C(\u0000\u0001D\u0002\u0000\u0001D-\u0000\u0001q-\u0000\u0001r/\u0000\u0001P\u0004s\u0003\u0000\u0001R\n\u0000\u0001R\u0018\u0000\u0001P\u0004M\u0003\u0000\u0001R\u0007\u0000\u0001W\u0002\u0000\u0001R\u0019\u0000\u0004t(\u0000\u0004u\u0001v#\u0000\u0001w\u0001\u0000\u0001w\u0001\u0000\u0004x(\u0000\u0002y*\u0000\u0003z)\u0000\u0004{\u0002\u0000\u0002{\b\u0000\u0004{\u0017\u0000\u0001P\u0004|\u0001v\u0002\u0000\u0001R\u0007\u0000\u0001W\u0002\u0000\u0001R\u0019\u0000\u0004M\u001d\u0000\u0001(*\u0000\u0001Y\u0001(\u0001X(Y\"\u0000\u0001})\u0000\u0001~.\u0000\u0001~0\u0000\u0001\u007f\u0005\u0000\u00016*\u0000\u0001a\u00016\u0001`(a\u0006\u0000\u0001\u0080&\u0000\u0001d\u0001e\u0001f\u0001d(\u0000\u0002e\u0001f\u0001e)\u0000\u0001e6\u0000\u0004\u0081\u0002\u0000\u0002\u0081\b\u0000\u0004\u0081\u0018\u0000\u0004\u0082\u0002\u0000\u0002\u0082\b\u0000\u0004\u0082\u0013\u0000\u0001\u00830\u0000\u0004s(\u0000\u0004t\u0003\u0000\u0001R\u0007\u0000\u0001P\u0002\u0000\u0001R\u0019\u0000\u0004\u0084(\u0000\u0004\u0085(\u0000\u0004x(\u0000\u0004x\u000b\u0000\u0001w\u001c\u0000\u0002y\r\u0000\u0001S\u001c\u0000\u0003z\f\u0000\u0001T\u001c\u0000\u0004{\u0002\u0000\u0002{\u0007\u0000\u0001U\u0004{\u0017\u0000\u0001P\u0004\u0086\u0003\u0000\u0001R\u0007\u0000\u0001W\u0002\u0000\u0001R2\u0000\u0001\u0087$\u0000\u0001\u0088\u0012\u0000\u0001\u00892\u0000\u0004\u008a\u0002\u0000\u0002\u008a\b\u0000\u0004\u008a\u0018\u0000\u0004\u008b\u0002\u0000\u0002\u008b\b\u0000\u0004\u008b\u0013\u0000\u0001\u008c.\u0000\u0001\u008d\u0001\u0000\u0004s(\u0000\u0004\u008e&\u0000\u0001\u008d\u0001P\u0004M\u0003\u0000\u0001R\u0007\u0000\u0001W\u0002\u0000\u0001R+\u0000\u0001\u008f\u0012\u0000\u0001\u00902\u0000\u0004\u0091\u0002\u0000\u0002\u0091\b\u0000\u0004\u0091\u0018\u0000\u0004\u0092\u0002\u0000\u0002\u0092\b\u0000\u0004\u0092\u0013\u0000\u0001\u00930\u0000\u0004\u0094,\u0000\u0001\u0095'\u0000\u0004\u0096\u0002\u0000\u0002\u0096\b\u0000\u0004\u0096\u0018\u0000\u0004\u0097\u0002\u0000\u0002\u0097\b\u0000\u0004\u0097\u0018\u0000\u0004\u0098(\u0000\u0004\u0099(\u0000\u0004\u009a\u0002\u0000\u0002\u009a\b\u0000\u0004\u009a\u0016\u0000\u0001\u009b-\u0000\u0004\u009c(\u0000\u0004\u009d\u0002\u0000\u0002\u009d\b\u0000\u0004\u009d\u0018\u0000\u0004\u009e'\u0000\u0001\u009f,\u0000\u0004\u00a0\u0002\u0000\u0002\u00a0\b\u0000\u0004\u00a0\u0018\u0000\u0004\u00a1(\u0000\u0004\u00a2(\u0000\u0004\u00a3\u0002\u0000\u0002\u00a3\b\u0000\u0004\u00a3\u000f\u0000\u0001\u00a4\u0011\u0000\u0001\u00a4\u0010\u0000\u0001\u00a4\u0011\u0000\u0004\u00a5(\u0000\u0004\u00a6,\u0000\u0001\u00a7'\u0000\u0004\u00a8(\u0000\u0004\u00a9,\u0000\u0001\u00aa'\u0000\u0004\u00ab(\u0000\u0004\u00ac$\u0000\u0001\u00ad\u0001\u0000\u0001\u00ad\u0001\u00ae\u000b\u0000\u0001\u00af \u0000\u0004\u00b0(\u0000\u0004\u00b1(\u0000\u0004\u00b2$\u0000\u0001\u00ad\u0001\u0000\u0001\u00ad\u0001\u0000\u0004\u00b1\u0007\u0000\u0001\u00af$\u0000\u0001\u00b3'\u0000\u0004\u00b4(\u0000\u0004\u00af\u001b\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = Lexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u000b\u0000\u0004\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0007\u0001\u0001\t\u000b\u0001\u0001\t\u0006\u0001\u0001\t\u0001\u0001\u0001\t\b\u0001\u0001\t\u0003\u0001\u0001\t\u0005\u0001\u0001\u0000\u0001\t\u0005\u0000\u0002\u0001\u0003\u0000\u0001\u0001\u0004\u0000\u0001\u0001\u000e\u0000\u0001\u0001\u0001\u0000\u0001\t\u0001\u0000\u0006\t\u0002\u0000\u0002\t\u0003\u0001\u0002\u0000\u0005\u0001\u0001\u0000\u0001\t\u0001\u0000\u0001\u0001\u0002\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0002\t\u0002\u0000\u0001\t\u0003\u0000\u0001\t\u0004\u0000\u0001\u0001\u0004\u0000\u0002\u0001\u0001\t\b\u0000\u0001\u0001\u0002\u0000\u0001\t\u0001\u0000\u0001\u0001\u0003\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer;
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private final TomlStreamReadException.ErrorContext errorContext;
    boolean prohibitInternalBufferAllocate = false;
    private boolean trimmedNewline;
    final StringBuilder textBuffer;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = Lexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[512];
        int offset = 0;
        offset = Lexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[180];
        int offset = 0;
        offset = Lexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[180];
        int offset = 0;
        offset = Lexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length() - 1;
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpacktrans() {
        int[] result = new int[5984];
        int offset = 0;
        offset = Lexer.zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpacktrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[180];
        int offset = 0;
        offset = Lexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private void requestLargerBuffer() throws TomlStreamReadException {
        if (this.prohibitInternalBufferAllocate) {
            throw this.errorContext.atPosition(this).generic("Token too long, but buffer resizing prohibited");
        }
        char[] newBuffer = new char[this.zzBuffer.length * 2];
        System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
        this.zzBuffer = newBuffer;
    }

    private void startString() {
        this.textBuffer.setLength(0);
        this.trimmedNewline = false;
    }

    private void appendNormalTextToken() {
        this.textBuffer.append(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    private void appendNewlineWithPossibleTrim() {
        if (!this.trimmedNewline && this.textBuffer.length() == 0) {
            this.trimmedNewline = true;
        } else {
            this.appendNormalTextToken();
        }
    }

    private void appendUnicodeEscapeShort() {
        int value = Character.digit(this.yycharat(2), 16) << 12 | Character.digit(this.yycharat(3), 16) << 8 | Character.digit(this.yycharat(4), 16) << 4 | Character.digit(this.yycharat(5), 16);
        this.textBuffer.append((char)value);
    }

    private void appendUnicodeEscapeLong() throws IOException {
        int value = Character.digit(this.yycharat(2), 16) << 28 | Character.digit(this.yycharat(3), 16) << 24 | Character.digit(this.yycharat(4), 16) << 20 | Character.digit(this.yycharat(5), 16) << 16 | Character.digit(this.yycharat(6), 16) << 12 | Character.digit(this.yycharat(7), 16) << 8 | Character.digit(this.yycharat(8), 16) << 4 | Character.digit(this.yycharat(9), 16);
        if (Character.isValidCodePoint(value)) {
            if (value <= 65535) {
                this.textBuffer.append((char)value);
            } else {
                this.textBuffer.append(Character.highSurrogate(value));
                this.textBuffer.append(Character.lowSurrogate(value));
            }
        } else {
            throw this.errorContext.atPosition(this).generic("Invalid code point " + Integer.toHexString(value));
        }
    }

    int getLine() {
        return this.yyline;
    }

    int getColumn() {
        return this.yycolumn;
    }

    long getCharPos() {
        return this.yychar;
    }

    char[] getTextBuffer() {
        return this.zzBuffer;
    }

    int getTextBufferStart() {
        return this.zzStartRead;
    }

    int getTextBufferEnd() {
        return this.zzMarkedPos;
    }

    Lexer(Reader in, TomlStreamReadException.ErrorContext errorContext) {
        this.errorContext = errorContext;
        this.yybegin(2);
        this.textBuffer = new StringBuilder();
        this.zzBuffer = new char[256];
        this.zzReader = in;
    }

    private int zzMaxBufferLen() {
        return Integer.MAX_VALUE;
    }

    private boolean zzCanGrow() {
        return true;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            this.requestLargerBuffer();
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (numRead == requested) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int c = this.zzReader.read();
                    if (c == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)c;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    private final void yyResetPosition() {
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            Lexer.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public TomlToken yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block108: while (true) {
            int zzInput;
            boolean eof;
            int zzCurrentPosL;
            int zzCharCount;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += (long)(zzMarkedPosL - this.zzStartRead);
            boolean zzR = false;
            block109: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; zzCurrentPosL += zzCharCount) {
                int zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
                zzCharCount = Character.charCount(zzCh);
                switch (zzCh) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = false;
                        continue block109;
                    }
                    case 13: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = true;
                        continue block109;
                    }
                    case 10: {
                        if (zzR) {
                            zzR = false;
                            continue block109;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block109;
                    }
                    default: {
                        zzR = false;
                        this.yycolumn += zzCharCount;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + Lexer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    throw this.errorContext.atPosition(this).generic("Illegal control character");
                }
                case 52: {
                    continue block108;
                }
                case 2: {
                    throw this.errorContext.atPosition(this).generic("Newline not permitted here");
                }
                case 53: {
                    continue block108;
                }
                case 3: {
                    throw this.errorContext.atPosition(this).generic("Unknown token");
                }
                case 54: {
                    continue block108;
                }
                case 4: {
                    throw this.errorContext.atPosition(this).generic("Comment not permitted here");
                }
                case 55: {
                    continue block108;
                }
                case 5: 
                case 56: {
                    continue block108;
                }
                case 6: {
                    this.yybegin(16);
                    this.startString();
                }
                case 57: {
                    continue block108;
                }
                case 7: {
                    this.yybegin(20);
                    this.startString();
                }
                case 58: {
                    continue block108;
                }
                case 8: {
                    return TomlToken.UNQUOTED_KEY;
                }
                case 59: {
                    continue block108;
                }
                case 9: {
                    return TomlToken.KEY_VAL_SEP;
                }
                case 60: {
                    continue block108;
                }
                case 10: {
                    return TomlToken.STD_TABLE_OPEN;
                }
                case 61: {
                    continue block108;
                }
                case 11: {
                    return TomlToken.DOT_SEP;
                }
                case 62: {
                    continue block108;
                }
                case 12: {
                    return TomlToken.STD_TABLE_CLOSE;
                }
                case 63: {
                    continue block108;
                }
                case 13: {
                    return TomlToken.INLINE_TABLE_CLOSE;
                }
                case 64: {
                    continue block108;
                }
                case 14: {
                    return TomlToken.INTEGER;
                }
                case 65: {
                    continue block108;
                }
                case 15: {
                    return TomlToken.ARRAY_OPEN;
                }
                case 66: {
                    continue block108;
                }
                case 16: {
                    return TomlToken.ARRAY_CLOSE;
                }
                case 67: {
                    continue block108;
                }
                case 17: {
                    return TomlToken.INLINE_TABLE_OPEN;
                }
                case 68: {
                    continue block108;
                }
                case 18: {
                    this.yybegin(2);
                }
                case 69: {
                    continue block108;
                }
                case 19: {
                    throw this.errorContext.atPosition(this).generic("More data after value has already ended. Invalid value preceding this position?");
                }
                case 70: {
                    continue block108;
                }
                case 20: {
                    return TomlToken.COMMA;
                }
                case 71: {
                    continue block108;
                }
                case 21: {
                    this.appendNormalTextToken();
                }
                case 72: {
                    continue block108;
                }
                case 22: {
                    this.appendNewlineWithPossibleTrim();
                }
                case 73: {
                    continue block108;
                }
                case 23: {
                    this.textBuffer.append('\"');
                }
                case 74: {
                    continue block108;
                }
                case 24: {
                    throw this.errorContext.atPosition(this).generic("Unknown escape sequence");
                }
                case 75: {
                    continue block108;
                }
                case 25: {
                    return TomlToken.STRING;
                }
                case 76: {
                    continue block108;
                }
                case 26: {
                    this.textBuffer.append('\'');
                }
                case 77: {
                    continue block108;
                }
                case 27: {
                    return TomlToken.ARRAY_TABLE_OPEN;
                }
                case 78: {
                    continue block108;
                }
                case 28: {
                    return TomlToken.ARRAY_TABLE_CLOSE;
                }
                case 79: {
                    continue block108;
                }
                case 29: {
                    throw this.errorContext.atPosition(this).generic("Zero-prefixed ints are not valid. If you want an octal literal, use the prefix '0o'");
                }
                case 80: {
                    continue block108;
                }
                case 30: {
                    this.trimmedNewline = true;
                }
                case 81: {
                    continue block108;
                }
                case 31: {
                    this.textBuffer.append('\\');
                }
                case 82: {
                    continue block108;
                }
                case 32: {
                    this.textBuffer.append('\b');
                }
                case 83: {
                    continue block108;
                }
                case 33: {
                    this.textBuffer.append('\f');
                }
                case 84: {
                    continue block108;
                }
                case 34: {
                    this.textBuffer.append('\n');
                }
                case 85: {
                    continue block108;
                }
                case 35: {
                    this.textBuffer.append('\r');
                }
                case 86: {
                    continue block108;
                }
                case 36: {
                    this.textBuffer.append('\t');
                }
                case 87: {
                    continue block108;
                }
                case 37: {
                    this.yybegin(14);
                    this.startString();
                }
                case 88: {
                    continue block108;
                }
                case 38: {
                    this.yybegin(18);
                    this.startString();
                }
                case 89: {
                    continue block108;
                }
                case 39: {
                    return TomlToken.FLOAT;
                }
                case 90: {
                    continue block108;
                }
                case 40: {
                    return TomlToken.TRUE;
                }
                case 91: {
                    continue block108;
                }
                case 41: {
                    this.textBuffer.append('\"');
                    return TomlToken.STRING;
                }
                case 92: {
                    continue block108;
                }
                case 42: {
                    this.textBuffer.append('\'');
                    return TomlToken.STRING;
                }
                case 93: {
                    continue block108;
                }
                case 43: {
                    return TomlToken.FALSE;
                }
                case 94: {
                    continue block108;
                }
                case 44: {
                    this.textBuffer.append('\"');
                    this.textBuffer.append('\"');
                    return TomlToken.STRING;
                }
                case 95: {
                    continue block108;
                }
                case 45: {
                    this.textBuffer.append('\'');
                    this.textBuffer.append('\'');
                    return TomlToken.STRING;
                }
                case 96: {
                    continue block108;
                }
                case 46: {
                    this.appendUnicodeEscapeShort();
                }
                case 97: {
                    continue block108;
                }
                case 47: {
                    return TomlToken.LOCAL_TIME;
                }
                case 98: {
                    continue block108;
                }
                case 48: {
                    return TomlToken.LOCAL_DATE;
                }
                case 99: {
                    continue block108;
                }
                case 49: {
                    this.appendUnicodeEscapeLong();
                }
                case 100: {
                    continue block108;
                }
                case 50: {
                    return TomlToken.LOCAL_DATE_TIME;
                }
                case 101: {
                    continue block108;
                }
                case 51: {
                    return TomlToken.OFFSET_DATE_TIME;
                }
                case 102: {
                    continue block108;
                }
            }
            Lexer.zzScanError(1);
        }
    }
}

