/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.toml;

import io.micronaut.core.annotation.Internal;
import io.micronaut.toml.Lexer;
import io.micronaut.toml.TomlToken;
import java.io.IOException;

@Internal
public final class TomlStreamReadException
extends IOException {
    private static final int MAX_SNIPPET_LENGTH = 120;
    private final TomlLocation loc;

    TomlStreamReadException(String msg, TomlLocation loc) {
        super(msg);
        this.loc = loc;
    }

    TomlStreamReadException(String msg, TomlLocation loc, Throwable rootCause) {
        super(msg, rootCause);
        this.loc = loc;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            msg = "N/A";
        }
        if (this.loc != null) {
            StringBuilder sb = new StringBuilder(100);
            sb.append(msg);
            sb.append('\n');
            sb.append(" at ");
            sb.append("line: ").append(this.loc.line);
            sb.append(", column: ").append(this.loc.column);
            int snippetStart = (int)this.loc.charPosition;
            int snippetEnd = (int)this.loc.charPosition;
            if (snippetStart > 0) {
                snippetStart = this.loc.content.lastIndexOf(10, snippetStart - 1) + 1;
            }
            if ((snippetEnd = this.loc.content.indexOf(10, snippetEnd)) == -1) {
                snippetEnd = this.loc.content.length();
            }
            if (snippetEnd - snippetStart > 120) {
                snippetStart = Math.max(snippetStart, (int)this.loc.charPosition - 60);
                snippetEnd = Math.min(snippetEnd, snippetStart + 120);
            }
            String snippet = this.loc.content.substring(snippetStart, snippetEnd);
            snippet = snippet.replaceAll("[^\\x20-\\x7E]", "");
            sb.append('\n').append(snippet).append('\n');
            int i = 0;
            while ((long)i < this.loc.charPosition - (long)snippetStart) {
                sb.append(' ');
                ++i;
            }
            sb.append("^-- near here");
            msg = sb.toString();
        }
        return msg;
    }

    private static class TomlLocation {
        final String content;
        final long charPosition;
        final int line;
        final int column;

        TomlLocation(String content, long charPosition, int line, int column) {
            this.content = content;
            this.charPosition = charPosition;
            this.line = line;
            this.column = column;
        }
    }

    static class ErrorContext {
        private final String input;

        ErrorContext(String input) {
            this.input = input;
        }

        ErrorBuilder atPosition(Lexer lexer) {
            return new ErrorBuilder(lexer);
        }

        class ErrorBuilder {
            private final TomlLocation location;

            ErrorBuilder(Lexer lexer) {
                this.location = new TomlLocation(ErrorContext.this.input, lexer.getCharPos(), lexer.getLine() + 1, lexer.getColumn() + 1);
            }

            TomlStreamReadException unexpectedToken(TomlToken actual, String expected) {
                return new TomlStreamReadException("Unexpected token: Got " + actual + ", expected " + expected, this.location);
            }

            TomlStreamReadException generic(String message) {
                return new TomlStreamReadException(message, this.location);
            }

            TomlStreamReadException invalidNumber(NumberFormatException cause) {
                return new TomlStreamReadException("Invalid number representation", this.location, cause);
            }
        }
    }
}

