/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.toml.env;

import io.micronaut.context.env.AbstractPropertySourceLoader;
import io.micronaut.core.io.IOUtils;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.toml.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TomlPropertySourceLoader
extends AbstractPropertySourceLoader {
    public Set<String> getExtensions() {
        return Collections.singleton("toml");
    }

    protected void processInput(String name, InputStream input, Map<String, Object> finalMap) throws IOException {
        String text = IOUtils.readText((BufferedReader)new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)));
        JsonNode toml = Parser.parse(text);
        this.processMap(finalMap, (Map)this.unwrap(toml), "");
    }

    private Object unwrap(JsonNode value) {
        if (value.isNumber()) {
            return value.getNumberValue();
        }
        if (value.isNull()) {
            return null;
        }
        if (value.isBoolean()) {
            return value.getBooleanValue();
        }
        if (value.isArray()) {
            ArrayList unwrapped = new ArrayList();
            value.values().forEach(v -> unwrapped.add(this.unwrap((JsonNode)v)));
            return unwrapped;
        }
        if (value.isObject()) {
            LinkedHashMap unwrapped = new LinkedHashMap();
            value.entries().forEach(e -> unwrapped.put((String)e.getKey(), this.unwrap((JsonNode)e.getValue())));
            return unwrapped;
        }
        return value.getStringValue();
    }
}

